/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ResourceInDescriptionEntryReference;
import com.ibm.cics.core.model.ResourceInDescriptionEntryType;
import com.ibm.cics.core.model.internal.CPSMDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICPSMDefinitionContainer;
import com.ibm.cics.model.IResourceDescriptionDefinitionReference;
import com.ibm.cics.model.IResourceGroupDefinitionReference;
import com.ibm.cics.model.IResourceInDescriptionEntry;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class ResourceInDescriptionEntryGen
extends CPSMDefinition
implements IResourceInDescriptionEntry {
    private String _resdesc;
    private String _resgroup;
    private String _description;

    public ResourceInDescriptionEntryGen(ICPSMDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._resdesc = (String)avm.getAttributeValue(ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION);
        this._resgroup = (String)avm.getAttributeValue(ResourceInDescriptionEntryType.RESOURCE_GROUP);
        this._description = (String)avm.getAttributeValue(ResourceInDescriptionEntryType.DESCRIPTION, true);
    }

    public ResourceInDescriptionEntryGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("RESDESC");
        this._resdesc = (String)((CICSAttribute)ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION).get(stringValue, normalizers);
        stringValue = record.get("RESGROUP");
        this._resgroup = (String)((CICSAttribute)ResourceInDescriptionEntryType.RESOURCE_GROUP).get(stringValue, normalizers);
        stringValue = record.get("DESCRIPTION");
        this._description = (String)((CICSAttribute)ResourceInDescriptionEntryType.DESCRIPTION).get(stringValue, normalizers);
    }

    public String getResourceDescription() {
        return this._resdesc;
    }

    public String getResourceGroup() {
        return this._resgroup;
    }

    public String getDescription() {
        return this._description;
    }

    public ResourceInDescriptionEntryType getObjectType() {
        return ResourceInDescriptionEntryType.getInstance();
    }

    @Override
    public ResourceInDescriptionEntryReference getCICSObjectReference() {
        return new ResourceInDescriptionEntryReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION) {
            return (V)this.getResourceDescription();
        }
        if (attribute == ResourceInDescriptionEntryType.RESOURCE_GROUP) {
            return (V)this.getResourceGroup();
        }
        if (attribute == ResourceInDescriptionEntryType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        return super.getAttributeValue(attribute);
    }

    public IResourceGroupDefinitionReference getToResourceGroup() {
        return (IResourceGroupDefinitionReference)ResourceInDescriptionEntryType.TO_RESOURCE_GROUP.getTo((ICICSObject)this);
    }

    public IResourceDescriptionDefinitionReference getToResourceDescription() {
        return (IResourceDescriptionDefinitionReference)ResourceInDescriptionEntryType.TO_RESOURCE_DESCRIPTION.getTo((ICICSObject)this);
    }
}

