/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.ICICSOperation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCICSAction
implements ICICSAction {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String name;
    protected final Map<String, String> parameters = new HashMap<String, String>();
    private final CICSRelease validFrom;
    private final CICSRelease validTo;

    protected AbstractCICSAction() {
        this.validFrom = null;
        this.validTo = null;
    }

    protected AbstractCICSAction(String actionName) {
        this(actionName, null, null);
    }

    protected AbstractCICSAction(String actionName, CICSRelease validFrom, CICSRelease validTo) {
        this(actionName, new String[0][], validFrom, validTo);
    }

    protected AbstractCICSAction(String actionName, String[][] actionParameters) {
        this(actionName, actionParameters, null, null);
    }

    protected AbstractCICSAction(String actionName, String[][] actionParameters, CICSRelease validFrom, CICSRelease validTo) {
        this.name = actionName;
        String[][] stringArray = actionParameters;
        int n = actionParameters.length;
        int n2 = 0;
        while (n2 < n) {
            String[] parameter = stringArray[n2];
            String name = parameter[0];
            String value = parameter[1];
            this.parameters.put(name, value);
            ++n2;
        }
        this.validFrom = validFrom;
        this.validTo = validTo;
    }

    @Override
    public CICSRelease getValidFrom() {
        return this.validFrom;
    }

    @Override
    public CICSRelease getValidTo() {
        return this.validTo;
    }

    @Override
    public ICICSOperation.OperationType getOperationType() {
        return ICICSOperation.OperationType.PERFORM;
    }

    @Override
    public String getActionName() {
        return this.name;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getParameterNames().iterator();
    }

    @Override
    public Set<String> getParameterNames() {
        return Collections.unmodifiableSet(this.parameters.keySet());
    }

    @Override
    public String getParameterValue(String parameterName) {
        return this.parameters.get(parameterName);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getActionName() + "," + this.parameters + "]";
    }
}

