/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model;

import com.ibm.cics.model.ICICSAttributeAggregation;
import java.util.Map;
import java.util.Optional;

public class CICSNumericAttributeAggregation
implements ICICSAttributeAggregation {
    private final Optional<Long> min;
    private final Optional<Long> max;
    private final Optional<Double> avg;
    private final Optional<Long> sum;
    private final Optional<String> difference;
    private final int distinctValues;
    private final int unsupportedCount;
    private final int unspecifiedCount;
    private final Optional<Map.Entry<Long, Integer>> metaValue;

    public CICSNumericAttributeAggregation(Optional<Long> min, Optional<Long> max, Optional<Double> avg, Optional<Long> sum, Optional<String> difference, int distinctValues, int unsupportedCount, int unspecifiedCount, Optional<Map.Entry<Long, Integer>> metaValue) {
        this.min = min;
        this.max = max;
        this.avg = avg;
        this.sum = sum;
        this.difference = difference;
        this.distinctValues = distinctValues;
        this.unsupportedCount = unsupportedCount;
        this.unspecifiedCount = unspecifiedCount;
        this.metaValue = metaValue;
    }

    public int getUnsupportedCount() {
        return this.unsupportedCount;
    }

    public int getUnspecifiedCount() {
        return this.unspecifiedCount;
    }

    public Optional<Integer> getMetaCount(Long metaValue) {
        return this.metaValue.map(mV -> mV.getKey() == metaValue ? Optional.of((Integer)mV.getValue()) : Optional.empty()).orElse(Optional.empty());
    }

    public Optional<Long> getMin() {
        return this.min;
    }

    public Optional<Long> getMax() {
        return this.max;
    }

    public Optional<Double> getAverage() {
        return this.avg;
    }

    public Optional<Long> getSum() {
        return this.sum;
    }

    public Optional<String> getDifference() {
        return this.difference;
    }

    public int getDistinctValues() {
        return this.distinctValues;
    }
}

