/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model;

import com.ibm.cics.model.CICSDateAttributeAggregation;
import com.ibm.cics.model.CICSEnumAttributeAggregation;
import com.ibm.cics.model.CICSNumericAttributeAggregation;
import com.ibm.cics.model.CICSStringAttributeAggregation;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeAggregation;
import com.ibm.cics.model.ICICSEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CICSObjectAggregateRecord {
    Map<ICICSAttribute<?>, ICICSAttributeAggregation> aggregationMap = new HashMap();
    private int countOfAggregatedObjects;

    public CICSObjectAggregateRecord(int countOfAggregatedObjects) {
        this.countOfAggregatedObjects = countOfAggregatedObjects;
    }

    public void addAttributeAggregation(ICICSAttribute<?> attributeName, ICICSAttributeAggregation aggregation) {
        this.aggregationMap.put(attributeName, aggregation);
    }

    public CICSStringAttributeAggregation getStringAggregation(ICICSAttribute<String> attribute) {
        return (CICSStringAttributeAggregation)this.aggregationMap.get(attribute);
    }

    public CICSNumericAttributeAggregation getNumericAggregation(ICICSAttribute<Long> attribute) {
        return (CICSNumericAttributeAggregation)this.aggregationMap.get(attribute);
    }

    public CICSEnumAttributeAggregation getEnumerationAggregation(ICICSAttribute<? extends ICICSEnum> attribute) {
        return (CICSEnumAttributeAggregation)this.aggregationMap.get(attribute);
    }

    public CICSDateAttributeAggregation getDateAggregation(ICICSAttribute<Date> attribute) {
        return (CICSDateAttributeAggregation)this.aggregationMap.get(attribute);
    }

    public int getCountOfAggregatedObjects() {
        return this.countOfAggregatedObjects;
    }

    public String toString() {
        return "CICSObjectAggregateRecord@" + Integer.toHexString(this.hashCode()) + "[" + this.getCountOfAggregatedObjects() + " aggregated records, " + this.aggregationMap.size() + " attributes]";
    }
}

