/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class AggregatableTypes {
    private Map<String, Set<String>> supportedTypes = Collections.emptyMap();

    public AggregatableTypes(Map<String, Set<String>> supportedTypes) {
        this.supportedTypes = supportedTypes;
    }

    public boolean isAggregatableType(ICICSType<?> resourceType) {
        return this.isAggregatableType(resourceType.getResourceTableName());
    }

    public boolean isAggregatableType(String resourceType) {
        return this.supportedTypes.containsKey(resourceType) && this.supportedTypes.get(resourceType) != null && !this.supportedTypes.get(resourceType).isEmpty();
    }

    public boolean isAggregatableAttribute(ICICSType<?> resourceType, ICICSAttribute<?> attribute) {
        return this.isAggregatableAttribute(resourceType.getResourceTableName(), attribute);
    }

    public boolean isAggregatableAttribute(String resourceType, ICICSAttribute<?> attribute) {
        return this.isAggregatableType(resourceType) && this.supportedTypes.get(resourceType).contains(attribute.getPropertyId());
    }

    public Set<String> aggregatableAttributes(ICICSType<?> resourceType) {
        return this.supportedTypes.get(resourceType.getResourceTableName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.supportedTypes == null ? 0 : this.supportedTypes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregatableTypes other = (AggregatableTypes)obj;
        return !(this.supportedTypes == null ? other.supportedTypes != null : !this.supportedTypes.equals(other.supportedTypes));
    }
}

