/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.sm.comm.sm.internal.AggregatableTypes;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class CICSIntrospectionQueryParser {
    private static final Debug debug = new Debug(CICSIntrospectionQueryParser.class);

    public static AggregatableTypes parseIntrospectionQuery(JsonElement json) {
        return CICSIntrospectionQueryParser.parseIntrospectionQuery(json, "");
    }

    public static AggregatableTypes parseIntrospectionQuery(JsonElement json, String typeNameSuffix) {
        debug.enter("parseIntrospectionQuery", (Object)json);
        JsonArray typesArr = null;
        try {
            typesArr = json.getAsJsonObject().get("data").getAsJsonObject().get("__schema").getAsJsonObject().get("types").getAsJsonArray();
        }
        catch (JsonSyntaxException | IllegalStateException | NullPointerException e) {
            return null;
        }
        if (typesArr == null) {
            return new AggregatableTypes(Collections.emptyMap());
        }
        Map<String, Set<String>> supportedTypes = StreamSupport.stream(typesArr.spliterator(), false).map(typeElement -> CICSIntrospectionQueryParser.parseType(typeElement, typeNameSuffix)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (Set)entry.getValue()));
        debug.exit("parseIntrospectionQuery", supportedTypes);
        return new AggregatableTypes(supportedTypes);
    }

    public static Optional<AbstractMap.SimpleEntry<String, Set<String>>> parseType(JsonElement typeElement, String typeNameSuffix) {
        JsonObject typeObject = typeElement.getAsJsonObject();
        String name = typeObject.get("name").getAsString();
        if (!name.endsWith(typeNameSuffix)) {
            return Optional.empty();
        }
        name = name.substring(0, name.lastIndexOf(typeNameSuffix));
        JsonElement fieldsElem = typeObject.get("fields");
        Set fieldSet = Collections.emptySet();
        if (fieldsElem.isJsonNull()) {
            fieldSet = null;
        } else {
            JsonArray fieldsArr = fieldsElem.getAsJsonArray();
            fieldSet = StreamSupport.stream(fieldsArr.spliterator(), false).map(jsonElement -> jsonElement.getAsJsonObject().get("name").getAsString()).collect(Collectors.toSet());
        }
        return Optional.of(new AbstractMap.SimpleEntry(name, fieldSet));
    }
}

