/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.IFilterVisitor;
import com.ibm.cics.sm.comm.IComplexFilteredContext;
import com.ibm.cics.sm.comm.ICompoundFilteredContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.sm.internal.SMCPSMComplexFilterVisitor;

public class WorkingCriteria {
    private static final Debug debug = new Debug(WorkingCriteria.class);
    private static final String ALL_CSD_GROUPS = "*";
    private final String csdGroup;
    private final String criteria;

    private WorkingCriteria(String criteria, String csdGroup) {
        this.criteria = criteria;
        this.csdGroup = csdGroup;
    }

    public static WorkingCriteria nullCriteria() {
        return new WorkingCriteria("", null){

            @Override
            public WorkingCriteria or(WorkingCriteria other) {
                return super.and(other);
            }
        };
    }

    public static WorkingCriteria criterion(String name, String value, FilterExpression.AttributeOperator operator) {
        if ("CSDGROUP".equals(name) && FilterExpression.AttributeOperator.IS == operator && "".equals(value)) {
            return WorkingCriteria.nullCriteria();
        }
        String criteria = String.valueOf(WorkingCriteria.cmciEscape(name)) + WorkingCriteria.getOperator(operator) + "'" + WorkingCriteria.cmciEscape(value) + "'";
        String csdGroup = "CSDGROUP".equals(name) ? ((operator == FilterExpression.AttributeOperator.EQ || operator == FilterExpression.AttributeOperator.IS) && !"".equals(value) ? value : ALL_CSD_GROUPS) : null;
        return new WorkingCriteria(criteria, csdGroup);
    }

    private static String getOperator(FilterExpression.AttributeOperator operator) {
        switch (operator) {
            case EQ: {
                return "=";
            }
            case GE: {
                return ">=";
            }
            case GT: {
                return ">";
            }
            case IS: {
                return "==";
            }
            case LE: {
                return "<=";
            }
            case LT: {
                return "<";
            }
            case NE: {
                return "\u00ac=";
            }
        }
        throw new RuntimeException("Unknown operator:" + operator);
    }

    public WorkingCriteria and(WorkingCriteria other) {
        String newCriteria = this.join(other.getCriteria(), FilterExpression.CompositeOperator.AND);
        String newCSDGroup = other.csdGroup != null ? (this.csdGroup == null ? other.csdGroup : (!this.csdGroup.equals(other.csdGroup) ? ALL_CSD_GROUPS : this.csdGroup)) : this.csdGroup;
        return new WorkingCriteria(newCriteria, newCSDGroup);
    }

    public WorkingCriteria or(WorkingCriteria other) {
        String newCriteria = this.join(other.getCriteria(), FilterExpression.CompositeOperator.OR);
        String newCSDGroup = this.csdGroup == null || other.csdGroup == null ? (this.csdGroup == other.csdGroup ? null : ALL_CSD_GROUPS) : (this.csdGroup.equals(other.csdGroup) ? this.csdGroup : ALL_CSD_GROUPS);
        return new WorkingCriteria(newCriteria, newCSDGroup);
    }

    private String join(String other, FilterExpression.CompositeOperator op) {
        String operator = this.getOperator(op);
        String newCriteria = other.length() > 0 ? (this.criteria.length() > 0 ? String.valueOf('(') + this.criteria + ')' + operator + '(' + other + ')' : other) : this.criteria;
        return newCriteria;
    }

    private String getOperator(FilterExpression.CompositeOperator op) {
        switch (op) {
            case AND: {
                return " AND ";
            }
            case OR: {
                return " OR ";
            }
        }
        throw new RuntimeException("Unrecognized composition operator:" + op);
    }

    public String getCriteria() {
        return this.criteria;
    }

    public String getCsdGroup() {
        return this.csdGroup;
    }

    public WorkingCriteria not() {
        return new WorkingCriteria("NOT(" + this.criteria + ")", this.csdGroup);
    }

    private static String cmciEscape(String value) {
        value = value.replaceAll("'", "''");
        return value;
    }

    public static WorkingCriteria getWorkingCriteriaFromFilteredContext(IFilteredContext filteredContext) {
        WorkingCriteria criteria = WorkingCriteria.nullCriteria();
        FilterExpression.AttributeOperator op = filteredContext instanceof IPrimaryKey ? FilterExpression.AttributeOperator.IS : FilterExpression.AttributeOperator.EQ;
        for (String name : filteredContext.getAttributeNames()) {
            String value = filteredContext.getAttributeValue(name);
            criteria = criteria.and(WorkingCriteria.criterion(name, value, op));
        }
        return criteria;
    }

    public static WorkingCriteria getWorkingCriteriaFromCompoundFilteredContext(ICompoundFilteredContext compoundFilteredContext) {
        debug.enter("getCriteriaFromCompoundFilteredContext", (Object)compoundFilteredContext);
        WorkingCriteria compoundCriteria = WorkingCriteria.nullCriteria();
        for (IFilteredContext filteredContext : compoundFilteredContext) {
            compoundCriteria = compoundCriteria.or(WorkingCriteria.getWorkingCriteriaFromFilteredContext(filteredContext));
        }
        debug.exit("getCriteriaFromCompoundFilteredContext", (Object)compoundCriteria);
        return compoundCriteria;
    }

    public static WorkingCriteria getWorkingCriteriaFromComplexFilteredContext(IComplexFilteredContext filteredContext) {
        SMCPSMComplexFilterVisitor visitor = new SMCPSMComplexFilterVisitor();
        if (filteredContext.getFilterExpression() != null) {
            filteredContext.getFilterExpression().accept((IFilterVisitor)visitor);
        }
        return visitor.getWorkingCriteria();
    }

    /* synthetic */ WorkingCriteria(String string, String string2, WorkingCriteria workingCriteria) {
        this(string, string2);
    }
}

