/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsArrayContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.DocumentAppender;
import java.util.function.Consumer;

public class ArgumentsContext {
    private boolean hasArgs;
    private final DocumentAppender contents;

    public ArgumentsContext(DocumentAppender contents) {
        this.contents = contents;
    }

    private void appendArgName(String name) {
        if (this.hasArgs) {
            this.contents.append(' ');
        }
        this.hasArgs = true;
        this.contents.append(name);
        this.contents.append(':');
    }

    public ArgumentsContext argLong(String name, long value) {
        this.appendArgName(name);
        this.contents.append(value);
        return this;
    }

    public ArgumentsContext argEnum(String name, String enumValue) {
        this.appendArgName(name);
        this.contents.append(enumValue);
        return this;
    }

    public ArgumentsContext argString(String name, String stringValue) {
        this.appendArgName(name);
        this.contents.append('\"');
        this.contents.append(stringValue);
        this.contents.append('\"');
        return this;
    }

    public ArgumentsContext argComplex(String name, Consumer<ArgumentsContext> inputType) {
        this.appendArgName(name);
        this.contents.append('{');
        inputType.accept(new ArgumentsContext(this.contents));
        this.contents.append('}');
        return this;
    }

    public ArgumentsContext argArray(String name, Consumer<ArgumentsArrayContext> inputType) {
        this.appendArgName(name);
        this.contents.append('[');
        inputType.accept(new ArgumentsArrayContext(this.contents));
        this.contents.append(']');
        return this;
    }
}

