/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.google.gson.JsonElement;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseRuntimeException;
import java.util.Optional;

abstract class ValueParser<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    ValueParser() {
    }

    public Optional<T> parse(JsonElement value) throws ValueParseException {
        if (value == null || value.isJsonNull()) {
            return Optional.empty();
        }
        return Optional.of(this.parseValue(value));
    }

    protected abstract T parseValue(JsonElement var1) throws ValueParseException;

    static class ValueParseException
    extends Exception {
        public ValueParseException(String message) {
            super(message);
        }

        public ValueParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public NodeParseRuntimeException toNodeParseRuntimeException(String property) {
            return new NodeParseRuntimeException("Failed to parse property '" + property + "'", this);
        }
    }
}

