/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.offline;

import com.ibm.cics.core.model.internal.AbstractCICSObjectContainer;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IFilterVisitor;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.topology.CPSM;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class OfflineCICSObjectContainer<E extends ICICSObject>
extends AbstractCICSObjectContainer<E> {
    private final Map<ICICSType<? extends E>, TreeMap<? extends ICICSObjectReference<?>, ? extends E>> contents = new HashMap();
    private final String description;
    private CPSM cpsm;

    public OfflineCICSObjectContainer(String description, CPSM cpsm) {
        this.description = description;
        this.cpsm = cpsm;
    }

    public CPSM getCPSM() {
        return this.cpsm;
    }

    public String getDescription() {
        return this.description;
    }

    public <T extends E> void add(ICICSType<T> type, T instance) {
        TreeMap<ICICSObjectReference<?>, T> objects = this.getObjects(type);
        objects.put(instance.getCICSObjectReference(), instance);
    }

    public <T extends E> T resolve(ICICSObjectReference<T> reference) throws CICSActionException {
        TreeMap<ICICSObjectReference<?>, T> objects = this.getObjects(reference.getCICSType());
        return (T)(objects != null ? (ICICSObject)objects.get(reference) : null);
    }

    private <T extends E> TreeMap<ICICSObjectReference<?>, T> getObjects(ICICSType<T> type) {
        TreeMap<Object, Object> cachedObjects = this.contents.get(type);
        if (cachedObjects == null) {
            cachedObjects = new TreeMap();
            this.contents.put(type, cachedObjects);
        }
        return cachedObjects;
    }

    protected <X extends E> AbstractCICSObjectContainer.IObjectGetter<X> getGetter(ICICSType<X> type, FilterExpression filterExpression) {
        return new OfflineObjectGetter<X>(type, filterExpression);
    }

    public <X extends E> void delete(ICICSType<X> type, FilterExpression filterExpression) throws CICSActionException {
        throw new CICSActionException("Delete is not supported in this context");
    }

    private static final class OfflineFilterVisitor<X extends ICICSObject>
    implements IFilterVisitor {
        private Stack<Map<ICICSObjectReference<?>, X>> stack = new Stack();
        private final Collector<Map.Entry<? extends ICICSObjectReference<?>, X>, ?, TreeMap<ICICSObjectReference<?>, X>> TREE_MAP_COLLECTOR = Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, TreeMap::new);
        private Map<ICICSObjectReference<?>, X> records;

        public OfflineFilterVisitor(Map<ICICSObjectReference<?>, X> records) {
            this.records = records;
        }

        public List<X> getRecords() {
            return new ArrayList<X>((this.stack.isEmpty() ? this.records : this.stack.pop()).values());
        }

        public void or() {
            Map<ICICSObjectReference<?>, X> s1 = this.stack.pop();
            Map<ICICSObjectReference<?>, X> s2 = this.stack.pop();
            TreeMap result = new TreeMap(s1);
            result.putAll(s2);
            this.stack.push(result);
        }

        public void not() {
            Map s = this.stack.pop();
            this.stack.push((Map)this.records.entrySet().stream().filter(r -> !s.containsKey(r.getKey())).collect(this.TREE_MAP_COLLECTOR));
        }

        public void and() {
            Map<ICICSObjectReference<?>, X> s1 = this.stack.pop();
            Map<ICICSObjectReference<?>, X> s2 = this.stack.pop();
            TreeMap s3 = new TreeMap(s1);
            s3.keySet().retainAll(s2.keySet());
            this.stack.push(s3);
        }

        public <A> void ne(ICICSAttribute<A> attribute, A value) {
            throw new UnsupportedOperationException();
        }

        public <A> void lt(ICICSAttribute<A> attribute, A value) {
            throw new UnsupportedOperationException();
        }

        public <A> void le(ICICSAttribute<A> attribute, A value) {
            throw new UnsupportedOperationException();
        }

        public <A> void is(ICICSAttribute<A> attribute, A value) {
            this.stack.push((Map)this.records.entrySet().stream().filter(recordEntry -> {
                Object attrVal = ((ICICSObject)recordEntry.getValue()).getAttributeValue((IAttribute)attribute);
                return attrVal != null && attrVal.equals(value);
            }).collect(this.TREE_MAP_COLLECTOR));
        }

        public <A> void gt(ICICSAttribute<A> attribute, A value) {
            throw new UnsupportedOperationException();
        }

        public <A> void ge(ICICSAttribute<A> attribute, A value) {
            throw new UnsupportedOperationException();
        }

        public <A> void eq(ICICSAttribute<A> attribute, A value) {
            throw new UnsupportedOperationException();
        }
    }

    private class OfflineObjectGetter<X extends E>
    implements AbstractCICSObjectContainer.IObjectGetter<X> {
        private ICICSType<X> type;
        private FilterExpression filterExpression;
        private List<X> records;

        public OfflineObjectGetter(ICICSType<X> type, FilterExpression filterExpression) {
            this.type = type;
            this.filterExpression = filterExpression;
        }

        public ICICSType<X> getCICSType() {
            return this.type;
        }

        public int get() throws CICSActionException {
            Map allRecords = Collections.unmodifiableMap(OfflineCICSObjectContainer.this.getObjects(this.type));
            if (this.filterExpression == null) {
                this.records = Collections.unmodifiableList(new ArrayList(allRecords.values()));
            } else {
                OfflineFilterVisitor visitor = new OfflineFilterVisitor(allRecords);
                this.filterExpression.accept(visitor);
                this.records = Collections.unmodifiableList(visitor.getRecords());
            }
            return this.records.size();
        }

        public List<X> fetch(int start, int count) throws CICSActionException {
            if (this.records == null) {
                throw new IllegalArgumentException("Not activated");
            }
            return this.records.subList(start, start + count);
        }

        public void discard() throws CICSActionException {
        }

        public List<X> getAll() throws CICSActionException {
            if (this.records == null) {
                this.get();
            }
            return this.records;
        }
    }
}

