/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.common.util.StaleableEventListener;
import com.ibm.cics.core.connections.ConnectionProfile;

public abstract class ConnectionManagerListener
extends StaleableEventListener<ConnectionManagerEvent> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static abstract class ConnectionManagerEvent {
        private final ConnectionProfile configuration;

        public ConnectionManagerEvent(ConnectionProfile configuration) {
            this.configuration = configuration;
        }

        public ConnectionProfile getConnectionProfile() {
            return this.configuration;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.configuration == null ? 0 : this.configuration.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ConnectionManagerEvent)) {
                return false;
            }
            ConnectionManagerEvent other = (ConnectionManagerEvent)obj;
            return !(this.configuration == null ? other.configuration != null : !this.configuration.equals(other.configuration));
        }
    }

    public static class ConnectionProfileAddedEvent
    extends ConnectionManagerEvent {
        public ConnectionProfileAddedEvent(ConnectionProfile addedConfiguration) {
            super(addedConfiguration);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class ConnectionProfileRemovedEvent
    extends ConnectionManagerEvent {
        public ConnectionProfileRemovedEvent(ConnectionProfile removedConfiguration) {
            super(removedConfiguration);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return super.equals(obj);
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class ConnectionProfileUpdatedEvent
    extends ConnectionManagerEvent {
        private final ConnectionProfile oldConnectionProfile;

        public ConnectionProfileUpdatedEvent(ConnectionProfile oldConfiguration, ConnectionProfile newConfiguration) {
            super(newConfiguration);
            this.oldConnectionProfile = oldConfiguration;
        }

        public ConnectionProfile getOldConnectionProfile() {
            return this.oldConnectionProfile;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.oldConnectionProfile == null ? 0 : this.oldConnectionProfile.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionProfileUpdatedEvent other = (ConnectionProfileUpdatedEvent)obj;
            return !(this.oldConnectionProfile == null ? other.oldConnectionProfile != null : !this.oldConnectionProfile.equals(other.oldConnectionProfile));
        }
    }
}

