/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.connections.internal.CertificateComposite;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.eclipse.common.ui.TextInput;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractCredentialsComposite
extends Composite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text credentialsText;
    private Text userIDText;
    private String hostName;
    boolean credentialsIsDefaultValue = true;

    public AbstractCredentialsComposite(Composite parent, String hostName, boolean addCredentialsTextbox) {
        super(parent, 0);
        this.hostName = hostName;
        GridLayout gridLayout = new GridLayout(3, false);
        this.setLayout((Layout)gridLayout);
        GridData data = new GridData(4, 4, false, true);
        data.verticalIndent = 20;
        this.setLayoutData(data);
        if (addCredentialsTextbox) {
            this.addCredentialsTextbox();
        }
        this.addUsernameTextbox();
    }

    private void addCredentialsTextbox() {
        Label l = new Label((Composite)this, 0);
        l.setText(Messages.PasswordComposite_credentialsLabel);
        this.credentialsText = new Text((Composite)this, 2048);
        TextInput.setAccessibleLabel((Text)this.credentialsText, (Label)l);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        data.widthHint = 250;
        this.credentialsText.setLayoutData((Object)data);
    }

    private void addUsernameTextbox() {
        new Label((Composite)this, 0);
        Label l = new Label((Composite)this, 0);
        l.setText(Messages.PasswordComposite_userId);
        this.userIDText = new Text((Composite)this, 2048);
        TextInput.setAccessibleLabel((Text)this.userIDText, (Label)l);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        data.widthHint = 250;
        this.userIDText.setLayoutData((Object)data);
        if (this instanceof CertificateComposite) {
            ControlDecoration controlDecoration = new ControlDecoration((Control)this.userIDText, 0x1004000);
            controlDecoration.setImage(Activator.getImage((String)"INFO_OVERLAY"));
            controlDecoration.setDescriptionText(Messages.AbstractCredentialsComposite_userIdIsRequired);
            this.userIDText.setData("INFO_DECORATION", (Object)controlDecoration);
        }
    }

    public void addListeners(ModifyListener controlModifyListener) {
        this.userIDText.addModifyListener(controlModifyListener);
        if (this.credentialsText != null) {
            this.credentialsText.addModifyListener(controlModifyListener);
        }
    }

    public void setCredentialsIsDefaultValue(boolean isDefaultValue) {
        this.credentialsIsDefaultValue = isDefaultValue;
    }

    public void setCredentialsName(String credentialsName) {
        this.credentialsText.setText(credentialsName);
    }

    public void setEnabled(boolean enabled) {
        this.credentialsText.setEnabled(enabled);
        this.userIDText.setEnabled(enabled);
        this.userIDText.setFocus();
    }

    public void setUserID(String userID) {
        this.userIDText.setText(userID);
    }

    public void setEditable(boolean aBoolean) {
        this.userIDText.setEditable(aBoolean);
    }

    public String getUserID() {
        return this.userIDText.getText().trim();
    }

    public Text getUserIdText() {
        return this.userIDText;
    }

    public void setUserIdTextFocus() {
        this.userIDText.setFocus();
    }

    public void selectAllUserId() {
        this.userIDText.selectAll();
    }

    public String getCredentialsName() {
        if (this.credentialsText != null) {
            return this.credentialsText.getText();
        }
        return "";
    }

    public Text getCredentialsText() {
        return this.credentialsText;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void dispose() {
        if (this.getCredentialsText() != null) {
            this.credentialsText.dispose();
        }
        this.userIDText.dispose();
        super.dispose();
    }

    public void setUserIdAndCredentialsEnabled(boolean enabled) {
        this.userIDText.setEnabled(enabled);
        this.credentialsText.setEnabled(enabled);
    }

    public abstract String getTitleMessage();
}

