/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.ExplorerKeyStore;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.core.connections.internal.AbstractCredentialsComposite;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.eclipse.common.editor.TitleAreaDialogErrorStateManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class CertificateComposite
extends AbstractCredentialsComposite {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Combo keyStoreFileCertificateList;
    private HashMap<String, CertificateDetails> certificateMap;
    private String certificateSource;
    private Label issuer;
    private Label expiry;
    private Label subject;
    private Composite certificateDetailsSection;
    String errorMessageLoadingCertificates = null;

    public CertificateComposite(Composite parent, String hostName, boolean addCredentialsTextbox, String certificateSource) {
        super(parent, hostName, addCredentialsTextbox);
        this.certificateSource = certificateSource;
        new Label((Composite)this, 0);
        Label l = new Label((Composite)this, 0);
        l.setText(Messages.CertificateComposite_chooseCertificate);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 20;
        data.widthHint = 250;
        this.keyStoreFileCertificateList = new Combo((Composite)this, 8);
        this.keyStoreFileCertificateList.setLayoutData((Object)data);
        this.keyStoreFileCertificateList.setEnabled(true);
        this.certificateMap = new HashMap();
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        this.certificateDetailsSection = this.createCertificateDetailsSection();
        this.certificateDetailsSection.setVisible(false);
    }

    @Override
    public void addListeners(ModifyListener controlModifyListener) {
        super.addListeners(controlModifyListener);
        this.keyStoreFileCertificateList.addModifyListener(controlModifyListener);
        if (this.getCredentialsText() != null) {
            this.getCredentialsText().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (CertificateComposite.this.credentialsIsDefaultValue && CertificateComposite.this.getCertificate() != null && !CertificateComposite.this.getCredentialsName().equals(CertificateComposite.this.getCertificateDisplayName(CertificateComposite.this.getCertificate()))) {
                        CertificateComposite.this.credentialsIsDefaultValue = false;
                    }
                }
            });
        }
        this.keyStoreFileCertificateList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (CertificateComposite.this.credentialsIsDefaultValue && CertificateComposite.this.getCredentialsText() != null && CertificateComposite.this.getCertificate() != null) {
                    CertificateComposite.this.getCredentialsText().setText(CertificateComposite.this.getCertificateDisplayName(CertificateComposite.this.getCertificate()));
                    CertificateComposite.this.setCertificateDetails();
                }
            }
        });
    }

    private String addCertificateToList(CertificateDetails certificate) {
        String string = this.getCertificateDisplayName(certificate);
        this.certificateMap.put(string, certificate);
        this.keyStoreFileCertificateList.add(string);
        return string;
    }

    private String getCertificateDisplayName(CertificateDetails certificate) {
        return String.valueOf(certificate.getSubject()) + " @ " + certificate.getIssuer() + " (" + certificate.getAlias() + ")";
    }

    public CertificateDetails getCertificate() {
        if (this.keyStoreFileCertificateList.getSelectionIndex() > -1) {
            return this.certificateMap.get(this.keyStoreFileCertificateList.getItem(this.keyStoreFileCertificateList.getSelectionIndex()));
        }
        return null;
    }

    public Combo getCertificateCombo() {
        return this.keyStoreFileCertificateList;
    }

    void selectCertificate(CertificateDetails credential) {
        String credentialAlias = null;
        for (Map.Entry<String, CertificateDetails> cert : this.certificateMap.entrySet()) {
            if (!cert.getValue().equals((Object)credential)) continue;
            credentialAlias = cert.getKey();
        }
        if (credentialAlias == null) {
            credentialAlias = this.addCertificateToList(credential);
        }
        String[] items = this.keyStoreFileCertificateList.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(credentialAlias)) {
                this.keyStoreFileCertificateList.select(i);
            }
            ++i;
        }
        this.setCertificateDetails();
    }

    public void selectCertificate(CredentialsConfiguration credentialsConfiguration) {
        CertificateDetails credential = credentialsConfiguration.getCertificate();
        this.selectCertificate(credential);
    }

    public boolean validateCertificate(TitleAreaDialogErrorStateManager errorStateManager, Widget widgetEventOriginatedFrom) {
        boolean error = false;
        if (this.errorMessageLoadingCertificates != null) {
            errorStateManager.recordSevereError(this.errorMessageLoadingCertificates, (Control)this.getCertificateCombo());
            error = true;
        } else if (this.getCertificate() == null) {
            errorStateManager.recordSevereError(Messages.CredentialsDialog_noCertificateSelected, (Control)this.getCertificateCombo());
            error = true;
        }
        return error;
    }

    public void populateCertificates(TitleAreaDialogErrorStateManager errorStateManager) {
        this.certificateMap.clear();
        this.keyStoreFileCertificateList.removeAll();
        try {
            ExplorerKeyStore keyStore = ExplorerSecurityHelper.getKeyStore((String)this.certificateSource);
            List certificates = keyStore.getKeyStoreCertificates();
            for (CertificateDetails certificate : certificates) {
                this.addCertificateToList(certificate);
            }
            this.errorMessageLoadingCertificates = null;
        }
        catch (IOException | GeneralSecurityException e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = String.valueOf(message) + " (" + e.getCause().getMessage() + ")";
            }
            this.errorMessageLoadingCertificates = message;
            errorStateManager.recordSevereError(message, (Control)this.getCertificateCombo());
        }
    }

    public String getCertificateSource() {
        return this.certificateSource;
    }

    private void setCertificateDetails() {
        this.subject.setText(this.getCertificate().getSubject());
        this.issuer.setText(this.getCertificate().getIssuer());
        Date expiryDate = this.getCertificate().getExpiryDate();
        String formattedDate = expiryDate == null ? Messages.CertificateComposite_unknownExpiryDate : DateFormat.getDateInstance().format(expiryDate);
        this.expiry.setText(formattedDate);
        this.certificateDetailsSection.setVisible(true);
    }

    private Composite createCertificateDetailsSection() {
        Composite detailsSection = new Composite((Composite)this, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginLeft = 0;
        detailsSection.setLayout((Layout)gridLayout);
        GridData sectionData = new GridData(4, 4, true, true);
        sectionData.horizontalSpan = 2;
        sectionData.horizontalIndent = 20;
        detailsSection.setLayoutData((Object)sectionData);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 0;
        data.widthHint = 250;
        Label subjectLabel = new Label(detailsSection, 0);
        subjectLabel.setText(Messages.CertificateComposite_subject);
        this.subject = new Label(detailsSection, 0);
        this.subject.setLayoutData((Object)data);
        Label issuerLabel = new Label(detailsSection, 0);
        issuerLabel.setText(Messages.CertificateComposite_issuer);
        this.issuer = new Label(detailsSection, 0);
        this.issuer.setLayoutData((Object)data);
        Label expiryLabel = new Label(detailsSection, 0);
        expiryLabel.setText(Messages.CertificateComposite_expiryDate);
        this.expiry = new Label(detailsSection, 0);
        this.expiry.setLayoutData((Object)data);
        return detailsSection;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getCredentialsText() != null) {
            this.getCredentialsText().setEnabled(enabled);
        }
        this.keyStoreFileCertificateList.setEnabled(enabled);
    }

    @Override
    public void dispose() {
        this.keyStoreFileCertificateList.dispose();
        super.dispose();
    }

    @Override
    public String getTitleMessage() {
        return Messages.CertificateComposite_chooseACertificate;
    }
}

