/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.internal.ConnectionCustomizerDescriptor;
import com.ibm.cics.core.connections.internal.IConnectionCustomizerDescriptor;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ConnectionCustomizerRegistry {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ConnectionCustomizerRegistry.class);
    public static final String TAG_CUSTOMIZER = "customizer";
    public static final String ATT_ID = "id";
    public static final String ATT_NAME = "name";
    public static final String ATT_CONNECTIONID = "connectionId";
    private Set<IConnectionCustomizerDescriptor> customizers = new HashSet<IConnectionCustomizerDescriptor>();

    public ConnectionCustomizerRegistry() {
        this.readExtensionPoint();
        Set descriptorsFromOldPlugin = null;
        Bundle uiBundle = Platform.getBundle((String)"com.ibm.cics.core.ui");
        if (uiBundle != null) {
            try {
                Class oldConnectionCustomizerRegistryClass = uiBundle.loadClass("com.ibm.cics.core.ui.ConnectionCustomizerRegistry");
                Object oldConnectionCustomizer = oldConnectionCustomizerRegistryClass.newInstance();
                Method method = oldConnectionCustomizerRegistryClass.getMethod("getConnectionCustomizers", new Class[0]);
                descriptorsFromOldPlugin = (Set)method.invoke(oldConnectionCustomizer, new Object[0]);
            }
            catch (Exception ex) {
                debug.error("<constructor>", "Error loading connection customizers from com.ibm.cics.core.ui", (Throwable)ex);
            }
        } else {
            debug.event("<constructor>", "com.ibm.cics.core.ui plugin connection customizers not loaded as plugin absent");
        }
        if (descriptorsFromOldPlugin != null) {
            this.customizers.addAll(descriptorsFromOldPlugin);
        }
    }

    private void readExtensionPoint() {
        IExtensionPoint oldExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.ibm.cics.core.connections", "connectionCustomizers");
        IExtension[] oldExtensions = oldExtensionPoint.getExtensions();
        this.readExtensions(oldExtensions);
    }

    private void readExtensions(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(TAG_CUSTOMIZER)) {
                    this.customizers.add(new ConnectionCustomizerDescriptor(element));
                }
                ++n4;
            }
            ++n2;
        }
    }

    public IConnectionCustomizerDescriptor find(String connectionId) {
        for (IConnectionCustomizerDescriptor connection : this.customizers) {
            if (!connection.getConnectionId().equals(connectionId)) continue;
            return connection;
        }
        return null;
    }
}

