/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.EnhancedConnectionException;
import com.ibm.cics.core.connections.internal.Messages;
import java.text.MessageFormat;

public class ConnectionExceptionMessageHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String getMessage(Exception connectionException, String connectionName) {
        String message;
        if (connectionException instanceof EnhancedConnectionException) {
            message = connectionException.getLocalizedMessage();
        } else if (connectionException.getCause() == null) {
            String exceptionMessage = connectionException.getLocalizedMessage();
            message = MessageFormat.format(Messages.ConnectionExceptionMessageHelper_IZE0106E_failedWithError, exceptionMessage == null ? "null" : exceptionMessage, connectionName);
        } else {
            message = MessageFormat.format(Messages.ConnectionExceptionMessageHelper_IZE0105E_failedWithException, connectionException.getCause().getLocalizedMessage());
        }
        return message;
    }
}

