/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.IDFactory;
import com.ibm.cics.common.util.LabelUtil;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.CertificateDetails;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConfigurationUtils;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.AbstractCredentialDialog;
import com.ibm.cics.core.connections.internal.ConnectionManager;
import com.ibm.cics.core.connections.internal.ConnectionUtils;
import com.ibm.cics.core.connections.internal.CredentialsMode;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.PasswordComposite;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PasswordDialog
extends AbstractCredentialDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ConnectionProfile config;
    private ConnectionManager connectionManager;
    private boolean supportsCertificateAuth;
    private boolean supportsMfaAuth;

    public PasswordDialog(Shell parentShell, String configurationId, ICredentialsManager credentialsManager, ConnectionManager connectionManager) {
        super(parentShell);
        this.credentialsManager = credentialsManager;
        this.config = connectionManager.getConnectionProfile(configurationId);
        this.connectionManager = connectionManager;
        this.supportsCertificateAuth = this.config.getConnectionDescriptor().isCertificateAuth() && Boolean.parseBoolean(this.config.getAttribute("ATTEMPT_SECURE"));
        this.supportsMfaAuth = this.config.getConnectionDescriptor().isMFAAuth();
        Collection<CredentialsConfiguration> credentialList = credentialsManager.getAllCredentials();
        if (!this.supportsCertificateAuth) {
            this.removeCertificateCredentials(credentialList);
        }
        if (!this.supportsMfaAuth) {
            this.removeMfaCredentials(credentialList);
        }
        this.credentialsConfiguration = this.config.getCredentials();
        if (credentialList.isEmpty()) {
            this.credentialsMode = CredentialsMode.CREATE_FIRST_CREDENTIAL;
        } else if (this.credentialsConfiguration == null) {
            this.credentialsMode = CredentialsMode.CREATE_OR_SELECT_CREDENTIAL;
        } else {
            this.credentialsMode = CredentialsMode.AUTHENTICATE_CREDENTIAL;
            this.supportsCertificateAuth = false;
        }
    }

    private void removeCertificateCredentials(Collection<CredentialsConfiguration> configs) {
        ArrayList<CredentialsConfiguration> toRemove = new ArrayList<CredentialsConfiguration>();
        for (CredentialsConfiguration credentialsConfiguration : configs) {
            if (credentialsConfiguration.getCertificate() == null) continue;
            toRemove.add(credentialsConfiguration);
        }
        configs.removeAll(toRemove);
    }

    private void removeMfaCredentials(Collection<CredentialsConfiguration> configs) {
        ArrayList<CredentialsConfiguration> toRemove = new ArrayList<CredentialsConfiguration>();
        for (CredentialsConfiguration credentialsConfiguration : configs) {
            if (!credentialsConfiguration.isOneTimePassword()) continue;
            toRemove.add(credentialsConfiguration);
        }
        configs.removeAll(toRemove);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        String userID;
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        childArea.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginRight = 20;
        gridLayout.marginLeft = 20;
        childArea.setLayout((Layout)gridLayout);
        Collection<CredentialsConfiguration> credentialList = this.credentialsManager.getAllCredentials();
        if (!this.supportsCertificateAuth) {
            this.removeCertificateCredentials(credentialList);
        }
        if (!this.supportsMfaAuth) {
            this.removeMfaCredentials(credentialList);
        }
        this.passwordComposite = new PasswordComposite(childArea, true, this.credentialsManager.isPasswordSaveable(), this.credentialsMode, credentialList, this.supportsCertificateAuth, this.supportsMfaAuth, this.credentialsConfiguration, this.errorStateManager);
        this.usernameAndPasswordComposite = this.passwordComposite.getUsernameAndPasswordComposite();
        this.oneTimePasswordComposite = this.passwordComposite.getOneTimePasswordComposite();
        this.keystoreComposite = this.passwordComposite.getKeystoreComposite();
        this.smartcardComposite = this.passwordComposite.getSmartcardComposite();
        GridData data = new GridData(4, 4, true, true);
        this.passwordComposite.setLayoutData(data);
        if (this.credentialsMode == CredentialsMode.AUTHENTICATE_CREDENTIAL && this.config.getCredentials() != null) {
            this.passwordComposite.getCurrentCredentialsComposite().setCredentialsIsDefaultValue(ConnectionUtils.generateName(this.config.getName(), IDFactory.getUserid8()).equals(this.credentialsConfiguration.getName()));
        }
        this.passwordComposite.setHostName(ConfigurationUtils.getHost(this.config));
        this.passwordComposite.setConnectionDescription(this.config.getName());
        this.usernameAndPasswordComposite.setSavePassword(this.credentialsConfiguration != null ? this.credentialsConfiguration.isSavePassword() : false);
        String string = userID = this.credentialsConfiguration != null ? this.credentialsConfiguration.getUserID() : null;
        if (StringUtil.hasContent((String)userID)) {
            this.passwordComposite.getCurrentCredentialsComposite().setUserID(userID);
        }
        this.passwordComposite.setCredentials(this.config.getCredentials());
        if (this.credentialsConfiguration != null && this.credentialsConfiguration.getPassword() != null) {
            this.usernameAndPasswordComposite.setPassword(this.credentialsConfiguration.getPassword());
        }
        GridLayout layout = (GridLayout)this.passwordComposite.getLayout();
        layout.marginTop = 10;
        layout.marginBottom = 10;
        layout.marginRight = 10;
        layout.marginLeft = 10;
        this.passwordComposite.setInitialFocus();
        this.passwordComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordDialog.this.validate(e == null ? null : e.widget);
            }
        });
        this.addSelectionListener();
        return c;
    }

    PasswordComposite getPasswordComposite() {
        return this.passwordComposite;
    }

    protected void okPressed() {
        if (this.credentialsMode == CredentialsMode.CREATE_FIRST_CREDENTIAL) {
            this.credentialsConfiguration = this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.PASSWORD ? CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.usernameAndPasswordComposite.getCredentialsName(), (String)this.usernameAndPasswordComposite.getUserID(), (String)this.usernameAndPasswordComposite.getPassword(), (boolean)this.usernameAndPasswordComposite.isSavePassword()) : (this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.ONETIMEPASSWORD ? CredentialsConfiguration.createOneTimePasswordCredential((String)this.oneTimePasswordComposite.getCredentialsName(), (String)this.oneTimePasswordComposite.getUserID()) : (this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.KEYSTORE ? CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.keystoreComposite.getCredentialsName(), (String)this.keystoreComposite.getUserID(), (CertificateDetails)this.keystoreComposite.getCertificate()) : CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.smartcardComposite.getCredentialsName(), (String)this.smartcardComposite.getUserID(), (CertificateDetails)this.smartcardComposite.getCertificate())));
            this.confirmCredentials(this.credentialsConfiguration, true);
        } else if (this.credentialsMode == CredentialsMode.AUTHENTICATE_CREDENTIAL) {
            this.credentialsConfiguration.setUserID(this.passwordComposite.getCurrentCredentialsComposite().getUserID());
            if (this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.PASSWORD) {
                this.credentialsConfiguration.setPassword(this.usernameAndPasswordComposite.getPassword());
                this.credentialsConfiguration.setSavePassword(this.usernameAndPasswordComposite.isSavePassword());
                this.credentialsConfiguration.setOneTimePassword(this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.ONETIMEPASSWORD);
            } else if (this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.ONETIMEPASSWORD) {
                this.credentialsConfiguration.setPassword(this.oneTimePasswordComposite.getPassword());
            }
            this.confirmCredentials(this.credentialsConfiguration, true);
        } else if (this.credentialsMode == CredentialsMode.CREATE_OR_SELECT_CREDENTIAL) {
            if (this.passwordComposite.shouldCreateNewCredentials()) {
                this.credentialsConfiguration = this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.PASSWORD ? CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.usernameAndPasswordComposite.getCredentialsName(), (String)this.usernameAndPasswordComposite.getUserID(), (String)this.usernameAndPasswordComposite.getPassword(), (boolean)this.usernameAndPasswordComposite.isSavePassword()) : (this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.ONETIMEPASSWORD ? CredentialsConfiguration.createOneTimePasswordCredential((String)this.usernameAndPasswordComposite.getCredentialsName(), (String)this.usernameAndPasswordComposite.getUserID()) : (this.passwordComposite.getCredentialType() == PasswordComposite.CredentialType.KEYSTORE ? CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.keystoreComposite.getCredentialsName(), (String)this.keystoreComposite.getUserID(), (CertificateDetails)this.keystoreComposite.getCertificate()) : CredentialsConfiguration.createCredentialsConfigurationWithNewId((String)this.smartcardComposite.getCredentialsName(), (String)this.smartcardComposite.getUserID(), (CertificateDetails)this.smartcardComposite.getCertificate())));
                this.confirmCredentials(this.credentialsConfiguration, true);
            } else {
                this.credentialsConfiguration = this.passwordComposite.getCredentialsConfiguration();
                this.confirmCredentials(this.credentialsConfiguration, false);
            }
        }
        super.okPressed();
    }

    private void confirmCredentials(CredentialsConfiguration aCredentialsConfiguration, boolean auth) {
        if (auth) {
            this.credentialsManager.update(this.credentialsConfiguration, true);
        }
        if (this.config.getCredentials() == null) {
            this.connectionManager.getConnectionCredentialsManager().associate(this.config.getId(), aCredentialsConfiguration.getID());
        }
    }

    @Override
    String getHelpContextId() {
        return "com.ibm.cics.explorer.password_dialog";
    }

    @Override
    String getShellText() {
        return Messages.PasswordDialog_signon;
    }

    @Override
    String getTitle() {
        String descriptorName = this.config.getConnectionDescriptor() != null ? this.config.getConnectionDescriptor().getName() : "";
        String configurationName = this.credentialsConfiguration != null ? this.credentialsConfiguration.getName() : "";
        return String.valueOf(LabelUtil.appendColon((String)descriptorName)) + " " + configurationName;
    }

    @Override
    String getTitleMessage() {
        return this.config.getName();
    }
}

