/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.cpsm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.model.CICSRelease;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.sm.comm.AbstractSystemManagerConnection;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IComplexFilteredContext;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IOrderedContext;
import com.ibm.cics.sm.comm.IParameterisedContext;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.ISystemManagerConnection2;
import com.ibm.cics.sm.comm.RepositoryDiscoverer;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.TypeNotFoundException;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import com.ibm.cics.sm.comm.context.ICMASContext;
import com.ibm.cics.sm.comm.context.IGroupContext;
import com.ibm.cics.sm.comm.context.ISystemParameterContext;
import com.ibm.cics.sm.comm.context.IWorkloadContext;
import com.ibm.cics.sm.comm.context.IgnoreWarningCountContext;
import com.ibm.cics.sm.comm.cpsm.CPSMConnectionException;
import com.ibm.cics.sm.comm.cpsm.CPSMResponse;
import com.ibm.cics.sm.comm.cpsm.ReconnectAction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;

public class CPSMConnection
extends AbstractSystemManagerConnection
implements ISystemManagerConnection2,
IResourceTables {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String LOCAL = "local@";
    public static final String FILE = "/CICSPlexSM/ENU1/";
    public static final String DATA_ENCODING_CHARSET = "ISO-8859-1";
    public static final String URLENCODING_CHARSET = "UTF-8";
    public static final String COMMAND_CONNECT = "/DATA/CONNECT";
    public static final String COMMAND_DISCONNECT = "/DATA/DISCONNECT";
    public static final String COMMAND_GET = "/DATA/GET";
    public static final String COMMAND_GETDEF = "/DATA/GETDEF";
    public static final String COMMAND_FETCH = "/DATA/FETCH";
    public static final String COMMAND_DISCARD = "/DATA/DISCARD";
    public static final String HEADER_STATUS = "STATUS";
    public static final String HEADER_SERVERAPPLID = "SERVERAPPLID";
    public static final String HEADER_CMAS = "CMASSYSID";
    public static final String HEADER_REALEASE = "CPSMREL";
    private static CPSMConnection instance = new CPSMConnection();
    private String host;
    private int port;
    private String userID;
    private String password;
    protected int readTimeout = 120000;
    private String cookie;
    private boolean hasBeenConnected;
    private String cmasSYSID;
    private String version;
    private Map<String, SMConnectionResponse> stubs = new HashMap<String, SMConnectionResponse>();
    private List<String> stubsUsed = new LinkedList<String>();
    private final ReconnectAction reconnectAction;
    private static final Logger logger;
    private static final Debug DEBUG;

    static {
        DEBUG = new Debug(CPSMConnection.class);
        logger = Logger.getLogger("com.ibm.cics.sm.comm.cpsm");
    }

    public CPSMConnection() {
        this((ConnectionConfiguration)null);
        instance = this;
    }

    public CPSMConnection(ConnectionConfiguration configuration) {
        this(configuration, ReconnectAction.JOIN);
    }

    public CPSMConnection(ReconnectAction reconnectAction) {
        this(null, reconnectAction);
    }

    public CPSMConnection(ConnectionConfiguration configuration, ReconnectAction reconnectAction) {
        this.setConfiguration(configuration);
        this.reconnectAction = reconnectAction;
    }

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        super.setConfiguration(connectionConfiguration);
        if (connectionConfiguration != null) {
            String readTimeoutStr = connectionConfiguration.getExtendedAttribute("READ_TIMEOUT");
            try {
                this.readTimeout = Integer.parseInt(readTimeoutStr);
            }
            catch (NumberFormatException e) {
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"couldn't parse timeout", (Object)readTimeoutStr);
            }
        }
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        DEBUG.enter("openConnection", (Object)url, (Object)this.readTimeout);
        HttpURLConnection connection = super.openConnection(url);
        connection.setReadTimeout(this.readTimeout);
        connection.setConnectTimeout(this.readTimeout);
        DEBUG.exit("openConnection", (Object)connection);
        return connection;
    }

    public static ISystemManagerConnection getConnection() {
        return instance;
    }

    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        if (context instanceof IOrderedContext || context instanceof IComplexFilteredContext) {
            return false;
        }
        if (ContextHelper.getContextFrom((IContext)context, IgnoreWarningCountContext.class) != null) {
            return false;
        }
        return super.checkOperation(resourceType, context, operation);
    }

    public boolean isConnected() {
        return this.cookie != null;
    }

    public void connect() throws ConnectionException {
        block12: {
            this.host = this.getConfiguration().getHost();
            this.port = this.getConfiguration().getPort();
            this.userID = this.getConfiguration().getUserID();
            this.password = this.getConfiguration().getPassword();
            Debug.enter((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", (Object)this.host, (Object)this.port, (Object)this.userID);
            if (this.userID.length() > 8) {
                this.userID = this.userID.substring(0, 8).trim();
            }
            try {
                String file = String.valueOf(this.getFilePrefix()) + COMMAND_CONNECT;
                URL url = this.createURL(file);
                HttpURLConnection connection = this.openConnection(url);
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setRequestMethod("POST");
                String request = String.valueOf(URLEncoder.encode("USERID", URLENCODING_CHARSET)) + "=" + URLEncoder.encode(this.userID, URLENCODING_CHARSET) + "&" + URLEncoder.encode("RECONN", URLENCODING_CHARSET) + "=" + URLEncoder.encode(this.reconnectAction.toString(), URLENCODING_CHARSET);
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", (Object)request);
                request = String.valueOf(request) + "&" + URLEncoder.encode("PASSWORD", URLENCODING_CHARSET) + "=" + URLEncoder.encode(this.password, URLENCODING_CHARSET);
                OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), DATA_ENCODING_CHARSET);
                writer.write(request);
                writer.flush();
                writer.close();
                if (connection instanceof HttpsURLConnection) {
                    HttpsURLConnection httpsURLConnection = (HttpsURLConnection)connection;
                    Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", (Object)httpsURLConnection.getCipherSuite());
                }
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", (Object[])new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                if (connection.getResponseCode() == 200) {
                    Map<String, List<String>> headerFields = connection.getHeaderFields();
                    Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", headerFields.keySet());
                    this.cookie = connection.getHeaderField("Set-Cookie");
                    Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", (Object)this.cookie);
                    if (this.cookie != null && this.cookie.endsWith("; Secure")) {
                        this.cookie = this.cookie.substring(0, this.cookie.length() - 8);
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", (Object)this.cookie);
                    }
                    this.setConnected();
                    BufferedReader reader = this.newReader(connection);
                    String header = reader.readLine();
                    Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", (Object)header);
                    StringTokenizer st1 = new StringTokenizer(header, "&");
                    while (st1.hasMoreTokens()) {
                        String token = st1.nextToken();
                        StringTokenizer st2 = new StringTokenizer(token, "=");
                        String field = st2.nextToken();
                        String value = st2.nextToken();
                        if (field.equals(HEADER_STATUS)) {
                            String status = value;
                            if (status.equals("OK")) continue;
                            if (status.contains("PASSWORD") || status.contains("USERID") || status.contains("UNAUTHORIZED")) {
                                throw new AuthenticationException(status);
                            }
                            throw new CPSMConnectionException(url, status);
                        }
                        if (field.equals(HEADER_SERVERAPPLID)) continue;
                        if (field.equals(HEADER_CMAS)) {
                            this.cmasSYSID = value;
                            continue;
                        }
                        if (!field.equals(HEADER_REALEASE)) continue;
                        this.version = CPSMConnection.formatVersionAsCICSTSLevel((String)value);
                    }
                    reader.close();
                    CICSRelease release = CICSRelease.fromVersion((String)this.version);
                    if (!this.isCICSVersionSupported(release)) {
                        this.disconnect();
                        throw new SystemManagerConnectionException("Unsupported CICS release");
                    }
                    break block12;
                }
                throw new CPSMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
            }
            catch (IOException ex) {
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", (Object)ex);
                throw new CPSMConnectionException(ex);
            }
            catch (NullPointerException ex) {
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", (Object)ex);
                throw new CPSMConnectionException(ex);
            }
        }
        Debug.exit((Logger)logger, (String)CPSMConnection.class.getName(), (String)"connect", (Object)("connected=" + Boolean.toString(this.isConnected()) + " version=" + this.version));
    }

    public SMConnectionResponse getResources(String resourceName, String context, String scope) throws ConnectionException {
        SMConnectionResponse response = this.get(resourceName, context, scope);
        response = this.fetch(response.getStub(), 1, -1);
        this.discard(response.getStub());
        return response;
    }

    public SMConnectionResponse getResources(String resourceName, IContext context) throws ConnectionException {
        SMConnectionResponse response = this.get(resourceName, context);
        response = this.fetch(response.getStub(), 1, -1);
        this.discard(response.getStub());
        return response;
    }

    public SMConnectionResponse get(String resourceType, IContext context) throws ConnectionException {
        if (context instanceof IFilteredContext) {
            IContext currentContext = context;
            HashMap<String, String> attributes = new HashMap<String, String>();
            while (currentContext instanceof IFilteredContext) {
                IFilteredContext filteredContext = (IFilteredContext)currentContext;
                for (String name : filteredContext.getAttributeNames()) {
                    attributes.put(name, filteredContext.getAttributeValue(name));
                }
                currentContext = ((IFilteredContext)currentContext).getParentContext();
            }
            return this.get(resourceType, attributes, currentContext.getContext(), ContextHelper.findScope((IContext)currentContext), context);
        }
        if (context instanceof IScopedContext) {
            IScopedContext scopedContext = (IScopedContext)context;
            return this.get(resourceType, null, scopedContext.getContext(), scopedContext.getScope(), context);
        }
        return this.get(resourceType, null, context.getContext(), null, context);
    }

    public SMConnectionResponse get(String resourceName, String context, String scope) throws ConnectionException {
        return this.get(resourceName, null, context, scope, null);
    }

    private SMConnectionResponse get(String resourceName, Map<String, String> attributes, String contextName, String scope, IContext context) throws ConnectionException {
        Debug.enter((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)((Object)this), (Object)resourceName, (Object)contextName, (Object)scope, (Object)context);
        if (this.shouldReconnect()) {
            Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)"reconnect");
            this.connect();
        }
        String stub = null;
        String status = "UKNOWN";
        String response = "OK";
        String reason = "N_A";
        int count = 0;
        if (resourceName.equals("CSYSGRP") && (context instanceof IAssociationContext || context instanceof IFilteredContext && ((IFilteredContext)context).getParentContext() instanceof IAssociationContext)) {
            CPSMResponse connectionResponse = new CPSMResponse(this.generateLocalStub(), resourceName, context, status, response, count);
            this.addStub(connectionResponse);
            return connectionResponse;
        }
        try {
            URL url;
            long timeoutTime = this.readTimeout > 0 ? System.currentTimeMillis() + (long)this.readTimeout : Long.MAX_VALUE;
            String timeoutToken = null;
            do {
                String record;
                BufferedReader reader;
                String request;
                String file = String.valueOf(this.getFilePrefix()) + COMMAND_GET;
                if (timeoutToken != null) {
                    Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)"TIMEOUTTOKEN", timeoutToken);
                    file = String.valueOf(file) + "?" + URLEncoder.encode("TIMEOUTTOKEN", URLENCODING_CHARSET) + "=" + URLEncoder.encode(timeoutToken, URLENCODING_CHARSET);
                    request = null;
                } else {
                    request = String.valueOf(URLEncoder.encode("OBJECT", URLENCODING_CHARSET)) + "=" + URLEncoder.encode(resourceName, URLENCODING_CHARSET);
                    String resourceGroup = null;
                    IContext parentContext = context;
                    if (attributes != null) {
                        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                            String name = attribute.getKey();
                            String value = attribute.getValue();
                            request = String.valueOf(request) + "&" + URLEncoder.encode("A_" + name, URLENCODING_CHARSET) + "=" + CPSMConnection.escape((String)value);
                        }
                    }
                    if (parentContext instanceof IFilteredContext) {
                        parentContext = ((IFilteredContext)parentContext).getParentContext();
                    }
                    if (parentContext != null && parentContext instanceof IDefinitionContext) {
                        IDefinitionContext definitionContext = (IDefinitionContext)parentContext;
                        resourceGroup = definitionContext.getResourceGroup();
                        if (parentContext instanceof IGroupContext) {
                            IGroupContext groupContext = (IGroupContext)parentContext;
                            parentContext = groupContext.getParentContext();
                        }
                    }
                    if (parentContext instanceof ISystemParameterContext) {
                        ISystemParameterContext systemParameterContext = (ISystemParameterContext)parentContext;
                        request = String.valueOf(request) + "&" + URLEncoder.encode("P_PARMTYPE", URLENCODING_CHARSET) + "=" + URLEncoder.encode(systemParameterContext.getType(), URLENCODING_CHARSET);
                        request = String.valueOf(request) + "&" + URLEncoder.encode("P_PARMSRCE", URLENCODING_CHARSET) + "=" + URLEncoder.encode(systemParameterContext.getSource(), URLENCODING_CHARSET);
                        parentContext = systemParameterContext.getParentContext();
                    }
                    if (parentContext instanceof IParameterisedContext) {
                        IParameterisedContext parameterisedContext = (IParameterisedContext)parentContext;
                        String parameters = this.getParametersFromParameterisedContext(parameterisedContext);
                        if (parameters.length() > 0) {
                            request = String.valueOf(request) + parameters;
                        }
                        parentContext = parameterisedContext.getParentContext();
                    }
                    if (parentContext != null && parentContext instanceof ICMASContext) {
                        ICMASContext cmasContext = (ICMASContext)parentContext;
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)cmasContext);
                        request = String.valueOf(request) + "&" + URLEncoder.encode("CMASCONTEXT", URLENCODING_CHARSET) + "=" + URLEncoder.encode(cmasContext.getContext(), URLENCODING_CHARSET);
                    } else if (parentContext != null) {
                        String contextName2;
                        String scopeName2 = contextName2 = parentContext.getContext();
                        if (parentContext instanceof IScopedContext) {
                            IScopedContext scopedContext = (IScopedContext)parentContext;
                            scopeName2 = scopedContext.getScope();
                        }
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)contextName2, (Object)scopeName2);
                        if (contextName2 != null) {
                            request = String.valueOf(request) + "&" + URLEncoder.encode("CONTEXT", URLENCODING_CHARSET) + "=" + URLEncoder.encode(contextName2, URLENCODING_CHARSET);
                        }
                        if (scopeName2 != null) {
                            request = String.valueOf(request) + "&" + URLEncoder.encode("SCOPE", URLENCODING_CHARSET) + "=" + URLEncoder.encode(scopeName2, URLENCODING_CHARSET);
                            if (scopeName2.length() > 0 && !scopeName2.equals(contextName2) && IResourceTables.Helper.isCICSDefinition((String)resourceName)) {
                                if (resourceGroup == null) {
                                    resourceGroup = "*";
                                }
                                request = String.valueOf(request) + "&" + URLEncoder.encode("P_CSDGROUP", URLENCODING_CHARSET) + "=" + URLEncoder.encode(resourceGroup, URLENCODING_CHARSET);
                            } else if (resourceGroup != null) {
                                request = String.valueOf(request) + "&" + URLEncoder.encode("P_RESGROUP", URLENCODING_CHARSET) + "=" + URLEncoder.encode(resourceGroup, URLENCODING_CHARSET);
                            }
                        }
                    }
                    if (this.requiresWorkloadParameter(resourceName)) {
                        String workloadName = "*";
                        Object workloadContext = null;
                        if (parentContext instanceof IWorkloadContext) {
                            workloadName = ((IWorkloadContext)parentContext).getWorkloadName();
                        } else if (context instanceof IWorkloadContext) {
                            workloadName = ((IWorkloadContext)context).getWorkloadName();
                        }
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", workloadContext, (Object)workloadName);
                        request = String.valueOf(request) + "&" + URLEncoder.encode("P_WORKLOAD", URLENCODING_CHARSET) + "=" + URLEncoder.encode(workloadName, URLENCODING_CHARSET);
                    }
                }
                url = this.createURL(file);
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)url, (Object)this.cookie);
                HttpURLConnection connection = this.openConnection(url);
                connection.setDoInput(true);
                connection.setRequestProperty("Cookie", this.cookie);
                connection.setRequestMethod("GET");
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)request);
                if (request != null) {
                    connection.setDoOutput(true);
                    OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), DATA_ENCODING_CHARSET);
                    writer.write(request);
                    writer.flush();
                    writer.close();
                }
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object[])new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                if (connection.getResponseCode() == 200) {
                    reader = this.newReader(connection);
                    String header = reader.readLine();
                    Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)header);
                    timeoutToken = null;
                    StringTokenizer st1 = new StringTokenizer(header, "&");
                    while (st1.hasMoreTokens()) {
                        String token = st1.nextToken();
                        StringTokenizer st2 = new StringTokenizer(token, "=");
                        String field = st2.nextToken();
                        String value = st2.nextToken();
                        if (field.equals(HEADER_STATUS)) {
                            status = value;
                            continue;
                        }
                        if (field.equals("RESPONSE")) {
                            response = value;
                            continue;
                        }
                        if (field.equals("REASON")) {
                            reason = value;
                            continue;
                        }
                        if (field.equals("COUNT")) {
                            count = Integer.valueOf(value);
                            continue;
                        }
                        if (field.equals("STUB")) {
                            stub = value;
                            continue;
                        }
                        if (!field.equals("TIMEOUTTOKEN")) continue;
                        timeoutToken = value;
                    }
                    reader.close();
                    if (status.equals("OK")) {
                        if (response.equals("OK") || response.equals("NODATA")) continue;
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)status, (Object)response, (Object)reason);
                        this.addStub(new CPSMResponse(stub, resourceName, status, response, reason, context));
                        this.discard(stub);
                        throw new CPSMConnectionException(url, response, reason);
                    }
                    if (status.equals("BADATTR")) {
                        Debug.warning((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)status);
                        throw new CPSMConnectionException(url, status);
                    }
                    if (status.equals("BADOBJECT")) {
                        Debug.warning((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)status);
                        throw new TypeNotFoundException(status);
                    }
                    if (status.equals("BADTICKET")) {
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)status);
                        this.setDisconnected(connection);
                        return this.get(resourceName, attributes, contextName, scope, context);
                    }
                    if (status.equals("MAXWIN")) {
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)status);
                        if (!this.stubsUsed.isEmpty()) {
                            String oldestStub = this.stubsUsed.get(this.stubsUsed.size() - 1);
                            SMConnectionResponse oldestResponse = this.stubs.get(oldestStub);
                            this.discard(oldestStub);
                            this.stubs.put(oldestStub, oldestResponse);
                            return this.get(resourceName, attributes, contextName, scope, context);
                        }
                        throw new CPSMConnectionException(url, status);
                    }
                    if (status.equals("TIMEOUT")) {
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)status, timeoutToken);
                        continue;
                    }
                    if (!status.equals("UKNOWN")) {
                        Debug.warning((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)status);
                        throw new CPSMConnectionException(url, status);
                    }
                    if (!status.equals("UKNOWN")) continue;
                    Debug.warning((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)status);
                    throw new CPSMConnectionException(url, header);
                }
                reader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), DATA_ENCODING_CHARSET));
                while ((record = reader.readLine()) != null) {
                    Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)record);
                }
                throw new CPSMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
            } while (timeoutToken != null && System.currentTimeMillis() < timeoutTime);
            if (timeoutToken != null) {
                throw new CPSMConnectionException(url, "Request timed out");
            }
        }
        catch (IOException ex) {
            throw new CPSMConnectionException(ex);
        }
        CPSMResponse connectionResponse = new CPSMResponse(stub, resourceName, context, status, response, count);
        this.addStub(connectionResponse);
        Debug.exit((Logger)logger, (String)CPSMConnection.class.getName(), (String)"get", (Object)((Object)connectionResponse));
        return connectionResponse;
    }

    protected String getParametersFromParameterisedContext(IParameterisedContext parameterisedContext) throws UnsupportedEncodingException {
        String parameters = "";
        for (String name : parameterisedContext.getParameterNames()) {
            String encodedName = "&" + URLEncoder.encode("P_" + name, URLENCODING_CHARSET);
            String value = parameterisedContext.getParameterValue(name);
            parameters = String.valueOf(parameters) + encodedName + "=" + URLEncoder.encode(value, URLENCODING_CHARSET);
        }
        return parameters;
    }

    protected boolean requiresWorkloadParameter(String resourceType) {
        return resourceType.equals("WLMAROUT") || resourceType.equals("WLMATAFF") || resourceType.equals("WLMATGRP") || resourceType.equals("WLMATRAN") || resourceType.equals("WLMAWAOR") || resourceType.equals("WLMAWDEF") || resourceType.equals("WLMAWTOR");
    }

    private boolean isLocal(String stub) {
        return stub != null && stub.startsWith(LOCAL);
    }

    private String generateLocalStub() {
        return LOCAL + UUID.randomUUID();
    }

    private String getFilePrefix() throws UnsupportedEncodingException {
        String encodedUserID = URLEncoder.encode(this.userID, URLENCODING_CHARSET);
        return FILE + encodedUserID;
    }

    public SMConnectionResponse fetch(String stub, int position, int count) throws ConnectionException {
        CPSMResponse response;
        block14: {
            Debug.enter((Logger)logger, (String)CPSMConnection.class.getName(), (String)"fetch", (Object)((Object)this), (Object)stub, (Object)String.valueOf(position), (Object)String.valueOf(count));
            if (this.isLocal(stub)) {
                return this.stubs.get(stub);
            }
            try {
                String status = "UKNOWN";
                String request = "?" + URLEncoder.encode("STUB", URLENCODING_CHARSET) + "=" + URLEncoder.encode(stub, URLENCODING_CHARSET);
                if (count != -1) {
                    request = String.valueOf(request) + "&" + URLEncoder.encode("COUNT", URLENCODING_CHARSET) + "=" + URLEncoder.encode(String.valueOf(count), URLENCODING_CHARSET) + "&" + URLEncoder.encode("POSITION", URLENCODING_CHARSET) + "=" + URLEncoder.encode(String.valueOf(position), URLENCODING_CHARSET);
                }
                CPSMResponse lastResponse = this.removeStub(stub);
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"fetch", (Object)stub, (Object)((Object)lastResponse));
                String resourceName = lastResponse.getResourceType();
                String file = String.valueOf(this.getFilePrefix()) + COMMAND_FETCH + request;
                URL url = this.createURL(file);
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"fetch", (Object)url);
                HttpURLConnection connection = this.openConnection(url);
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setRequestProperty("Cookie", this.cookie);
                connection.setRequestMethod("GET");
                int responseCode = connection.getResponseCode();
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"fetch", (Object[])new Object[]{String.valueOf(responseCode), connection.getResponseMessage()});
                if (responseCode == 200) {
                    String record;
                    int actualCount = 0;
                    String newStub = null;
                    BufferedReader reader = this.newReader(connection);
                    String header = reader.readLine();
                    Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"fetch", (Object)header);
                    StringTokenizer st1 = new StringTokenizer(header, "&");
                    while (st1.hasMoreTokens()) {
                        String token = st1.nextToken();
                        StringTokenizer st2 = new StringTokenizer(token, "=");
                        String field = st2.nextToken();
                        String value = st2.nextToken();
                        if (field.equals(HEADER_STATUS)) {
                            status = value;
                            continue;
                        }
                        if (field.equals("COUNT")) {
                            actualCount = Integer.valueOf(value);
                            continue;
                        }
                        if (!field.equals("STUB")) continue;
                        newStub = value;
                    }
                    String[] data = new String[actualCount];
                    int i = 0;
                    while ((record = reader.readLine()) != null) {
                        Debug.event((Logger)logger, (Level)(i % 10 == 0 ? Debug.NORMAL_LEVEL : Debug.DETAIL_LEVEL), (String)CPSMConnection.class.getName(), (String)"fetch", (Object)record);
                        data[i] = record;
                        ++i;
                    }
                    reader.close();
                    if (status.equals("BADTICKET")) {
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"fetch", (Object)status);
                        this.setDisconnected(connection);
                        SMConnectionResponse getResponse = this.get(resourceName, lastResponse.getContext());
                        return this.fetch(getResponse.getStub(), position, actualCount);
                    }
                    if (status.equals("BADSTUB")) {
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"fetch", (Object)status);
                        SMConnectionResponse getResponse = this.get(resourceName, lastResponse.getContext());
                        return this.fetch(getResponse.getStub(), position, actualCount);
                    }
                    if (status.equals("MAXWIN")) {
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"fetch", (Object)status);
                        SMConnectionResponse getResponse = this.get(resourceName, lastResponse.getContext());
                        return this.fetch(getResponse.getStub(), position, actualCount);
                    }
                    if (!status.equals("OK")) {
                        throw new CPSMConnectionException(url, header);
                    }
                    if (newStub != null) {
                        response = new CPSMResponse(newStub, resourceName, lastResponse.getContext(), position - 1, data);
                        break block14;
                    }
                    throw new CPSMConnectionException("STUB missing", url, request);
                }
                throw new CPSMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
            }
            catch (IOException ex) {
                throw new CPSMConnectionException(ex);
            }
        }
        this.updateStub(stub, response);
        Debug.exit((Logger)logger, (String)CPSMConnection.class.getName(), (String)"fetch", (Object)((Object)response));
        return response;
    }

    private BufferedReader newReader(HttpURLConnection connection) throws IOException {
        return new BufferedReader(new InputStreamReader(connection.getInputStream(), DATA_ENCODING_CHARSET));
    }

    public void discard(String stub) throws CPSMConnectionException {
        block7: {
            Debug.enter((Logger)logger, (String)CPSMConnection.class.getName(), (String)"discard", (Object)((Object)this), (Object)this.cookie, (Object)stub);
            String status = "UKNOWN";
            CPSMResponse response = this.removeStub(stub);
            Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"discard", (Object)stub, (Object)((Object)response));
            if (!this.isLocal(stub) && response != null) {
                try {
                    String file = String.valueOf(this.getFilePrefix()) + COMMAND_DISCARD;
                    URL url = this.createURL(file);
                    HttpURLConnection connection = this.openConnection(url);
                    connection.setDoOutput(true);
                    connection.setDoInput(true);
                    connection.setRequestProperty("Cookie", this.cookie);
                    connection.setRequestMethod("GET");
                    String request = String.valueOf(URLEncoder.encode("STUB", URLENCODING_CHARSET)) + "=" + URLEncoder.encode(stub, URLENCODING_CHARSET);
                    Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"discard", (Object)request);
                    OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), DATA_ENCODING_CHARSET);
                    writer.write(request);
                    writer.flush();
                    writer.close();
                    Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"discard", (Object[])new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
                    if (connection.getResponseCode() == 200) {
                        BufferedReader reader = this.newReader(connection);
                        String header = reader.readLine();
                        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"discard", (Object)header);
                        if (header == null) {
                            header = "";
                        }
                        StringTokenizer st1 = new StringTokenizer(header, "&");
                        while (st1.hasMoreTokens()) {
                            String token = st1.nextToken();
                            StringTokenizer st2 = new StringTokenizer(token, "=");
                            String field = st2.nextToken();
                            String value = st2.nextToken();
                            if (!field.equals(HEADER_STATUS)) continue;
                            status = value;
                        }
                        reader.close();
                        if (!status.equals("OK")) {
                            Debug.warning((Logger)logger, (String)CPSMConnection.class.getName(), (String)"discard", (Object)status);
                        }
                        break block7;
                    }
                    throw new CPSMConnectionException(url, connection.getResponseCode(), connection.getResponseMessage());
                }
                catch (Exception ex) {
                    throw new CPSMConnectionException(ex);
                }
            }
        }
        Debug.exit((Logger)logger, (String)CPSMConnection.class.getName(), (String)"discard");
    }

    public void disconnect() throws CPSMConnectionException {
        if (this.cookie == null) {
            return;
        }
        Debug.enter((Logger)logger, (String)CPSMConnection.class.getName(), (String)"disconnect", (Object)((Object)this), (Object)this.cookie);
        try {
            String content;
            String file = String.valueOf(this.getFilePrefix()) + COMMAND_DISCONNECT;
            URL url = this.createURL(file);
            HttpURLConnection connection = this.openConnection(url);
            connection.setDoOutput(false);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestProperty("Cookie", this.cookie);
            connection.setRequestMethod("GET");
            Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"disconnect", (Object[])new Object[]{String.valueOf(connection.getResponseCode()), connection.getResponseMessage()});
            BufferedReader reader = this.newReader(connection);
            while ((content = reader.readLine()) != null) {
                Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"disconnect", (Object)content);
            }
            reader.close();
            this.setDisconnected(connection);
            this.clearStubs();
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            throw new CPSMConnectionException(ex);
        }
        Debug.exit((Logger)logger, (String)CPSMConnection.class.getName(), (String)"disconnect");
    }

    private void setConnected() {
        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"setConnected", (Object)((Object)this), (Object)this.cookie);
        this.hasBeenConnected = true;
    }

    private void setDisconnected(HttpURLConnection connection) {
        Debug.event((Logger)logger, (String)CPSMConnection.class.getName(), (String)"setDisconnected", (Object)((Object)this));
        this.cookie = null;
        connection.disconnect();
    }

    private boolean shouldReconnect() {
        return !this.isConnected() && this.hasBeenConnected;
    }

    public String getServerApplID() {
        return this.cmasSYSID;
    }

    public String getVersion() {
        return this.version;
    }

    private void addStub(SMConnectionResponse response) {
        String newStub = response.getStub();
        this.stubs.put(newStub, response);
        this.stubsUsed.add(0, newStub);
        Debug.event((Logger)logger, (Level)Debug.NORMAL_LEVEL, (String)CPSMConnection.class.getName(), (String)"addStub", (Object[])new Object[]{this.stubs.size(), this.stubsUsed.size()});
    }

    private void updateStub(String oldStub, SMConnectionResponse response) {
        this.stubs.remove(oldStub);
        this.stubsUsed.remove(oldStub);
        String newStub = response.getStub();
        this.stubs.put(newStub, response);
        this.stubsUsed.add(0, newStub);
        Debug.event((Logger)logger, (Level)Debug.NORMAL_LEVEL, (String)CPSMConnection.class.getName(), (String)"updateStub", (Object[])new Object[]{this.stubs.size(), this.stubsUsed.size()});
    }

    private CPSMResponse removeStub(String stub) {
        CPSMResponse response = (CPSMResponse)this.stubs.remove(stub);
        this.stubsUsed.remove(stub);
        Debug.event((Logger)logger, (Level)Debug.NORMAL_LEVEL, (String)CPSMConnection.class.getName(), (String)"removeStub", (Object[])new Object[]{this.stubs.size(), this.stubsUsed.size()});
        return response;
    }

    private void clearStubs() {
        Debug.event((Logger)logger, (Level)Debug.NORMAL_LEVEL, (String)CPSMConnection.class.getName(), (String)"clearStubs", (Object[])new Object[]{this.stubs.size(), this.stubsUsed.size()});
        this.stubs.clear();
        this.stubsUsed.clear();
    }

    public List<IRepository> getRepositories() {
        return RepositoryDiscoverer.getRepositories((ISystemManagerConnection)this);
    }
}

