/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.cpsm;

import com.ibm.cics.common.util.String2NumberHelper;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.INormalizer;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.NormalizationException;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CPSMRecord
extends SMConnectionRecord {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String name;
    private Map<String, String> fields = new HashMap<String, String>();
    private static final String UNSPECIFIED_DATE_STRING = "0000/00/00 00:00:00";
    private static final Pattern CPSM_TIME_PATTERN = Pattern.compile("\\d{4}/\\d{2}/\\d{2} \\d{2}:\\d{2}:\\d{2}");
    private static final Pattern RFC822_TIME_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+-]\\d{4}");
    private static final String ZERO_PAD = ".000+0000";
    static Map<String, INormalizer> NORMALIZERS = new HashMap<String, INormalizer>();
    private static final INormalizer DATE_NORMALIZER = new INormalizer(){

        private boolean isValidCPSMTime(String testString) {
            return CPSM_TIME_PATTERN.matcher(testString).matches();
        }

        private boolean isValidRFC822Time(String testString) {
            return RFC822_TIME_PATTERN.matcher(testString).matches();
        }

        public String normalize(String denormalizedValue) throws NormalizationException {
            if (denormalizedValue == null) {
                return null;
            }
            if (CPSMRecord.UNSPECIFIED_DATE_STRING.equals(denormalizedValue)) {
                return "0000-00-00T00:00:00.000+0000";
            }
            if (this.isValidCPSMTime(denormalizedValue)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(denormalizedValue.subSequence(0, 4));
                stringBuilder.append('-');
                stringBuilder.append(denormalizedValue.subSequence(5, 7));
                stringBuilder.append('-');
                stringBuilder.append(denormalizedValue.subSequence(8, 10));
                stringBuilder.append('T');
                stringBuilder.append(denormalizedValue.subSequence(11, 19));
                stringBuilder.append(CPSMRecord.ZERO_PAD);
                return stringBuilder.toString();
            }
            return denormalizedValue;
        }

        public String denormalize(String normalizedValue) throws NormalizationException {
            if (normalizedValue == null) {
                return null;
            }
            if ("0000-00-00T00:00:00.000+0000".equals(normalizedValue)) {
                return CPSMRecord.UNSPECIFIED_DATE_STRING;
            }
            if (this.isValidRFC822Time(normalizedValue)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(normalizedValue.subSequence(0, 4));
                stringBuilder.append('/');
                stringBuilder.append(normalizedValue.subSequence(5, 7));
                stringBuilder.append('/');
                stringBuilder.append(normalizedValue.subSequence(8, 10));
                stringBuilder.append(' ');
                stringBuilder.append(normalizedValue.subSequence(11, 19));
                return stringBuilder.toString();
            }
            return normalizedValue;
        }
    };
    private String data;

    static {
        NORMALIZERS.put("LONG_NORMALIZER_KEY", new INormalizer(){

            public String denormalize(String normalizedValue) {
                return normalizedValue;
            }

            public String normalize(String denormalizedValue) {
                return String2NumberHelper.cleanQuotedNumber((String)denormalizedValue);
            }
        });
        NORMALIZERS.put("DATE_NORMALIZER_KEY", DATE_NORMALIZER);
    }

    public CPSMRecord(String resourceType, String data, IContext context) throws UnsupportedEncodingException {
        super(resourceType, context);
        this.data = data;
        StringTokenizer st1 = new StringTokenizer(data, "&");
        while (st1.hasMoreTokens()) {
            StringTokenizer st2 = new StringTokenizer(st1.nextToken(), "=");
            String field = URLDecoder.decode(st2.nextToken(), "UTF-8");
            String value = "";
            if (st2.hasMoreTokens()) {
                value = URLDecoder.decode(st2.nextToken(), "UTF-8");
            }
            this.fields.put(field, value);
            if (this.name != null || !field.equals("PLEXNAME") && !field.endsWith("NAME") && !field.equals(resourceType)) continue;
            this.name = value;
        }
        String csdGroup = this.get("CSDGROUP");
        if (csdGroup != null && csdGroup.length() > 0 && IResourceTables.Helper.isCICSDefinition((String)resourceType)) {
            int i = 1;
            while (i <= 3) {
                String field = "USERDATA" + i;
                this.fields.put(field, "FORCE_ATTRIBUTE_UNSUPPORTED");
                ++i;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String get(String attribute) {
        return this.fields.get(attribute);
    }

    public String toExternalForm() {
        return this.data;
    }

    public Map<String, INormalizer> getNormalizers() {
        return NORMALIZERS;
    }
}

