/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.breadcrumb;

import com.ibm.cics.core.model.ManagedRegionType;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.breadcrumb.CICSplexNode;
import com.ibm.cics.core.ui.breadcrumb.IBreadcrumbNode;
import com.ibm.cics.model.ICICSObject;
import org.eclipse.swt.graphics.Image;

public class ManagedRegionNode
implements IBreadcrumbNode {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String regionName;
    private final CICSplexNode cicsPlex;

    public ManagedRegionNode(CICSplexNode cicsPlex, String regionName) {
        this.cicsPlex = cicsPlex;
        this.regionName = regionName;
    }

    public ManagedRegionNode(ICICSObject object, String regionName) {
        this(CICSplexNode.createFor(object), regionName);
    }

    @Override
    public Image getImage() {
        return UIPlugin.getTableImage(ManagedRegionType.getInstance().getResourceTableName());
    }

    @Override
    public String getText() {
        return this.regionName;
    }

    @Override
    public String getTooltipText() {
        return Messages.getTableDescription(ManagedRegionType.getInstance().getResourceTableName());
    }

    public CICSplexNode getCICSplexNode() {
        return this.cicsPlex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cicsPlex == null ? 0 : this.cicsPlex.hashCode());
        result = 31 * result + (this.regionName == null ? 0 : this.regionName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManagedRegionNode other = (ManagedRegionNode)obj;
        if (this.cicsPlex == null ? other.cicsPlex != null : !this.cicsPlex.equals(other.cicsPlex)) {
            return false;
        }
        return !(this.regionName == null ? other.regionName != null : !this.regionName.equals(other.regionName));
    }
}

