/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.decorators;

import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.meta.IAttribute;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class CICSObjectLabelProvider
extends LabelProvider
implements ILabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private boolean showAllKeyAttributes;

    public CICSObjectLabelProvider() {
        this(false);
    }

    public CICSObjectLabelProvider(boolean showAllKeyAttributes) {
        this.showAllKeyAttributes = showAllKeyAttributes;
    }

    public Image getImage(Object element) {
        ICICSType cicsType = ((ICICSObject)element).getObjectType();
        return UIPlugin.getTableImage(cicsType.getResourceTableName());
    }

    public String getText(Object element) {
        ICICSObject cicsObject = (ICICSObject)element;
        if (this.showAllKeyAttributes) {
            ICICSType type = cicsObject.getObjectType();
            Set keyAttributes = type.getKeyAttributes();
            StringBuilder builder = new StringBuilder();
            if (keyAttributes.size() == 0) {
                builder.append(cicsObject.getName());
            } else {
                Iterator iterator = keyAttributes.iterator();
                builder.append(cicsObject.getAttributeValue((IAttribute)iterator.next()));
                if (iterator.hasNext()) {
                    builder.append(" (");
                    while (iterator.hasNext()) {
                        builder.append(cicsObject.getAttributeValue((IAttribute)iterator.next()));
                        builder.append(',');
                    }
                    builder.setLength(builder.length() - 1);
                    builder.append(')');
                }
            }
            return builder.toString();
        }
        if (element instanceof IApplication) {
            IApplication app = (IApplication)element;
            return String.valueOf(app.getName()) + " (" + app.getMajorVersion() + "." + app.getMinorVersion() + "." + app.getMicroVersion() + ")";
        }
        if (element instanceof IApplicationDefinition) {
            IApplicationDefinition app = (IApplicationDefinition)element;
            return String.valueOf(app.getName()) + " (" + app.getMajorVersion() + "." + app.getMinorVersion() + "." + app.getMicroVersion() + ")";
        }
        return cicsObject.getName();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

