/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.model.EqualityHelper;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.model.RegionType;
import com.ibm.cics.core.ui.PluginConstants;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.actions.AbstractPerformOperationAction;
import com.ibm.cics.core.ui.decorators.CICSObjectLabelProvider;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.AbstractRegionTypeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.AddExistingRegionToRegionTypeAction;
import com.ibm.cics.core.ui.internal.cloud.AddNewRegionToRegionTypeAction;
import com.ibm.cics.core.ui.internal.cloud.ApplicationsDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudExplorerContentProvider;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.CloudLabelDecorator;
import com.ibm.cics.core.ui.internal.cloud.CloudLabelProvider;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.HierarchyDropDownAction;
import com.ibm.cics.core.ui.internal.cloud.HierarchyStyle;
import com.ibm.cics.core.ui.internal.cloud.PlatformManagedRegionNodeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.PlatformRegionTypesNodeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.PlatformsRootDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.RemoveRegionFromRegionTypeAction;
import com.ibm.cics.core.ui.internal.cloud.RootDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.ShowBundlesForManagementPartAction;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.eclipse.common.ui.AdaptingSelectionProvider;
import com.ibm.cics.eclipse.common.ui.DelegateLabelProvider;
import com.ibm.cics.explorer.tables.ui.CommonMessages;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IManagementPart;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.model.ui.ICICSWorkbenchActionConstants;
import com.ibm.cics.sm.comm.Context;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CloudExplorer
extends ViewPart {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2011, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String LAST_CLOUD_EXPLORER_CICSPLEX_SELECTED = "LastCloudExplorerCICSplexSelected";
    private static Debug DEBUG = new Debug(CloudExplorer.class);
    private IPartListener2 partListener;
    private IEclipsePreferences.IPreferenceChangeListener preferenceListener;
    private TreeViewer treeViewer;
    private Composite viewComposite;
    private IHandler refreshCommandHandler;
    private ICPSM cpsm;
    private ComboViewer cicsplexCombo;
    private boolean platformResourceAvailable;
    private List<ICICSplex> uniquePlexes;
    private final ScopedPreferenceStore preferenceStore;
    private Action switchHierarchyAction;
    private ICICSplex selectedCICSplex;
    private ConnectionServiceListener connectionListener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if (event.getConnectionCategoryId().equals("com.ibm.cics.sm.connection")) {
                if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                    CloudExplorer.this.prepareForConnectionAsync((ICPSM)event.getConnectable());
                } else if (event instanceof ConnectionServiceListener.ConnectingEvent) {
                    CloudExplorer.this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CloudExplorer.this.connecting();
                        }
                    });
                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent || event instanceof ConnectionServiceListener.ExceptionEvent && ((ConnectionServiceListener.ExceptionEvent)event).getException() != null) {
                    CloudExplorer.this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CloudExplorer.this.disconnected();
                        }
                    });
                }
            }
        }
    };
    private CloudInput cloudInput;
    private ControlEnableState controlEnableState;
    private CloudExplorerContentProvider contentProvider;

    CloudInput getCloudInput() {
        return this.cloudInput;
    }

    public CloudExplorer() {
        this(ConnectionsPlugin.getDefault().getConnectionService());
    }

    CloudExplorer(IConnectionService connectionService) {
        connectionService.addConnectionServiceListener(this.connectionListener);
        this.preferenceStore = (ScopedPreferenceStore)PlatformUI.getPreferenceStore();
    }

    public void createPartControl(Composite parent) {
        DEBUG.enter("createPartControl", (Object)this, (Object)parent);
        this.viewComposite = new Composite(parent, 0);
        GridLayout viewCompositeLayout = new GridLayout(1, false);
        viewCompositeLayout.marginWidth = 0;
        viewCompositeLayout.marginHeight = 0;
        this.viewComposite.setLayout((Layout)viewCompositeLayout);
        this.showTopComposite();
        this.showViewer();
        this.createActions();
        this.addHierarchyListener();
        this.createPopupMenu();
        this.addDoubleClickListener();
        this.addMouseClickListener();
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        handlerService.activateHandler("org.eclipse.ui.file.refresh", this.refreshCommandHandler);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.viewComposite, PluginConstants.CLOUD_EXPLORER_VIEW_HELP_CTX_ID);
        DEBUG.exit("createPartControl");
    }

    private void addMouseClickListener() {
        this.treeViewer.getTree().addMouseListener(new MouseListener(){
            private StructuredSelection nullStructuredSelection = new StructuredSelection();

            public void mouseUp(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
                if (!CloudExplorer.this.treeViewer.getTree().isDisposed() && CloudExplorer.this.treeViewer.getTree().getItem(new Point(arg0.x, arg0.y)) == null) {
                    CloudExplorer.this.treeViewer.setSelection((ISelection)this.nullStructuredSelection);
                }
            }

            public void mouseDoubleClick(MouseEvent arg0) {
            }
        });
    }

    private void addDoubleClickListener() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    final Object element = selection.getFirstElement();
                    if (element instanceof IManagementPart) {
                        BusyIndicator.showWhile((Display)event.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ICICSObject aCICSObject = (ICICSObject)element;
                                IActionFilter actionFilter = (IActionFilter)Platform.getAdapterManager().getAdapter((Object)aCICSObject, IActionFilter.class);
                                if (actionFilter != null && actionFilter.testAttribute((Object)aCICSObject, "mutable", "true")) {
                                    try {
                                        ShowBundlesForManagementPartAction editResourceDefinitionAction = new ShowBundlesForManagementPartAction();
                                        editResourceDefinitionAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)aCICSObject));
                                        editResourceDefinitionAction.run(null);
                                    }
                                    catch (Exception ex) {
                                        DEBUG.error("addDoubleClickListener", (Throwable)ex);
                                    }
                                }
                            }
                        });
                    } else if (element instanceof ICICSObject) {
                        BusyIndicator.showWhile((Display)event.getViewer().getControl().getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                UIPlugin.performDefaultViewAction((ICICSObject)element);
                            }
                        });
                    } else if (CloudExplorer.this.treeViewer.isExpandable(element)) {
                        if (selection instanceof ITreeSelection) {
                            TreePath[] paths = ((ITreeSelection)selection).getPathsFor(element);
                            int i = 0;
                            while (i < paths.length) {
                                CloudExplorer.this.treeViewer.setExpandedState((Object)paths[i], !CloudExplorer.this.treeViewer.getExpandedState((Object)paths[i]));
                                ++i;
                            }
                        } else {
                            CloudExplorer.this.treeViewer.setExpandedState(element, !CloudExplorer.this.treeViewer.getExpandedState(element));
                        }
                    }
                }
            }
        });
    }

    private void addHierarchyListener() {
        DEBUG.enter("addHierarchyListener");
        IEclipsePreferences prefs = UIPlugin.getPluginInstancePreferences();
        if (prefs != null) {
            this.preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    DEBUG.enter("preferenceChange");
                    if (event.getKey().equals("cloudExplorerHierarchy")) {
                        ISystemManagerConnection connection;
                        HierarchyStyle style;
                        Object newValue = event.getNewValue();
                        if (newValue instanceof String && (style = HierarchyStyle.valueOf((String)newValue)) != null) {
                            CloudExplorer.this.switchHierarchyAction.setImageDescriptor(style.getImageDescriptor());
                        }
                        if (CloudExplorer.this.cpsm != null && (connection = CloudExplorer.this.cpsm.getConnection()) != null && connection.isConnected()) {
                            CloudExplorer.this.setInput(CloudExplorer.this.cloudInput);
                        }
                    }
                    DEBUG.exit("preferenceChange");
                }
            };
            prefs.addPreferenceChangeListener(this.preferenceListener);
        }
        DEBUG.exit("addHierarchyListener");
    }

    public void setInput(CloudInput cloudInput) {
        RootDeferredWorkbenchAdapter adapter;
        this.cloudInput = cloudInput;
        HierarchyStyle style = HierarchyStyle.getPreferenceHierarchyStyle(true);
        this.switchHierarchyAction.setImageDescriptor(style.getImageDescriptor());
        switch (style) {
            case APPLICATION: {
                adapter = new ApplicationsDeferredWorkbenchAdapter(cloudInput, (IContext)new Context(cloudInput.getCICSPlexName()));
                break;
            }
            case PLATFORM: {
                adapter = new PlatformsRootDeferredWorkbenchAdapter(cloudInput);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised hierarchy style");
            }
        }
        this.treeViewer.setInput((Object)adapter);
    }

    private void showTopComposite() {
        Composite topComposite = new Composite(this.viewComposite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        GridData data = new GridData(4, 0, true, false);
        topComposite.setLayoutData((Object)data);
        topComposite.setLayout((Layout)gridLayout);
        new Label(topComposite, 0).setText(NLS.bind((String)CloudMessages.cicsplex, null));
        this.cicsplexCombo = new ComboViewer(topComposite, 12);
        data = new GridData(4, 0, true, false);
        topComposite.setLayoutData((Object)data);
        topComposite.setLayout((Layout)gridLayout);
        this.cicsplexCombo.getCombo().setLayoutData((Object)data);
        this.cicsplexCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cicsplexCombo.setLabelProvider((IBaseLabelProvider)new CICSObjectLabelProvider());
        this.cicsplexCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    CloudExplorer.this.selectedCICSplex = null;
                } else {
                    CloudExplorer.this.selectedCICSplex = (ICICSplex)selection.getFirstElement();
                }
                CloudExplorer.this.plexSelectionChanged(CloudExplorer.this.selectedCICSplex);
            }
        });
    }

    private void showViewer() {
        DEBUG.enter("showViewer", (Object)this);
        this.treeViewer = new TreeViewer(this.viewComposite, 0x10000000);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                return 0;
            }

            public boolean equals(Object a, Object b) {
                if (a instanceof ICICSObject && b instanceof ICICSObject) {
                    return EqualityHelper.equals((ICICSObject)((ICICSObject)a), (ICICSObject)((ICICSObject)b));
                }
                return a == null ? b == null : a.equals(b);
            }
        });
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        CloudLabelProvider labelProvider = new CloudLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DelegateLabelProvider((ILabelProvider)labelProvider), (ILabelDecorator)new CloudLabelDecorator(this.treeViewer), null));
        this.contentProvider = new CloudExplorerContentProvider(this.treeViewer, this);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewComposite.layout();
        this.getSite().setSelectionProvider((ISelectionProvider)new AdaptingSelectionProvider(new ISelectionProvider[]{this.treeViewer, this.cicsplexCombo}){

            protected ISelection adaptSelection(ISelection selection) {
                return selection;
            }
        });
        this.cpsm = UIPlugin.getCPSM();
        ISystemManagerConnection connection = this.cpsm.getConnection();
        if (connection != null && connection.isConnected()) {
            Job prepareJob = new Job("PrepareCloudExplorer"){

                protected IStatus run(IProgressMonitor monitor) {
                    CloudExplorer.this.prepareForConnectionAsync(CloudExplorer.this.cpsm);
                    return Status.OK_STATUS;
                }
            };
            prepareJob.schedule();
        }
        DEBUG.exit("showViewer");
    }

    private void removeListeners() {
        IEclipsePreferences prefs;
        DEBUG.enter("removeListeners", (Object)this);
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (this.partListener != null && workbenchWindow != null) {
            workbenchWindow.getPartService().removePartListener(this.partListener);
        }
        if (this.preferenceListener != null && (prefs = UIPlugin.getPluginInstancePreferences()) != null) {
            prefs.removePreferenceChangeListener(this.preferenceListener);
        }
        this.connectionListener.makeStale();
        DEBUG.exit("removeListeners");
    }

    private void connecting() {
        DEBUG.enter("connecting", (Object)this);
        this.setContentDescription(CommonMessages.ResourcesView_statusConnecting);
        DEBUG.exit("connecting");
    }

    private void prepareForConnectionAsync(final ICPSM icpsm) {
        DEBUG.enter("prepareForConnectionAsync", (Object)this, (Object)icpsm);
        this.platformResourceAvailable = icpsm.checkPermission(ICICSOperation.GET, (ICICSType)PlatformType.getInstance());
        if (this.platformResourceAvailable) {
            this.getCICSplexes(icpsm);
        }
        this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CloudExplorer.this.connected(icpsm);
            }
        });
        DEBUG.exit("prepareForConnectionAsync");
    }

    private void connected(ICPSM icpsm) {
        DEBUG.enter("connected", (Object)this);
        this.cpsm = icpsm;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage.isPartVisible((IWorkbenchPart)this)) {
            activePage.activate((IWorkbenchPart)this);
        }
        if (!this.platformResourceAvailable) {
            this.setContentDescription(Messages.getString("ResourcesView.status.cloud.unavailable", new Object[0]));
            if (this.controlEnableState == null) {
                this.controlEnableState = ControlEnableState.disable((Control)this.viewComposite);
            }
        } else {
            if (this.controlEnableState != null) {
                this.controlEnableState.restore();
                this.controlEnableState = null;
            }
            String description = Messages.getString("ResourcesView.status.connected", this.cpsm.getName());
            this.setContentDescription(description);
            String lastCicsplexSelected = this.preferenceStore.getString(LAST_CLOUD_EXPLORER_CICSPLEX_SELECTED);
            this.cicsplexCombo.setInput(this.uniquePlexes);
            ICICSplex selection = null;
            for (ICICSplex plex : this.uniquePlexes) {
                if (!plex.getName().equals(lastCicsplexSelected)) continue;
                selection = plex;
            }
            if (selection == null && this.uniquePlexes.size() > 0) {
                selection = this.uniquePlexes.iterator().next();
            }
            if (selection != null) {
                this.cicsplexCombo.setSelection((ISelection)new StructuredSelection(selection));
            }
        }
        DEBUG.exit("connected");
    }

    private void plexSelectionChanged(ICICSplex cicsPlex) {
        if (cicsPlex != null) {
            if (this.cloudInput == null || !cicsPlex.getName().equals(this.cloudInput.getCICSPlexName())) {
                this.setInput(new CloudInput(this.cpsm, cicsPlex.getName(), this));
                this.preferenceStore.setValue(LAST_CLOUD_EXPLORER_CICSPLEX_SELECTED, cicsPlex.getName());
                this.savePreferenceStore();
            }
        } else {
            this.cloudInput = null;
            this.treeViewer.setInput(null);
        }
    }

    public IContext getCICSplexContext() {
        IStructuredSelection selection = (IStructuredSelection)this.cicsplexCombo.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        ICICSplex plex = (ICICSplex)selection.getFirstElement();
        return new Context(plex.getName());
    }

    private void getCICSplexes(ICPSM icpsm) {
        DEBUG.enter("getCICSplexes", (Object)this);
        ICICSplex[] cicsplexes = icpsm.getCICSplexes();
        this.uniquePlexes = new ArrayList<ICICSplex>();
        ICICSplex[] iCICSplexArray = cicsplexes;
        int n = cicsplexes.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                ICICSplex plex = iCICSplexArray[n2];
                for (ICICSplex cicsPlex : this.uniquePlexes) {
                    if (!plex.getName().equals(cicsPlex.getName())) {
                        continue;
                    }
                    break block3;
                }
                this.uniquePlexes.add(plex);
            }
            ++n2;
        }
        Collections.sort(this.uniquePlexes, new Comparator<ICICSplex>(){

            @Override
            public int compare(ICICSplex arg0, ICICSplex arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        DEBUG.exit("getCICSplexes", this.uniquePlexes);
    }

    private void disconnected() {
        DEBUG.enter("disconnected", (Object)this);
        this.setContentDescription(CommonMessages.ResourcesView_statusDisconnected);
        this.treeViewer.setInput(null);
        this.cloudInput = null;
        this.cpsm = null;
        this.cicsplexCombo.setInput(null);
        DEBUG.exit("disconnected");
    }

    public void dispose() {
        DEBUG.enter("dispose", (Object)this);
        this.removeListeners();
        DEBUG.exit("dispose");
    }

    public void setFocus() {
        DEBUG.enter("setFocus", (Object)this);
        this.treeViewer.getControl().setFocus();
        DEBUG.exit("setFocus");
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        DEBUG.enter("init", (Object)this);
        super.init(site, memento);
        DEBUG.exit("init");
    }

    public void saveState(IMemento memento) {
        DEBUG.enter("saveState", (Object)this, (Object)memento);
        super.saveState(memento);
        DEBUG.exit("saveState");
    }

    private void refresh() {
        DEBUG.enter("refresh", (Object)this);
        this.contentProvider.getDeferredTreeExpansionRestorer().addExpandedTreeElements(this.treeViewer.getExpandedTreePaths());
        this.treeViewer.refresh();
        DEBUG.exit("refresh");
    }

    private void createActions() {
        DEBUG.enter("createActions", (Object)this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.getToolBarManager().add((IAction)this.createCollapseAllAction());
        actionBars.getToolBarManager().add((IAction)this.createRefreshAction());
        actionBars.getToolBarManager().add(this.createSwitchHierarchyAction());
        actionBars.getToolBarManager().update(true);
        DEBUG.exit("createActions");
    }

    private Action createCollapseAllAction() {
        return new Action(NLS.bind((String)CloudMessages.CloudExplorer_Collapse_All, null)){

            public ImageDescriptor getImageDescriptor() {
                return Activator.IMGD_COLLAPSE_ALL;
            }

            public void run() {
                CloudExplorer.this.treeViewer.collapseAll();
            }
        };
    }

    private Action createRefreshAction() {
        Action refreshAction = new Action(Messages.getString("ResourcesView.refreshAction.text", new Object[0])){

            public void run() {
                CloudExplorer.this.refresh();
            }
        };
        refreshAction.setToolTipText(Messages.getString("ResourcesView.refreshAction.tooltip", new Object[0]));
        refreshAction.setImageDescriptor(UIPlugin.IMGD_REFRESH);
        this.refreshCommandHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                CloudExplorer.this.refresh();
                return null;
            }
        };
        return refreshAction;
    }

    private IAction createSwitchHierarchyAction() {
        this.switchHierarchyAction = new HierarchyDropDownAction();
        return this.switchHierarchyAction;
    }

    private void savePreferenceStore() {
        try {
            this.preferenceStore.save();
        }
        catch (IOException e) {
            DEBUG.error("savePreferenceStore", e.getLocalizedMessage());
        }
    }

    protected void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (String separatorName : ICICSWorkbenchActionConstants.getMenuSeparatorNames()) {
                    manager.add((IContributionItem)new Separator(separatorName));
                }
                CloudExplorer.this.addRemoveFromRegionTypeAction(manager);
                CloudExplorer.this.addAddRegionToRegionTypeAction(true, manager);
                CloudExplorer.this.addAddRegionToRegionTypeAction(false, manager);
            }
        });
        Menu popupMenu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(popupMenu);
        this.getSite().registerContextMenu("com.ibm.cics.core.ui.internal.cloud.CloudExplorer", menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void addRemoveFromRegionTypeAction(IMenuManager manager) {
        ITreeSelection selection = (ITreeSelection)this.treeViewer.getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof IManagedRegion) {
            IManagedRegion managedRegion = (IManagedRegion)selection.getFirstElement();
            TreePath[] paths = selection.getPaths();
            if (paths[0].getSegmentCount() > 3) {
                TreePath regionTypePath = paths[0].getParentPath().getParentPath();
                Object regionTypeSegment = regionTypePath.getLastSegment();
                Object platformSegment = regionTypePath.getParentPath().getLastSegment();
                if (regionTypeSegment instanceof ICICSRegionGroupDefinition && platformSegment instanceof PlatformRegionTypesNodeDeferredWorkbenchAdapter) {
                    try {
                        IPlatform platform = ((PlatformRegionTypesNodeDeferredWorkbenchAdapter)platformSegment).getPlatform();
                        RemoveRegionFromRegionTypeAction removeFromRegionTypeAction = new RemoveRegionFromRegionTypeAction((ICICSRegionGroupDefinition)regionTypeSegment, platform, managedRegion, (IWorkbenchPart)this);
                        this.disableActionIfUnsupported(removeFromRegionTypeAction);
                        if (managedRegion.getState().equals((Object)IManagedRegion.StateValue.ACTIVE)) {
                            removeFromRegionTypeAction.setEnabled(false);
                        }
                        manager.add((IAction)removeFromRegionTypeAction);
                    }
                    catch (Exception ex) {
                        DEBUG.error("addRemoveFromRegionTypeAction", "Failed to load the remove region from regions types action class");
                    }
                }
            }
        }
    }

    private void addAddRegionToRegionTypeAction(boolean existingRegion, IMenuManager manager) {
        ITreeSelection selection = (ITreeSelection)this.treeViewer.getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof ICICSRegionGroupDefinition) {
            Object platformSegment;
            ICICSRegionGroupDefinition regionType = (ICICSRegionGroupDefinition)selection.getFirstElement();
            TreePath[] paths = selection.getPaths();
            if (paths[0].getSegmentCount() > 1 && (platformSegment = paths[0].getParentPath().getLastSegment()) instanceof PlatformRegionTypesNodeDeferredWorkbenchAdapter) {
                try {
                    AbstractPerformOperationAction action;
                    IPlatform platform = ((PlatformRegionTypesNodeDeferredWorkbenchAdapter)platformSegment).getPlatform();
                    if (existingRegion) {
                        action = new AddExistingRegionToRegionTypeAction(regionType, platform, (IWorkbenchPart)this, this.selectedCICSplex);
                    } else {
                        action = new AddNewRegionToRegionTypeAction(regionType, platform, (IWorkbenchPart)this);
                        if (!ICICSRegionGroupDefinition.CreateOriginValue.PLATFORM.equals((Object)regionType.getCreateOrigin())) {
                            action.setEnabled(false);
                        }
                    }
                    this.disableActionIfUnsupported(action);
                    manager.add((IAction)action);
                }
                catch (Exception ex) {
                    DEBUG.error("addExistingRegionToRegionTypeAction", "Failed to load the add existing region to regions type action class");
                }
            }
        }
    }

    private void disableActionIfUnsupported(Action action) {
        if (!this.cpsm.checkPermission(ICICSOperation.PERFORM, (ICICSType)RegionType.getInstance())) {
            action.setEnabled(false);
        }
    }

    public Object getObjectParent(Object element) {
        TreeItem[] items;
        DEBUG.enter("getObjectParent", (Object)this);
        Object result = null;
        Tree tree = this.treeViewer.getTree();
        TreeItem[] treeItemArray = items = tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            TreeItem foundItem = this.searchItem(item, element);
            if (foundItem != null) {
                TreeItem parent = foundItem.getParentItem();
                if (parent == null) break;
                result = parent.getData();
                break;
            }
            ++n2;
        }
        DEBUG.exit("getObjectParent", result);
        return result;
    }

    private TreeItem searchItem(TreeItem item, Object element) {
        TreeItem[] subItems;
        Object data = item.getData();
        if (this.objectMatchesReference(element, data)) {
            return item;
        }
        if (data == element) {
            return item;
        }
        TreeItem[] treeItemArray = subItems = item.getItems();
        int n = subItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem subitem = treeItemArray[n2];
            TreeItem found = this.searchItem(subitem, element);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    private boolean objectMatchesReference(Object element, Object data) {
        return element instanceof ICICSObjectReference && data instanceof ICICSObject && ((ICICSObjectReference)element).equals(((ICICSObject)data).getCICSObjectReference());
    }

    public void refresh(final Object element) {
        Tree tree;
        DEBUG.enter("refresh", (Object)this, element);
        if (this.treeViewer != null && !(tree = this.treeViewer.getTree()).isDisposed()) {
            tree.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CloudExplorer.this.contentProvider.getDeferredTreeExpansionRestorer().addExpandedTreeElements(CloudExplorer.this.treeViewer.getExpandedTreePaths());
                    if (!CloudExplorer.this.treeViewer.getTree().isDisposed()) {
                        if (element == null) {
                            CloudExplorer.this.treeViewer.refresh();
                        } else if (element instanceof AbstractRegionTypeDeferredWorkbenchAdapter) {
                            CloudExplorer.this.treeViewer.refresh(CloudExplorer.this.getObjectParent(element));
                        } else if (element instanceof PlatformManagedRegionNodeDeferredWorkbenchAdapter) {
                            CloudExplorer.this.treeViewer.update(CloudExplorer.this.getObjectParent(element), null);
                            CloudExplorer.this.treeViewer.refresh(element);
                        } else if (element instanceof AbstractCPSMDeferredWorkbenchAdapter) {
                            CloudExplorer.this.treeViewer.refresh(element);
                        } else if (element instanceof IApplication) {
                            Object parent = CloudExplorer.this.getObjectParent(element);
                            if (parent != null) {
                                CloudExplorer.this.treeViewer.refresh(parent);
                            } else {
                                CloudExplorer.this.treeViewer.refresh();
                            }
                        } else if (element instanceof IManagedRegion) {
                            Object p2;
                            Object p = CloudExplorer.this.getObjectParent(element);
                            if (p != null && (p2 = CloudExplorer.this.getObjectParent(p)) != null && p2 instanceof ICICSRegionGroupDefinition) {
                                CloudExplorer.this.treeViewer.update(p2, null);
                            }
                            CloudExplorer.this.treeViewer.refresh(CloudExplorer.this.getObjectParent(element));
                        } else {
                            CloudExplorer.this.treeViewer.refresh(CloudExplorer.this.getObjectParent(element));
                        }
                    }
                }
            });
        }
        DEBUG.exit("refresh");
    }
}

