/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.OperationTypesWrapper;
import com.ibm.cics.core.ui.AbstractTreeExpansionRestorer;
import com.ibm.cics.core.ui.ExplorerTreeExpansionRestorer;
import com.ibm.cics.core.ui.internal.cloud.AbstractApplicationDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.ApplicationDefinitionDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.ApplicationStyleApplicationDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudExplorer;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.core.ui.internal.cloud.HierarchyStyle;
import com.ibm.cics.core.ui.internal.cloud.ManagedRegionDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.ManagementPartDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.PlatformDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.PlatformDefinitionDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.PlatformRegionTypeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.PlatformStyleApplicationDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.viewers.ExplorerTreeContentProvider;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IManagementPart;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.model.IPlatformDefinition;
import java.util.HashMap;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class CloudExplorerContentProvider
extends ExplorerTreeContentProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(CloudExplorerContentProvider.class);
    private HashMap<Object, AbstractCPSMDeferredWorkbenchAdapter> adapters = new HashMap();
    private final CloudExplorer cloudExplorer;
    private AbstractTreeExpansionRestorer deferredTreeExpansionRestorer;

    public HierarchyStyle getStyle() {
        return HierarchyStyle.getPreferenceHierarchyStyle(true);
    }

    public CloudExplorerContentProvider(TreeViewer aTreeViewer, CloudExplorer aCloudExplorer) {
        super(aTreeViewer, aCloudExplorer.getSite());
        this.cloudExplorer = aCloudExplorer;
    }

    public boolean mayHaveChildren(Object element) {
        DEBUG.enter("hasChildren", (Object)this, element);
        HierarchyStyle style = this.getStyle();
        boolean result = true;
        if (element instanceof AbstractCPSMDeferredWorkbenchAdapter) {
            result = ((AbstractCPSMDeferredWorkbenchAdapter)element).isContainer();
        } else if (element instanceof ICICSRegionGroupDefinition) {
            result = true;
        } else if (element instanceof OperationTypesWrapper) {
            result = false;
        } else if (element instanceof IManagementPart) {
            result = false;
        } else if (element instanceof IManagedRegion) {
            result = false;
        } else if (element instanceof IPlatformDefinition && style == HierarchyStyle.APPLICATION) {
            result = false;
        } else if (element instanceof IApplicationDefinition && style == HierarchyStyle.PLATFORM) {
            result = false;
        } else if (element instanceof IPlatform && style == HierarchyStyle.APPLICATION) {
            result = false;
        } else if (element instanceof ErrorWrapper) {
            result = false;
        } else if (element instanceof PendingUpdateAdapter) {
            result = false;
        }
        DEBUG.exit("getChildren", (Object)result);
        return result;
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        DEBUG.enter("getAdapter", (Object)this, element);
        IDeferredWorkbenchAdapter adapter = null;
        adapter = this.adapters.get(element);
        if (adapter == null) {
            if (element instanceof IPlatform) {
                adapter = this.getAdapterForPlatform((IPlatform)element);
            } else if (element instanceof IPlatformDefinition) {
                adapter = this.getAdapterForPlatformDefinition(element);
            } else if (element instanceof IApplication) {
                adapter = this.getAdapterForApplication(element);
            } else if (element instanceof IApplicationDefinition) {
                adapter = this.getAdapterForApplicationDefinition(element);
            } else if (element instanceof ICICSRegionGroupDefinition && this.getStyle() == HierarchyStyle.PLATFORM) {
                adapter = new PlatformRegionTypeDeferredWorkbenchAdapter(this.cloudExplorer.getCloudInput(), (ICICSRegionGroupDefinition)element);
            } else if (element instanceof IManagementPart) {
                adapter = new ManagementPartDeferredWorkbenchAdapter(this.cloudExplorer.getCloudInput(), (IManagementPart)element);
            } else if (element instanceof IManagedRegion) {
                adapter = new ManagedRegionDeferredWorkbenchAdapter(this.cloudExplorer.getCloudInput(), (IManagedRegion)element);
            } else if (element instanceof IDeferredWorkbenchAdapter) {
                adapter = (IDeferredWorkbenchAdapter)element;
            }
            if (adapter instanceof AbstractCPSMDeferredWorkbenchAdapter) {
                this.adapters.put(element, (AbstractCPSMDeferredWorkbenchAdapter)adapter);
            }
        }
        DEBUG.exit("getAdapter", (Object)adapter);
        return adapter;
    }

    private IDeferredWorkbenchAdapter getAdapterForApplicationDefinition(Object element) {
        ApplicationDefinitionDeferredWorkbenchAdapter adapter;
        switch (this.getStyle()) {
            case APPLICATION: {
                adapter = new ApplicationDefinitionDeferredWorkbenchAdapter(this.cloudExplorer.getCloudInput(), (IApplicationDefinition)element);
                break;
            }
            default: {
                adapter = null;
            }
        }
        return adapter;
    }

    private IDeferredWorkbenchAdapter getAdapterForApplication(Object element) {
        AbstractApplicationDeferredWorkbenchAdapter adapter;
        switch (this.getStyle()) {
            case APPLICATION: {
                adapter = new ApplicationStyleApplicationDeferredWorkbenchAdapter(this.cloudExplorer.getCloudInput(), (IApplication)element);
                break;
            }
            default: {
                adapter = new PlatformStyleApplicationDeferredWorkbenchAdapter(this.cloudExplorer.getCloudInput(), (IApplication)element);
            }
        }
        return adapter;
    }

    private IDeferredWorkbenchAdapter getAdapterForPlatformDefinition(Object element) {
        PlatformDefinitionDeferredWorkbenchAdapter adapter;
        switch (this.getStyle()) {
            case APPLICATION: {
                adapter = null;
                break;
            }
            default: {
                adapter = new PlatformDefinitionDeferredWorkbenchAdapter(this.cloudExplorer.getCloudInput(), (IPlatformDefinition)element);
            }
        }
        return adapter;
    }

    private IDeferredWorkbenchAdapter getAdapterForPlatform(IPlatform platform) {
        PlatformDeferredWorkbenchAdapter adapter;
        switch (this.getStyle()) {
            case APPLICATION: {
                adapter = null;
                break;
            }
            default: {
                adapter = new PlatformDeferredWorkbenchAdapter(this.cloudExplorer.getCloudInput(), platform);
            }
        }
        return adapter;
    }

    @Override
    public void dispose() {
        DEBUG.enter("dispose", (Object)this);
        this.disposeAdapters();
        DEBUG.exit("dispose");
    }

    private void disposeAdapters() {
        DEBUG.enter("disposeAdapters", (Object)this);
        if (this.adapters.size() > 0) {
            for (AbstractCPSMDeferredWorkbenchAdapter adapter : this.adapters.values()) {
                adapter.dispose();
            }
            this.adapters.clear();
        }
        DEBUG.exit("disposeAdapters");
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        DEBUG.enter("inputChanged", (Object)this, (Object)viewer, oldInput, newInput);
        super.inputChanged(viewer, oldInput, newInput);
        this.disposeAdapters();
        if (newInput != null && viewer instanceof TreeViewer) {
            if (this.deferredTreeExpansionRestorer != null) {
                this.deferredTreeExpansionRestorer.dispose();
            }
            this.deferredTreeExpansionRestorer = new ExplorerTreeExpansionRestorer((TreeViewer)viewer, this);
        }
        DEBUG.exit("inputChanged");
    }

    public AbstractTreeExpansionRestorer getDeferredTreeExpansionRestorer() {
        return this.deferredTreeExpansionRestorer;
    }
}

