/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ILazyTreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.progress.WorkbenchJob;

public class ExplorerTreeContentProvider
extends DeferredTreeContentManager
implements ILazyTreePathContentProvider {
    private static final TreePath[] EMPTY_TREE_PATH = new TreePath[0];
    private Map<Object, List<Object>> childrenMap = new HashMap<Object, List<Object>>();
    private ListenerList jobListeners;
    private TreeViewer viewer;
    private Object input;

    public ExplorerTreeContentProvider(TreeViewer viewer, IWorkbenchPartSite site) {
        super((AbstractTreeViewer)viewer, site);
        if ((viewer.getTree().getStyle() & 0x10000000) == 0) {
            throw new IllegalArgumentException("Supplied viewer must be a virtual tree");
        }
        this.viewer = viewer;
    }

    public ExplorerTreeContentProvider(TreeViewer viewer) {
        this(viewer, null);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
        if (viewer != this.viewer) {
            throw new IllegalArgumentException("Can't change viewer!");
        }
        if (oldInput != null) {
            this.cancel(oldInput);
        }
        this.childrenMap.clear();
    }

    public void updateElement(final TreePath parentPath, final int index) {
        Object parent = this.getElement(parentPath);
        List<Object> children = this.childrenMap.get(parent);
        if (children != null) {
            final Object child = children.get(index);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ExplorerTreeContentProvider.this.viewer.replace((Object)parentPath, index, child);
                    ExplorerTreeContentProvider.this.viewer.setHasChildren(child, ExplorerTreeContentProvider.this.mayHaveChildren(child));
                }
            });
        }
    }

    protected IElementCollector createElementCollector(Object parent, PendingUpdateAdapter placeholder) {
        return (ExplorerPendingUpdateAdapter)placeholder;
    }

    public void updateChildCount(TreePath treePath, int currentChildCount) {
        Object element = this.getElement(treePath);
        ExplorerPendingUpdateAdapter pendingUpdateAdapter = this.getChildren(treePath);
        if (pendingUpdateAdapter != null) {
            ArrayList<ExplorerPendingUpdateAdapter> children = new ArrayList<ExplorerPendingUpdateAdapter>();
            children.add(pendingUpdateAdapter);
            this.childrenMap.put(element, children);
            this.viewer.setChildCount((Object)treePath, children.size());
            this.updateElement(treePath, 0);
        }
    }

    public void updateHasChildren(TreePath path) {
        Object element = this.getElement(path);
        this.viewer.setHasChildren((Object)path, this.mayHaveChildren(element));
    }

    private Object getElement(TreePath path) {
        return path.getSegmentCount() == 0 ? this.input : path.getLastSegment();
    }

    public TreePath[] getParents(Object element) {
        return EMPTY_TREE_PATH;
    }

    protected void addChildren(Object parent, Object[] childrenArray, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    public Object[] getChildren(Object parent) {
        throw new UnsupportedOperationException("This content provider is tree-path based");
    }

    public ExplorerPendingUpdateAdapter getChildren(TreePath parentPath) {
        Object parent = this.getElement(parentPath);
        IDeferredWorkbenchAdapter element = this.getAdapter(parent);
        if (element == null) {
            return null;
        }
        ExplorerPendingUpdateAdapter placeholder = this.createExplorerPendingUpdateAdapter(parentPath);
        this.startFetchingDeferredChildren(parent, element, placeholder);
        return placeholder;
    }

    private ExplorerPendingUpdateAdapter createExplorerPendingUpdateAdapter(TreePath parentPath) {
        return new ExplorerPendingUpdateAdapter(parentPath);
    }

    protected void runClearPlaceholderJob(PendingUpdateAdapter placeholder) {
        ExplorerPendingUpdateAdapter ePlaceholder = (ExplorerPendingUpdateAdapter)placeholder;
        if (ePlaceholder.isRemoved() || !PlatformUI.isWorkbenchRunning()) {
            return;
        }
        ReplacePlaceholderJob clearJob = new ReplacePlaceholderJob("Clear", ePlaceholder);
        clearJob.setSystem(true);
        clearJob.schedule();
    }

    protected PendingUpdateAdapter createPendingUpdateAdapter() {
        throw new UnsupportedOperationException("Use createExplorerPendingUpdateAdapter(parent) instead!");
    }

    public void addUpdateCompleteListener(IJobChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeUpdateCompleteListener(IJobChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addUpdateCompleteListener(Listener listener) {
        if (listener == null && this.jobListeners != null) {
            Object[] listeners = this.jobListeners.getListeners();
            if (listeners.length == 1) {
                this.removeUpdateCompleteListener((Listener)listeners[0]);
            }
        } else {
            if (this.jobListeners == null) {
                this.jobListeners = new ListenerList();
            }
            this.jobListeners.add((Object)listener);
        }
    }

    public void removeUpdateCompleteListener(Listener listener) {
        if (this.jobListeners != null) {
            this.jobListeners.remove((Object)listener);
        }
    }

    public static class ExplorerPendingUpdateAdapter
    extends PendingUpdateAdapter
    implements IElementCollector {
        private final List<Object> children = new ArrayList<Object>();
        private final TreePath path;

        public ExplorerPendingUpdateAdapter(TreePath path) {
            this.path = path.createChildPath((Object)this);
        }

        protected boolean isRemoved() {
            return super.isRemoved();
        }

        protected void setRemoved(boolean removedValue) {
            super.setRemoved(removedValue);
        }

        public void add(Object element, IProgressMonitor monitor) {
            this.children.add(element);
        }

        public void add(Object[] elements, IProgressMonitor monitor) {
            this.children.addAll(Arrays.asList(elements));
        }

        public void done() {
        }

        public TreePath getPath() {
            return this.path;
        }
    }

    public static interface Listener {
        public void updateComplete(ExplorerPendingUpdateAdapter var1);
    }

    public final class ReplacePlaceholderJob
    extends WorkbenchJob {
        private final ExplorerPendingUpdateAdapter placeholder;

        private ReplacePlaceholderJob(String name, ExplorerPendingUpdateAdapter placeholder) {
            super(name);
            this.placeholder = placeholder;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!this.placeholder.isRemoved()) {
                Control control = ExplorerTreeContentProvider.this.viewer.getControl();
                if (control.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                TreePath parentPath = this.placeholder.path.getParentPath();
                Object parent = ExplorerTreeContentProvider.this.getElement(parentPath);
                List children = (List)ExplorerTreeContentProvider.this.childrenMap.get(parent);
                if (children != null) {
                    children.clear();
                    if (this.placeholder.children.size() > 0) {
                        children.addAll(this.placeholder.children);
                        ExplorerTreeContentProvider.this.updateElement(parentPath, 0);
                    }
                    ExplorerTreeContentProvider.this.viewer.setChildCount((Object)parentPath, children.size());
                    this.placeholder.setRemoved(true);
                    Display.getCurrent().timerExec(100, new Runnable(){

                        @Override
                        public void run() {
                            if (ExplorerTreeContentProvider.this.jobListeners != null) {
                                Object[] objectArray = ExplorerTreeContentProvider.this.jobListeners.getListeners();
                                int n = objectArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Object listener = objectArray[n2];
                                    ((Listener)listener).updateComplete(ReplacePlaceholderJob.this.placeholder);
                                    ++n2;
                                }
                            }
                        }
                    });
                }
            }
            return Status.OK_STATUS;
        }
    }
}

