/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.views.ColumnDataManager;
import com.ibm.cics.core.ui.properties.CICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.properties.CICSTypePropertySource;
import com.ibm.cics.core.ui.properties.CICSTypePropertySourceAdapterFactory;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.views.IDefaultColumnsProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.LegacyTableManager;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.core.ui.views.ResourcesViewColumnDialog;
import com.ibm.cics.core.ui.views.Scheduler;
import com.ibm.cics.explorer.tables.ui.ResourcesLabelProvider;
import com.ibm.cics.model.ICICSAttribute;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class PreferenceService {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2015, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long COLUMN_SAVE_DELAY = 1000L;
    private static final Debug debug = new Debug(PreferenceService.class);
    private final Scheduler saveColumnScheduler = new Scheduler(new Runnable(){

        @Override
        public void run() {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    debug.enter("Scheduler.saveColumns", (Object)this, (Object)PreferenceService.this.saveEnabled);
                    List<LegacyTableManager.ColumnData> columns = PreferenceService.this.legacyTableManager.getColumnData();
                    if (columns != null) {
                        PreferenceService.this.columnDataManager.storeColumnData(columns, PreferenceService.this.propertySource.getType());
                    }
                    debug.exit("Scheduler.saveColumns");
                }
            });
        }
    }, 1000L);
    private boolean saveEnabled;
    private final LegacyTableManager legacyTableManager;
    private final IDefaultColumnsProvider defaultColumnsProvider;
    private CICSTypePropertySource propertySource;
    private ColumnDataManager columnDataManager;

    public PreferenceService(LegacyTableManager legacyTableManager, boolean saveEnabled, IElementTypeService elementTypeService, IDefaultColumnsProvider defaultColumnsProvider) {
        this.legacyTableManager = legacyTableManager;
        this.propertySource = CICSTypePropertySourceAdapterFactory.getDecoratedCICSTypePropertySource(elementTypeService.getElementType());
        this.defaultColumnsProvider = defaultColumnsProvider;
        this.saveEnabled = saveEnabled;
        elementTypeService.addElementTypeServiceListener(new IElementTypeService.ElementTypeServiceListener(){

            public void event(final IElementTypeService.Event event) {
                PreferenceService.this.withSuppressedSave(new Runnable(){

                    @Override
                    public void run() {
                        if (event instanceof IElementTypeService.ElementTypeChangedEvent) {
                            PreferenceService.this.propertySource = CICSTypePropertySourceAdapterFactory.getDecoratedCICSTypePropertySource(((IElementTypeService.ElementTypeChangedEvent)event).getNewType());
                            PreferenceService.this.legacyTableManager.getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    PreferenceService.this.legacyTableManager.setColumnData(PreferenceService.this.refresh());
                                }
                            });
                        }
                    }
                });
            }
        });
        legacyTableManager.addListener(new LegacyTableManager.Listener(){

            public void event(LegacyTableManager.Event event) {
                if (event instanceof LegacyTableManager.ColumnEvent) {
                    if (event instanceof LegacyTableManager.ColumnAddedEvent) {
                        TableViewerColumn tableViewerColumn = ((LegacyTableManager.ColumnAddedEvent)event).getColumn();
                        TableColumn tableColumn = tableViewerColumn.getColumn();
                        IAttributePropertyDescriptor descriptor = PreferenceService.this.propertySource.getPropertyDescriptor((Object)((ICICSAttribute)((LegacyTableManager.ColumnAddedEvent)event).getColumnId()).getPropertyId());
                        tableColumn.setData(IPropertyDescriptor.class.getName(), (Object)descriptor);
                        tableColumn.setText(descriptor.getDisplayName());
                        tableColumn.setToolTipText(descriptor.getDescription());
                        ResourcesLabelProvider labelProvider = new ResourcesLabelProvider((ICICSObjectPropertyDescriptor)((CICSObjectPropertyDescriptor)descriptor), null, null, null, null);
                        tableViewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
                    }
                    PreferenceService.this.scheduleSaveColumns();
                } else if (event instanceof LegacyTableManager.TableDisposedEvent) {
                    PreferenceService.this.saveColumnScheduler.force();
                }
            }
        });
    }

    public void setColumnDataManager(final ColumnDataManager columnDataManager) {
        this.withSuppressedSave(new Runnable(){

            @Override
            public void run() {
                PreferenceService.this.columnDataManager = columnDataManager;
                PreferenceService.this.legacyTableManager.setColumnData(PreferenceService.this.refresh());
            }
        });
    }

    private List<LegacyTableManager.ColumnData> refresh() {
        debug.enter("refresh");
        List<LegacyTableManager.ColumnData> columnData = this.columnDataManager.getSavedColumnData(this.propertySource.getType());
        if (columnData.size() == 0) {
            for (ICICSAttribute<?> attribute : this.defaultColumnsProvider.getDefaultColumns()) {
                columnData.add(new LegacyTableManager.ColumnData(attribute, -1));
            }
        }
        debug.exit("refresh");
        return columnData;
    }

    private void withSuppressedSave(Runnable r) {
        boolean oldSaveEnabled = this.saveEnabled;
        try {
            this.saveColumnScheduler.force();
            this.saveEnabled = false;
            r.run();
        }
        finally {
            this.saveEnabled = oldSaveEnabled;
        }
    }

    private void scheduleSaveColumns() {
        if (this.saveEnabled) {
            this.saveColumnScheduler.scheduleUpdate();
        }
    }

    public void resetColumns() {
        this.saveColumnScheduler.force();
        this.columnDataManager.resetColumnData(this.propertySource.getType());
        this.setColumnDataManager(this.columnDataManager);
    }

    public CICSTypePropertySource getPropertySource() {
        return this.propertySource;
    }

    public Action getCustomizeColumnsAction() {
        return new Action(Messages.getString("ResourcesView.customizeColumnsAction.text", new Object[0]), UIPlugin.getImageDescriptor("icons/full/elcl16/customize_columns.gif")){

            public void run() {
                ResourcesViewColumnDialog dialog = new ResourcesViewColumnDialog(Display.getCurrent().getActiveShell(), PreferenceService.this.propertySource, PreferenceService.this.legacyTableManager, PreferenceService.this);
                dialog.open();
            }
        };
    }
}

