/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.comm.IConnectableListener;
import com.ibm.cics.core.comm.IConnection;
import java.util.logging.Logger;

public abstract class AbstractConnectable
implements IConnectable {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2010, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger = Logger.getLogger("com.ibm.cics.core.comm");
    private IConnection connection;

    @Override
    public void setConnection(IConnection connection) {
        Debug.event((Logger)logger, (String)this.getClass().getName(), (String)"setConnection", (Object)this, (Object)connection);
        this.connection = connection;
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws ConnectionException {
        if (this.connection != null) {
            IConnection iConnection = this.connection;
            synchronized (iConnection) {
                this.connection.disconnect();
            }
        }
    }

    @Override
    @Deprecated
    public void addListener(IConnectableListener connectableListener) {
    }

    @Deprecated
    public void removeListener(IConnectableListener listener) {
    }
}

