/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.common.util.StaleableEventListener;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public interface IConnectionProviderRegistry {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public IStatus getConnectionProviderStatus(IConnectionProvider var1);

    public IWritableConnectionProvider getLocalConnectionProvider();

    public List<IConnectionProvider> getConnectionProviders();

    public void addListener(ConnectionProviderRegistryListener var1);

    public static class ConnectionProviderAddedEvent
    extends ConnectionProviderRegistryEvent {
        public ConnectionProviderAddedEvent(IConnectionProvider connectionProvider) {
            super(connectionProvider);
        }
    }

    public static abstract class ConnectionProviderRegistryEvent {
        private IConnectionProvider connectionProvider;

        public ConnectionProviderRegistryEvent(IConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        public IConnectionProvider getConnectionProvider() {
            return this.connectionProvider;
        }
    }

    public static abstract class ConnectionProviderRegistryListener
    extends StaleableEventListener<ConnectionProviderRegistryEvent> {
    }

    public static class ConnectionProviderRemovedEvent
    extends ConnectionProviderRegistryEvent {
        public ConnectionProviderRemovedEvent(IConnectionProvider connectionProvider) {
            super(connectionProvider);
        }
    }

    public static class ConnectionProviderUpdatedEvent
    extends ConnectionProviderRegistryEvent {
        public ConnectionProviderUpdatedEvent(IConnectionProvider connectionProvider) {
            super(connectionProvider);
        }
    }
}

