/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.connections.internal.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CollectionUtils {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static <K, V> List<V> filter(Collection<V> list, Function<V, Boolean> filter) {
        ArrayList<V> filteredList = new ArrayList<V>();
        for (V v : list) {
            if (!filter.evaluate(v).booleanValue()) continue;
            filteredList.add(v);
        }
        return filteredList;
    }

    public static <K, V> Map<K, V> map(Collection<V> list, Function<V, K> mapFunction) {
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        for (V v : list) {
            V oldValue = map.put(mapFunction.evaluate(v), v);
            if (oldValue == null) continue;
            throw new IllegalArgumentException("Map function was not unique for values: " + v + ", " + oldValue);
        }
        return map;
    }

    public static <K, V> List<List<V>> groupBy(Collection<V> list, Function<V, K> groupFunction) {
        LinkedHashMap<K, ArrayList<V>> map = new LinkedHashMap<K, ArrayList<V>>();
        for (V v : list) {
            K k = groupFunction.evaluate(v);
            ArrayList<V> vs = (ArrayList<V>)map.get(k);
            if (vs == null) {
                vs = new ArrayList<V>();
                map.put(k, vs);
            }
            vs.add(v);
        }
        return new ArrayList<List<V>>(map.values());
    }

    public static <I, O> List<O> transform(Collection<I> list, Function<I, O> transformFunction) {
        ArrayList<O> transformedList = new ArrayList<O>();
        for (I in : list) {
            transformedList.add(transformFunction.evaluate(in));
        }
        return transformedList;
    }
}

