/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionState;
import com.ibm.cics.core.connections.internal.AbstractSignonSignoffAction;
import org.eclipse.jface.action.IAction;

public class SignonAction
extends AbstractSignonSignoffAction {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EX1 (c) Copyright IBM Corp. 2011, 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(SignonAction.class);

    public void run(IAction action) {
        debug.enter("run", (Object)action);
        ConnectionsPlugin connectionsPlugin = ConnectionsPlugin.getDefault();
        String activeConnectionCategory = connectionsPlugin.getActiveConnectionCategoryService().getActiveConnectionCategory();
        IConnectionState state = connectionsPlugin.getConnectionService().getConnectionState(activeConnectionCategory);
        ConnectionProfile configuration = state.getConnectionProfile();
        if (configuration != null) {
            connectionsPlugin.getConnectionService().connectAsync(configuration.getId());
        }
        debug.exit("run");
    }

    @Override
    boolean enabledWhenConnected() {
        return false;
    }
}

