/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.model.AbstractCICSResourceType;
import com.ibm.cics.core.model.AbstractCPSMDefinitionType;
import com.ibm.cics.core.model.AbstractCPSMManagerType;
import com.ibm.cics.model.CICSDateAttributeAggregation;
import com.ibm.cics.model.CICSEnumAttributeAggregation;
import com.ibm.cics.model.CICSNumericAttributeAggregation;
import com.ibm.cics.model.CICSObjectAggregateRecord;
import com.ibm.cics.model.CICSStringAttributeAggregation;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeAggregation;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSDefinitionType;
import com.ibm.cics.model.ICICSEnum;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.sm.internal.GraphQLParseException;
import com.ibm.cics.sm.comm.sm.internal.GraphQLRequestHelper;
import com.ibm.cics.sm.comm.sm.internal.Messages;
import com.ibm.cics.sm.comm.sm.internal.SMCPSMConnection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class CICSObjectAggregateRecordParser {
    private static final Debug debug = new Debug(CICSObjectAggregateRecordParser.class);

    public static List<CICSObjectAggregateRecord> parseAggregateRecordResult(JsonElement json, ICICSType<?> type, List<ICICSAttribute<?>> requestedAttributes, IContext context) throws GraphQLParseException, ConnectionException {
        debug.enter("parseAggregateRecordResult", (Object)json, (Object)type.getResourceTableName(), requestedAttributes);
        ArrayList<CICSObjectAggregateRecord> cicsObjectAggregateRecords = new ArrayList<CICSObjectAggregateRecord>();
        JsonObject jsonObj = json.getAsJsonObject();
        if (jsonObj.get("data") == null) {
            debug.exit("parseAggregateRecordResult", null);
            return null;
        }
        JsonObject data = jsonObj.get("data").getAsJsonObject();
        JsonObject plexes = data.get("cicsplex").getAsJsonObject();
        JsonObject cicsType = CICSObjectAggregateRecordParser.getCICSType(plexes, context, type);
        if (cicsType.get("groupBy") != null) {
            JsonArray groupBy = cicsType.get("groupBy").getAsJsonArray();
            CICSObjectAggregateRecordParser.parseGroupBy(groupBy, cicsObjectAggregateRecords, requestedAttributes);
        } else {
            Optional<CICSObjectAggregateRecord> objectAggregateRecord = CICSObjectAggregateRecordParser.parseObjectAggregateRecord(cicsType, requestedAttributes);
            if (objectAggregateRecord.isPresent()) {
                cicsObjectAggregateRecords.add(objectAggregateRecord.get());
            }
        }
        debug.exit("parseAggregateRecordResult", cicsObjectAggregateRecords);
        return cicsObjectAggregateRecords;
    }

    public static String parseErrors(JsonElement json) {
        debug.enter("parseErrors", (Object)json);
        JsonObject jsonObj = json.getAsJsonObject();
        if (jsonObj.get("errors") == null) {
            debug.exit("parseErrors", null);
            return null;
        }
        JsonArray data = jsonObj.get("errors").getAsJsonArray();
        String errors = null;
        int i = 0;
        while (i < data.size()) {
            JsonElement elementMessage = data.get(i).getAsJsonObject().get("message");
            String message = elementMessage != null ? elementMessage.getAsString() : Messages.CICSObjectAggregateRecordParser_unknownError;
            debug.error("parseErrors", message);
            if (i == 0) {
                errors = message;
            }
            ++i;
        }
        debug.exit("parseErrors", errors);
        return errors;
    }

    private static void parseGroupBy(JsonArray groupBy, List<CICSObjectAggregateRecord> cicsObjectAggregateRecords, List<ICICSAttribute<?>> requestedAttributes) {
        int numberOfInternalGroupBys = groupBy.size();
        int i = 0;
        while (i < numberOfInternalGroupBys) {
            JsonObject objecti = groupBy.get(i).getAsJsonObject();
            if (objecti.get("groupBy") != null) {
                JsonArray insideGroupBy = groupBy.get(i).getAsJsonObject().get("groupBy").getAsJsonArray();
                CICSObjectAggregateRecordParser.parseGroupBy(insideGroupBy, cicsObjectAggregateRecords, requestedAttributes);
            } else {
                Optional<CICSObjectAggregateRecord> objectAggregateRecord = CICSObjectAggregateRecordParser.parseObjectAggregateRecord(objecti, requestedAttributes);
                if (objectAggregateRecord.isPresent()) {
                    cicsObjectAggregateRecords.add(objectAggregateRecord.get());
                }
            }
            ++i;
        }
    }

    public static JsonObject getCICSType(JsonObject plex, IContext context, ICICSType<?> type) throws ConnectionException {
        boolean isCPSMDefinition = type instanceof AbstractCPSMDefinitionType;
        boolean isCPSMManager = type instanceof AbstractCPSMManagerType;
        boolean useScopedContext = isCPSMDefinition || isCPSMManager ? false : SMCPSMConnection.isScopedContext(context);
        JsonObject outObject = plex;
        if (useScopedContext) {
            outObject = CICSObjectAggregateRecordParser.getRegionOrGroupResult(outObject, (IScopedContext)context);
        }
        if (useScopedContext) {
            outObject = type instanceof ICICSDefinitionType ? ((JsonObject)outObject.get("csd")).get("cicsDefinitions").getAsJsonObject() : outObject.get("cicsResources").getAsJsonObject();
        } else if (type instanceof AbstractCICSResourceType) {
            outObject = outObject.get("cicsResources").getAsJsonObject();
        } else if (type instanceof ICICSDefinitionType) {
            outObject = ((JsonObject)outObject.get("drep")).get("cicsDefinitions").getAsJsonObject();
        } else if (isCPSMDefinition) {
            outObject = ((JsonObject)outObject.get("drep")).get("cpsmDefinitions").getAsJsonObject();
        } else if (isCPSMManager) {
            outObject = outObject.get("cpsmManagers").getAsJsonObject();
        }
        return outObject.get(type.getResourceTableName().toLowerCase()).getAsJsonObject();
    }

    private static JsonObject getRegionOrGroupResult(JsonObject outObject, IScopedContext context) throws ConnectionException {
        switch (context.getScopeType()) {
            case REGION: {
                return outObject.get("region").getAsJsonObject();
            }
            case GROUP: {
                return outObject.get("regionGroup").getAsJsonObject();
            }
            case UNKNOWN: {
                JsonElement region = outObject.get("region");
                JsonElement regionGroup = outObject.get("regionGroup");
                if (!CICSObjectAggregateRecordParser.isNull(region)) {
                    return region.getAsJsonObject();
                }
                if (!CICSObjectAggregateRecordParser.isNull(regionGroup)) {
                    return regionGroup.getAsJsonObject();
                }
                throw new ConnectionException("No results for the supplied scope");
            }
        }
        throw new RuntimeException("Unknown scope type");
    }

    private static boolean isNull(JsonElement object) {
        return object == null || object.isJsonNull();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Optional<CICSObjectAggregateRecord> parseObjectAggregateRecord(JsonObject rowObject, List<ICICSAttribute<?>> requestedAttributes) throws GraphQLParseException {
        JsonElement aggregateRecordElement = rowObject.get("aggregateRecord");
        if (CICSObjectAggregateRecordParser.isNull(aggregateRecordElement)) {
            return Optional.empty();
        }
        JsonObject aggregateRecord = aggregateRecordElement.getAsJsonObject();
        int count = rowObject.get("count").getAsInt();
        CICSObjectAggregateRecord objectAggregateRecord = new CICSObjectAggregateRecord(count);
        for (ICICSAttribute<?> cicsAttribute : requestedAttributes) {
            CICSStringAttributeAggregation attributeAggregation = null;
            Class type = cicsAttribute.getType();
            JsonElement attVal = aggregateRecord.get(cicsAttribute.getPropertyId());
            if (attVal == null) {
                throw new IllegalArgumentException("Could not find attribute in returned JSON: " + cicsAttribute.getPropertyId());
            }
            if (!(attVal instanceof JsonObject)) throw new GraphQLParseException("Unexpected JSON attribute type: " + attVal.getClass().getSimpleName());
            JsonObject attributeValues = attVal.getAsJsonObject();
            if (type.equals(String.class)) {
                attributeAggregation = CICSObjectAggregateRecordParser.parseStringAggregation(cicsAttribute, attributeValues);
            } else if (type.equals(Long.class)) {
                attributeAggregation = CICSObjectAggregateRecordParser.parseNumericAggregation(cicsAttribute, attributeValues);
            } else if (type.equals(Date.class)) {
                attributeAggregation = CICSObjectAggregateRecordParser.parseDateAggregation(cicsAttribute, attributeValues);
            } else {
                if (!ICICSEnum.class.isAssignableFrom(type)) throw new IllegalArgumentException("Unrecognized attribute type: " + type);
                attributeAggregation = CICSObjectAggregateRecordParser.parseEnumAggregation(cicsAttribute, attributeValues);
            }
            objectAggregateRecord.addAttributeAggregation(cicsAttribute, (ICICSAttributeAggregation)attributeAggregation);
        }
        return Optional.of(objectAggregateRecord);
    }

    private static CICSStringAttributeAggregation parseStringAggregation(ICICSAttribute<?> cicsAttribute, JsonObject attributeValues) {
        return new CICSStringAttributeAggregation(CICSObjectAggregateRecordParser.stringValue(attributeValues, "value"), CICSObjectAggregateRecordParser.mandatoryIntValue(attributeValues, "distinctValues"), CICSObjectAggregateRecordParser.mandatoryIntValue(attributeValues, "unsupported"));
    }

    private static CICSNumericAttributeAggregation parseNumericAggregation(ICICSAttribute<Long> attribute, JsonObject attributeValues) {
        return new CICSNumericAttributeAggregation(CICSObjectAggregateRecordParser.longValue(attributeValues, "min"), CICSObjectAggregateRecordParser.longValue(attributeValues, "max"), CICSObjectAggregateRecordParser.doubleValue(attributeValues, "average"), CICSObjectAggregateRecordParser.longValue(attributeValues, "sum"), CICSObjectAggregateRecordParser.stringValue(attributeValues, "difference"), CICSObjectAggregateRecordParser.mandatoryIntValue(attributeValues, "distinctValues"), CICSObjectAggregateRecordParser.mandatoryIntValue(attributeValues, "unsupported"), CICSObjectAggregateRecordParser.mandatoryIntValue(attributeValues, "unspecified"), CICSObjectAggregateRecordParser.getMetaValues(attributeValues, attribute));
    }

    private static Optional<Map.Entry<Long, Integer>> getMetaValues(JsonObject attributeValues, ICICSAttribute<Long> attribute) {
        return GraphQLRequestHelper.getMetaValue(attribute).map(mV -> {
            String metaKey = mV.getValue() == ICICSAttributeConstants.NA_CODE ? "na" : (String)mV.getKey();
            int metaCount = CICSObjectAggregateRecordParser.mandatory(CICSObjectAggregateRecordParser.intValue(attributeValues, metaKey), metaKey);
            return new AbstractMap.SimpleEntry<Long, Integer>((Long)mV.getValue(), metaCount);
        });
    }

    private static CICSEnumAttributeAggregation parseEnumAggregation(ICICSAttribute<?> cicsAttribute, JsonObject attributeValues) {
        return new CICSEnumAttributeAggregation(CICSObjectAggregateRecordParser.getEnumValues(attributeValues), CICSObjectAggregateRecordParser.mandatoryIntValue(attributeValues, "unsupported"), CICSObjectAggregateRecordParser.mandatoryIntValue(attributeValues, "unspecified"));
    }

    private static List<CICSEnumAttributeAggregation.ValueCountPair> getEnumValues(JsonObject attributeValues) {
        JsonArray valuesArray = attributeValues.getAsJsonArray("values");
        ArrayList<CICSEnumAttributeAggregation.ValueCountPair> countValues = new ArrayList<CICSEnumAttributeAggregation.ValueCountPair>();
        for (JsonElement cvp : valuesArray) {
            JsonObject cvpObject = cvp.getAsJsonObject();
            CICSEnumAttributeAggregation.ValueCountPair countValuePair = new CICSEnumAttributeAggregation.ValueCountPair(cvpObject.get("value").getAsString(), cvpObject.get("count").getAsInt());
            countValues.add(countValuePair);
        }
        return countValues;
    }

    private static CICSDateAttributeAggregation parseDateAggregation(ICICSAttribute<?> cicsAttribute, JsonObject attributeValues) {
        return new CICSDateAttributeAggregation(CICSObjectAggregateRecordParser.stringValue(attributeValues, "min"), CICSObjectAggregateRecordParser.stringValue(attributeValues, "max"), CICSObjectAggregateRecordParser.stringValue(attributeValues, "average"), CICSObjectAggregateRecordParser.mandatoryIntValue(attributeValues, "distinctValues"), CICSObjectAggregateRecordParser.mandatoryIntValue(attributeValues, "unsupported"), CICSObjectAggregateRecordParser.mandatoryIntValue(attributeValues, "unspecified"));
    }

    private static <T> Optional<T> value(JsonObject attributeValues, String key, Function<JsonElement, T> getter) {
        JsonElement jsonElement = attributeValues.get(key);
        return CICSObjectAggregateRecordParser.isNull(jsonElement) ? Optional.empty() : Optional.ofNullable(getter.apply(jsonElement));
    }

    private static <T> T mandatory(Optional<T> value, String name) {
        return value.orElseThrow(() -> new GraphQLParseException("Aggregation was missing a value for mandatory field: " + name));
    }

    private static Optional<Long> longValue(JsonObject attributeValues, String key) {
        return CICSObjectAggregateRecordParser.value(attributeValues, key, JsonElement::getAsLong);
    }

    private static Optional<Double> doubleValue(JsonObject attributeValues, String key) {
        return CICSObjectAggregateRecordParser.value(attributeValues, key, JsonElement::getAsDouble);
    }

    private static Optional<Integer> intValue(JsonObject attributeValues, String key) {
        return CICSObjectAggregateRecordParser.value(attributeValues, key, JsonElement::getAsInt);
    }

    private static int mandatoryIntValue(JsonObject attributeValues, String key) {
        return CICSObjectAggregateRecordParser.mandatory(CICSObjectAggregateRecordParser.intValue(attributeValues, key), key);
    }

    private static Optional<String> stringValue(JsonObject attributeValues, String key) {
        return CICSObjectAggregateRecordParser.value(attributeValues, key, JsonElement::getAsString);
    }
}

