/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.sm.comm.sm.internal.GraphQLFilterNode;
import com.ibm.cics.sm.comm.sm.internal.GraphQLFilterOperator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

class GraphQLAttributeFilter<T>
implements GraphQLFilterNode {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final String attribute;
    private final T value;
    private final GraphQLFilterOperator operator;
    public static final String NORMALIZED_DATE_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static ThreadLocal<DateFormat> threadLocalDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat(GraphQLAttributeFilter.NORMALIZED_DATE_FORMAT_STRING);
        }
    };

    public GraphQLAttributeFilter(String attribute, T value) {
        this(attribute, value, null);
    }

    public GraphQLAttributeFilter(String attribute, T value, GraphQLFilterOperator operator) {
        if (attribute == null || attribute.isEmpty()) {
            throw new IllegalArgumentException("Attribute must not be null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value must not be null");
        }
        this.attribute = attribute;
        this.value = value;
        this.operator = operator;
    }

    public void renderValue(StringBuilder sb) {
        if (this.value instanceof Number) {
            sb.append(this.value);
        } else if (this.value instanceof Date) {
            sb.append("\"").append(threadLocalDateFormat.get().format(this.value)).append("\"");
        } else {
            sb.append("\"").append(this.value).append("\"");
        }
    }

    @Override
    public void render(StringBuilder sb) {
        sb.append(this.attribute).append(":{");
        sb.append("value:");
        this.renderValue(sb);
        if (this.operator != null) {
            sb.append(" operator:").append(this.operator);
        }
        sb.append("}");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attribute == null ? 0 : this.attribute.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphQLAttributeFilter other = (GraphQLAttributeFilter)obj;
        if (this.attribute == null ? other.attribute != null : !this.attribute.equals(other.attribute)) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

