/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSDefinitionType;
import com.ibm.cics.model.ICICSEnum;
import com.ibm.cics.model.ICICSLongAttributeHint;
import com.ibm.cics.model.ICICSResourceType;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.ICPSMDefinitionType;
import com.ibm.cics.model.ICPSMManagerType;
import com.ibm.cics.model.IFilterVisitor;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.sm.internal.GraphQLArgument;
import com.ibm.cics.sm.comm.sm.internal.GraphQLAttributeFilter;
import com.ibm.cics.sm.comm.sm.internal.GraphQLFilter;
import com.ibm.cics.sm.comm.sm.internal.GraphQLFilterCompositeOperatorNode;
import com.ibm.cics.sm.comm.sm.internal.GraphQLFilterNode;
import com.ibm.cics.sm.comm.sm.internal.GraphQLFilterOperator;
import com.ibm.cics.sm.comm.sm.internal.GraphQLQueryNode;
import com.ibm.cics.sm.comm.sm.internal.SMCPSMConnection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.Collectors;

public class GraphQLRequestHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2017 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String DATA = "data";
    static final String ERRORS = "errors";
    static final String MESSAGE = "message";
    static final String ERROR_TYPE = "errorType";
    static final String VALIDATION_ERROR = "ValidationError";
    static final String VALUE = "value";
    static final String VALUES = "values";
    static final String DISTINCT_VALUES = "distinctValues";
    static final String MIN = "min";
    static final String MAX = "max";
    static final String AVERAGE = "average";
    static final String SUM = "sum";
    static final String DIFFERENCE = "difference";
    static final String COUNT = "count";
    static final String CSD = "csd";
    static final String DREP = "drep";
    static final String UNSUPPORTED = "unsupported";
    static final String UNSPECIFIED = "unspecified";
    public static final List<GraphQLQueryNode> STRING_AGGREGAION_FRAGMENT = GraphQLRequestHelper.toFieldList("value", "distinctValues", "unsupported");
    public static final List<GraphQLQueryNode> DATE_AGGREGATION_FRAGMENT = GraphQLRequestHelper.toFieldList("min", "max", "average", "distinctValues", "unspecified", "unsupported");
    public static final List<GraphQLQueryNode> ENUM_AGGREGATION_FRAGMENT = Arrays.asList(new GraphQLQueryNode("values", null, GraphQLRequestHelper.toFieldList("value", "count")), new GraphQLQueryNode("unspecified", null, null), new GraphQLQueryNode("unsupported", null, null));
    private static List<String> NUMERIC_FIELD_NAMES = Arrays.asList("min", "max", "average", "sum", "difference", "distinctValues", "unspecified", "unsupported");
    static final List<GraphQLQueryNode> NUMERIC_AGGREGATION_FRAGMENT = GraphQLRequestHelper.toFieldList(NUMERIC_FIELD_NAMES);
    public static final String AGGREGATE_RECORD = "aggregateRecord";
    public static final String GROUP_BY = "groupBy";
    public static final String REGION = "region";
    public static final String REGION_GROUP = "regionGroup";
    public static final String CICSPLEX = "cicsplex";
    public static final String ATTRIBUTE = "attribute";
    public static final String FILTER = "filter";
    public static final String NAME = "name";
    public static final String CICS_DEFINITIONS = "cicsDefinitions";
    public static final String CICS_RESOURCES = "cicsResources";
    public static final String CPSM_DEFINITIONS = "cpsmDefinitions";
    public static final String CPSM_MANAGERS = "cpsmManagers";

    private static List<GraphQLQueryNode> createNumericAggregationFragmentWithMetaValue(String metaValueName) {
        ArrayList<String> fieldNames = new ArrayList<String>(NUMERIC_FIELD_NAMES);
        fieldNames.add(metaValueName);
        return GraphQLRequestHelper.toFieldList(fieldNames);
    }

    static String createAggregateRecordQueryString(ICICSType<?> type, IContext context, List<ICICSAttribute<?>> groupByAttributes, List<ICICSAttribute<?>> requestedAttributes, FilterExpression filterExpression) {
        return GraphQLRequestHelper.createAggregateRecordQuery(type, context, groupByAttributes, requestedAttributes, filterExpression).render();
    }

    static String createAggregateRecordQueryStringNoFilter(ICICSType<?> type, IContext context, List<ICICSAttribute<?>> groupByAttributes, List<ICICSAttribute<?>> requestedAttributes) {
        return GraphQLRequestHelper.createAggregateRecordQuery(type, context, groupByAttributes, requestedAttributes, null).render();
    }

    static GraphQLQueryNode createAggregateRecordQuery(ICICSType<?> type, IContext context, List<ICICSAttribute<?>> groupByAttributes, List<ICICSAttribute<?>> requestedAttributes, FilterExpression filterExpression) {
        List<GraphQLQueryNode> cicsplexNodes;
        boolean isCPSMDefinition = type instanceof ICPSMDefinitionType;
        boolean isCPSMManager = type instanceof ICPSMManagerType;
        boolean useScopedContext = isCPSMDefinition || isCPSMManager ? false : SMCPSMConnection.isScopedContext(context);
        List<GraphQLQueryNode> aggregateRecordRequestedAttributes = requestedAttributes.stream().map(GraphQLRequestHelper::createAggregationAttribute).map(GraphQLQueryNode.Builder::build).collect(Collectors.toList());
        GraphQLQueryNode.Builder query = GraphQLQueryNode.newNode(AGGREGATE_RECORD).fields(aggregateRecordRequestedAttributes);
        int i = groupByAttributes.size() - 1;
        while (i >= 0) {
            query = GraphQLQueryNode.newNode(GROUP_BY).argument(new GraphQLArgument(ATTRIBUTE, groupByAttributes.get(i).getPropertyId())).field(GraphQLQueryNode.newNode(COUNT)).field(query);
            --i;
        }
        query = GraphQLQueryNode.newNode(type.getResourceTableName().toLowerCase()).field(GraphQLQueryNode.newNode(COUNT)).field(query);
        if (filterExpression != null && filterExpression != FilterExpression.NULL) {
            query = query.argument(new GraphQLArgument(FILTER, GraphQLRequestHelper.graphQLFilterFromExpression(filterExpression)));
        }
        if (useScopedContext) {
            cicsplexNodes = type instanceof ICICSDefinitionType ? Collections.singletonList(GraphQLRequestHelper.createRegionQuery(GraphQLQueryNode.newNode(CSD).field(GraphQLQueryNode.newNode(CICS_DEFINITIONS).field(query)), (IScopedContext)context)) : GraphQLRequestHelper.createScopedContextQuery(GraphQLQueryNode.newNode(CICS_RESOURCES).field(query), (IScopedContext)context);
        } else if (type instanceof ICICSResourceType) {
            cicsplexNodes = Collections.singletonList(GraphQLQueryNode.newNode(CICS_RESOURCES).field(query).build());
        } else if (type instanceof ICICSDefinitionType) {
            cicsplexNodes = Collections.singletonList(GraphQLQueryNode.newNode(DREP).field(GraphQLQueryNode.newNode(CICS_DEFINITIONS).field(query)).build());
        } else if (isCPSMDefinition) {
            cicsplexNodes = Collections.singletonList(GraphQLQueryNode.newNode(DREP).field(GraphQLQueryNode.newNode(CPSM_DEFINITIONS).field(query)).build());
        } else if (isCPSMManager) {
            cicsplexNodes = Collections.singletonList(GraphQLQueryNode.newNode(CPSM_MANAGERS).field(query).build());
        } else {
            throw new IllegalArgumentException("Unrecognized cics type: " + type);
        }
        return GraphQLQueryNode.newQuery().field(GraphQLQueryNode.newNode(CICSPLEX).argument(new GraphQLArgument(NAME, context.getContext())).fields(cicsplexNodes)).build();
    }

    private static List<GraphQLQueryNode> createScopedContextQuery(GraphQLQueryNode.Builder subQuery, IScopedContext scopedContext) {
        switch (scopedContext.getScopeType()) {
            case REGION: {
                return Collections.singletonList(GraphQLRequestHelper.createRegionQuery(subQuery, scopedContext));
            }
            case GROUP: {
                return Collections.singletonList(GraphQLRequestHelper.createRegionGroupQuery(subQuery, scopedContext));
            }
            case UNKNOWN: {
                return Arrays.asList(GraphQLRequestHelper.createRegionQuery(subQuery, scopedContext), GraphQLRequestHelper.createRegionGroupQuery(subQuery, scopedContext));
            }
        }
        throw new RuntimeException("Unknown scope type");
    }

    private static GraphQLQueryNode createRegionGroupQuery(GraphQLQueryNode.Builder subQuery, IScopedContext scopedContext) {
        return GraphQLQueryNode.newNode(REGION_GROUP).argument(new GraphQLArgument(NAME, scopedContext.getScope())).field(subQuery).build();
    }

    private static GraphQLQueryNode createRegionQuery(GraphQLQueryNode.Builder subQuery, IScopedContext scopedContext) {
        return GraphQLQueryNode.newNode(REGION).argument(new GraphQLArgument(NAME, scopedContext.getScope())).field(subQuery).build();
    }

    public static GraphQLFilter graphQLFilterFromExpression(FilterExpression filterExpression) {
        if (filterExpression == null || filterExpression == FilterExpression.NULL) {
            return null;
        }
        GraphQLFilterExpressionVisitor visitor = new GraphQLFilterExpressionVisitor();
        filterExpression.accept((IFilterVisitor)visitor);
        return visitor.getGraphQLFilter();
    }

    private static GraphQLQueryNode.Builder createAggregationAttribute(ICICSAttribute<?> attribute) {
        GraphQLQueryNode.Builder aggregateRecordAttributeNode = GraphQLQueryNode.newNode(attribute.getPropertyId());
        if (attribute.getType().equals(String.class)) {
            aggregateRecordAttributeNode.fields(STRING_AGGREGAION_FRAGMENT);
        } else if (attribute.getType().equals(Long.class)) {
            aggregateRecordAttributeNode.fields(GraphQLRequestHelper.getMetaValue(attribute).map(mV -> GraphQLRequestHelper.createNumericAggregationFragmentWithMetaValue(ICICSAttributeConstants.NA_CODE == mV.getValue() ? "na" : (String)mV.getKey())).orElse(NUMERIC_AGGREGATION_FRAGMENT));
        } else if (attribute.getType().equals(Date.class)) {
            aggregateRecordAttributeNode.fields(DATE_AGGREGATION_FRAGMENT);
        } else if (ICICSEnum.class.isAssignableFrom(attribute.getType())) {
            aggregateRecordAttributeNode.fields(ENUM_AGGREGATION_FRAGMENT);
        }
        return aggregateRecordAttributeNode;
    }

    public static Optional<Map.Entry<String, Long>> getMetaValue(ICICSAttribute<Long> attribute) {
        Map<String, Long> specialValues;
        ICICSLongAttributeHint hint = (ICICSLongAttributeHint)attribute.getHint(ICICSLongAttributeHint.class);
        if (hint != null && hint.hasSpecialValues() && (specialValues = hint.getSpecialValuesWithoutExtraValues()).size() > 0) {
            if ((specialValues = specialValues.entrySet().stream().filter(e -> e.getValue() != ICICSAttributeConstants.UNSPECIFIED_LONG).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).size() == 0) {
                return Optional.empty();
            }
            if (specialValues.size() == 1) {
                return Optional.of(specialValues.entrySet().iterator().next()).map(e -> new AbstractMap.SimpleImmutableEntry<String, Long>(((String)e.getKey()).toLowerCase(Locale.ROOT), (Long)e.getValue()));
            }
            throw new RuntimeException("Attribute with multiple special values found: " + attribute.getCicsName());
        }
        return Optional.empty();
    }

    static String createIntrospectionQuery() {
        GraphQLQueryNode introspectionQuery = GraphQLQueryNode.newQuery().field(GraphQLQueryNode.newNode("__schema").field(GraphQLQueryNode.newNode("types").field(GraphQLQueryNode.newNode(NAME)).field(GraphQLQueryNode.newNode("fields").field(GraphQLQueryNode.newNode(NAME))))).build();
        return introspectionQuery.render();
    }

    static List<GraphQLQueryNode> toFieldList(String ... fieldNames) {
        return GraphQLRequestHelper.toFieldList(Arrays.asList(fieldNames));
    }

    private static List<GraphQLQueryNode> toFieldList(List<String> fieldNames) {
        return fieldNames.stream().map(GraphQLRequestHelper::simpleField).collect(Collectors.toList());
    }

    static GraphQLQueryNode simpleField(String fieldName) {
        return GraphQLQueryNode.newNode(fieldName).build();
    }

    private static class GraphQLFilterExpressionVisitor
    implements IFilterVisitor {
        Stack<GraphQLFilterNode> nodeStack = new Stack();

        private GraphQLFilterExpressionVisitor() {
        }

        public void or() {
            GraphQLFilterNode node1 = this.nodeStack.pop();
            GraphQLFilterNode node2 = this.nodeStack.pop();
            GraphQLFilterCompositeOperatorNode.Builder outputNode = new GraphQLFilterCompositeOperatorNode.Builder("_or");
            if (GraphQLFilterExpressionVisitor.isOrNode(node2)) {
                outputNode.children(((GraphQLFilterCompositeOperatorNode)node2).getFilterNodes());
            } else {
                outputNode.child(node2);
            }
            if (GraphQLFilterExpressionVisitor.isOrNode(node1)) {
                outputNode.children(((GraphQLFilterCompositeOperatorNode)node1).getFilterNodes());
            } else {
                outputNode.child(node1);
            }
            this.nodeStack.push(outputNode.build());
        }

        public void and() {
            GraphQLFilterNode node1 = this.nodeStack.pop();
            GraphQLFilterNode node2 = this.nodeStack.pop();
            GraphQLFilterCompositeOperatorNode.Builder outputNode = new GraphQLFilterCompositeOperatorNode.Builder("_and");
            if (GraphQLFilterExpressionVisitor.isAndNode(node2)) {
                outputNode.children(((GraphQLFilterCompositeOperatorNode)node2).getFilterNodes());
            } else {
                outputNode.child(node2);
            }
            if (GraphQLFilterExpressionVisitor.isAndNode(node1)) {
                outputNode.children(((GraphQLFilterCompositeOperatorNode)node1).getFilterNodes());
            } else {
                outputNode.child(node1);
            }
            this.nodeStack.push(outputNode.build());
        }

        public void not() {
            throw new UnsupportedOperationException();
        }

        public <T> void eq(ICICSAttribute<T> attribute, T value) {
            this.nodeStack.push(new GraphQLAttributeFilter<T>(attribute.getPropertyId(), value));
        }

        public <T> void is(ICICSAttribute<T> attribute, T value) {
            this.nodeStack.push(new GraphQLAttributeFilter<T>(attribute.getPropertyId(), value));
        }

        public <T> void le(ICICSAttribute<T> attribute, T value) {
            this.nodeStack.push(new GraphQLAttributeFilter<T>(attribute.getPropertyId(), value, GraphQLFilterOperator.LE));
        }

        public <T> void lt(ICICSAttribute<T> attribute, T value) {
            this.nodeStack.push(new GraphQLAttributeFilter<T>(attribute.getPropertyId(), value, GraphQLFilterOperator.LT));
        }

        public <T> void ge(ICICSAttribute<T> attribute, T value) {
            this.nodeStack.push(new GraphQLAttributeFilter<T>(attribute.getPropertyId(), value, GraphQLFilterOperator.GE));
        }

        public <T> void gt(ICICSAttribute<T> attribute, T value) {
            this.nodeStack.push(new GraphQLAttributeFilter<T>(attribute.getPropertyId(), value, GraphQLFilterOperator.GT));
        }

        public <T> void ne(ICICSAttribute<T> attribute, T value) {
            this.nodeStack.push(new GraphQLAttributeFilter<T>(attribute.getPropertyId(), value, GraphQLFilterOperator.NE));
        }

        public GraphQLFilter getGraphQLFilter() {
            return new GraphQLFilter(this.nodeStack.peek());
        }

        public static boolean isAndNode(GraphQLFilterNode node) {
            return node instanceof GraphQLFilterCompositeOperatorNode && ((GraphQLFilterCompositeOperatorNode)node).getName().equals("_and");
        }

        public static boolean isOrNode(GraphQLFilterNode node) {
            return node instanceof GraphQLFilterCompositeOperatorNode && ((GraphQLFilterCompositeOperatorNode)node).getName().equals("_or");
        }
    }
}

