/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.sm.comm.CreateException;
import com.ibm.cics.sm.comm.ErrorCodes;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IResourceErrorCode;
import com.ibm.cics.sm.comm.InstallError;
import com.ibm.cics.sm.comm.InstallException;
import com.ibm.cics.sm.comm.SMUpdateException;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.sm.SMConnectionException;
import com.ibm.cics.sm.comm.sm.SMResponse;
import com.ibm.cics.sm.comm.sm.internal.CMCI41NormalizerFactory;
import com.ibm.cics.sm.comm.sm.internal.CMCI42NormalizerFactory;
import com.ibm.cics.sm.comm.sm.internal.DebugInputStream;
import com.ibm.cics.sm.comm.sm.internal.INormalizerFactory;
import com.ibm.cics.sm.comm.sm.internal.SMRecord;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class SMResponseHandler
extends DefaultHandler {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2015 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static INormalizerFactory cmci41NormalizerFactory = new CMCI41NormalizerFactory();
    private static INormalizerFactory cmci42NormalizerFactory = new CMCI42NormalizerFactory();
    public static final String ACTION_NONE = "";
    public static final String ACTION_CREATE = "CREATE";
    public static final String ACTION_INSTALL = "INSTALL";
    public static final String ACTION_UPDATE = "UPDATE";
    public static final String TAG_RESULT_SUMMARY = "resultsummary";
    public static final String ATT_CACHE_TOKEN = "cachetoken";
    public static final String ATT_FUNCTION = "api_function";
    public static final String ATT_RESPONSE = "api_response1";
    public static final String ATT_REASON = "api_response2";
    public static final String ATT_RECORD_COUNT = "recordcount";
    public static final String ATT_SUCCESS_COUNT = "successcount";
    public static final String TAG_FEEDBACK = "feedback";
    public static final String ATT_ERROR_CODE = "errorcode";
    public static final String ATT_RESP = "resp";
    public static final String ATT_RESP1_NAME = "resp_alt";
    public static final String ATT_RESP2 = "resp2";
    public static final String ATT_ACTION = "action";
    public static final String ATT_EIB_FUNCTION = "eibfn";
    public static final String ATT_EIB_FUNCTION_NAME = "eibfn_alt";
    public static final String ATT_ATTRIBUTE = "attribute";
    public static final String TAG_INSTALL_ERROR = "installerror";
    public static final String ATT_REGION_NAME = "eyu_cicsname";
    private static final String TAG_RESPONSE = "response";
    private static final String ATT_CONNECT_VERSION = "connect_version";
    private int connectVersion;
    private final String resourceType;
    private final String modelName;
    private IContext context;
    private String cacheToken;
    private int response;
    private int reason;
    private int recordTotal;
    private int displayedRecordCount = 0;
    private int successCount = -1;
    private IResourceErrorCode errorCode;
    private int resp1;
    private String resp1Name;
    private int resp2;
    private String action = "";
    private String eibFunction;
    private String eibFunctionName;
    private List<String> attributeNames = new ArrayList<String>();
    private List<InstallError> installErrors = new ArrayList<InstallError>();
    private SMRecord[] records;
    private int recordIndex;
    private SMResponse smResponse;
    private URL url;
    private DebugInputStream debugInputStream;
    private boolean formatError = false;
    private Random random = new Random();
    private static final Debug debug = new Debug(SMResponseHandler.class);

    public SMResponseHandler(String resourceType, String modelName, IContext context, InputStream inputStream, URL url) {
        this.resourceType = resourceType;
        this.context = context;
        this.modelName = modelName;
        this.url = url;
        this.debugInputStream = new DebugInputStream(inputStream);
    }

    public InputStream getDebugInputStream(InputStream inputStream) {
        this.debugInputStream = new DebugInputStream(inputStream);
        return this.debugInputStream;
    }

    public InputStream getInputStream() {
        return this.debugInputStream;
    }

    public SMResponse getResponse() throws SystemManagerConnectionException {
        if (this.smResponse == null) {
            if (this.action.equals(ACTION_CREATE)) {
                throw new CreateException(this.resourceType, this.response, this.reason, this.resp1Name, this.resp2, this.errorCode, this.attributeNames, this.eibFunctionName);
            }
            if (this.action.equals(ACTION_INSTALL)) {
                String attribute = this.attributeNames.isEmpty() ? ACTION_NONE : this.attributeNames.get(0);
                throw new InstallException(this.action, this.response, this.reason, this.errorCode, attribute, this.installErrors, this.eibFunctionName);
            }
            if (this.action.equals(ACTION_UPDATE)) {
                SMUpdateException updateException = new SMUpdateException(this.url, this.resourceType, null, this.response, this.reason, this.resp1Name, this.resp2, this.eibFunctionName);
                for (String attributeName : this.attributeNames) {
                    SMUpdateException.Error error = updateException.createError();
                    error.addAttributeName(attributeName, this.resourceType);
                    error.setServerResponse(String.valueOf(this.errorCode));
                }
                throw updateException;
            }
            if (this.attributeNames.isEmpty()) {
                throw new SMConnectionException(this.resourceType, this.url, this.response, this.reason, this.eibFunctionName, this.resp1, this.resp1Name, this.resp2);
            }
            throw new SMConnectionException(this.resourceType, this.response, this.reason, this.eibFunctionName, this.resp1, this.resp1Name, this.resp2, this.errorCode, this.attributeNames);
        }
        if (this.formatError) {
            throw new SMConnectionException("Format error encountered processing data");
        }
        return this.smResponse;
    }

    @Override
    public void startElement(String uri, String localName, String name, final Attributes attributes) throws SAXException {
        if (name.equals(TAG_RESPONSE)) {
            String attConnectVersion = attributes.getValue(ATT_CONNECT_VERSION);
            if (attConnectVersion.startsWith("V")) {
                attConnectVersion = attConnectVersion.substring(1);
            }
            this.connectVersion = Integer.valueOf(attConnectVersion);
        } else if (name.equals(TAG_RESULT_SUMMARY)) {
            String successCountValue;
            this.response = Integer.valueOf(attributes.getValue(ATT_RESPONSE));
            this.reason = Integer.valueOf(attributes.getValue(ATT_REASON));
            String recordCountValue = attributes.getValue("displayed_recordcount");
            if (recordCountValue != null) {
                this.displayedRecordCount = Integer.valueOf(attributes.getValue("displayed_recordcount"));
                this.records = new SMRecord[this.displayedRecordCount];
            }
            if ((successCountValue = attributes.getValue(ATT_SUCCESS_COUNT)) != null) {
                this.successCount = Integer.valueOf(successCountValue);
            }
            this.recordTotal = Integer.valueOf(attributes.getValue(ATT_RECORD_COUNT));
            this.checkResponseNOTPERMIT();
            this.cacheToken = attributes.getValue(ATT_CACHE_TOKEN);
            if (this.cacheToken == null) {
                this.cacheToken = String.valueOf(this.random.nextInt());
                debug.event("startElement", this.cacheToken);
            }
            debug.event("startElement", new Object[]{name, this.response, this.reason, this.displayedRecordCount, this.recordTotal, this.successCount, this.records});
        } else if (name.equals(TAG_FEEDBACK)) {
            Iterable<String> iterableAttributes = new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        private int index = 0;

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String next() {
                            return attributes.getQName(this.index++);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.index < attributes.getLength();
                        }
                    };
                }
            };
            for (String attributeName : iterableAttributes) {
                String attibuteValue = attributes.getValue(attributeName);
                if (attributeName.equals(ATT_ERROR_CODE)) {
                    this.errorCode = ErrorCodes.findErrorCodeByNumber((String)this.resourceType, (int)Integer.valueOf(attibuteValue));
                    continue;
                }
                if (attributeName.equals(ATT_RESP)) {
                    this.resp1 = Integer.valueOf(attibuteValue);
                    continue;
                }
                if (attributeName.equals(ATT_RESP1_NAME)) {
                    this.resp1Name = attibuteValue;
                    continue;
                }
                if (attributeName.equals(ATT_RESP2)) {
                    this.resp2 = Integer.valueOf(attibuteValue);
                    continue;
                }
                if (attributeName.equals(ATT_ACTION)) {
                    this.action = attibuteValue;
                    continue;
                }
                if (attributeName.startsWith(ATT_ATTRIBUTE)) {
                    this.attributeNames.add(attibuteValue);
                    continue;
                }
                if (attributeName.equals(ATT_EIB_FUNCTION)) {
                    this.eibFunction = attibuteValue;
                    continue;
                }
                if (!attributeName.equals(ATT_EIB_FUNCTION_NAME)) continue;
                this.eibFunctionName = attibuteValue;
            }
            debug.event("startElement", new Object[]{name, this.errorCode, this.resp1, this.resp2, this.action, this.eibFunction});
        } else if (name.equals(TAG_INSTALL_ERROR)) {
            Iterable<String> iterableAttributes = new Iterable<String>(){

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        private int index = 0;

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        @Override
                        public String next() {
                            return attributes.getQName(this.index++);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.index < attributes.getLength();
                        }
                    };
                }
            };
            String regionName = null;
            String installFunctionName = null;
            int errorCode = 0;
            String resp1 = null;
            int resp2 = 0;
            for (String attributeName : iterableAttributes) {
                String attibuteValue = attributes.getValue(attributeName);
                if (attributeName.equals(ATT_REGION_NAME)) {
                    regionName = attibuteValue;
                    continue;
                }
                if (attributeName.equals(ATT_ERROR_CODE)) {
                    errorCode = Integer.valueOf(attibuteValue);
                    continue;
                }
                if (attributeName.equals(ATT_RESP1_NAME)) {
                    resp1 = attibuteValue;
                    continue;
                }
                if (attributeName.equals(ATT_RESP2)) {
                    resp2 = Integer.valueOf(attibuteValue);
                    continue;
                }
                if (!attributeName.equals(ATT_EIB_FUNCTION_NAME)) continue;
                installFunctionName = attibuteValue;
            }
            InstallError installError = installFunctionName != null ? new InstallError(regionName, installFunctionName, resp1, resp2) : new InstallError(regionName, errorCode);
            this.installErrors.add(installError);
            debug.event("startElement", (Object)installError);
        } else if (name.equalsIgnoreCase(this.modelName)) {
            SMRecord record = new SMRecord(this.getNormalizerFactory(), this.resourceType, attributes, this.context);
            debug.event("startElement", (Object)name, (Object)this.recordIndex, (Object)record);
            this.records[this.recordIndex++] = record;
        } else if (name.equals("formaterror")) {
            debug.event("startElement", name);
            this.traceElementNoChildren(name, attributes);
            this.records[this.recordIndex++] = null;
            this.formatError = true;
        } else {
            debug.event("startElement", name);
        }
    }

    private void checkResponseNOTPERMIT() {
        if (this.response == 1031 && this.reason == 1345 && this.displayedRecordCount > 0) {
            debug.warning("checkResponseNOTPERMIT", (Object)("'NOTPERMIT, USRID' partial response - " + this.displayedRecordCount + " results returned"));
            this.response = 1024;
            this.reason = 0;
        }
    }

    private INormalizerFactory getNormalizerFactory() {
        return this.connectVersion != 0 && this.connectVersion >= 420 ? cmci42NormalizerFactory : cmci41NormalizerFactory;
    }

    private void traceElementNoChildren(String name, Attributes attributes) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('<');
        stringBuilder.append(name);
        stringBuilder.append(' ');
        int i = 0;
        while (i < attributes.getLength()) {
            stringBuilder.append(attributes.getQName(i));
            stringBuilder.append('=');
            stringBuilder.append('\"');
            stringBuilder.append(attributes.getValue(i));
            stringBuilder.append('\"');
            stringBuilder.append(' ');
            ++i;
        }
        stringBuilder.append('/');
        stringBuilder.append('>');
        debug.event("traceElementNoChildren", stringBuilder.toString());
    }

    @Override
    public void endDocument() throws SAXException {
        debug.enter("endDocument", (Object)this);
        if (this.isOK(this.response)) {
            this.smResponse = this.records == null ? SMResponse.summary(this.cacheToken, this.resourceType, this.recordTotal, this.context) : SMResponse.records(this.cacheToken, this.resourceType, Arrays.asList(this.records), this.context);
            debug.event("endDocument", (Object)this.smResponse);
        } else {
            debug.event("endDocument", (Object)this.debugInputStream);
        }
        debug.exit("endDocument");
    }

    protected boolean isOK(int response) {
        return response == 1024;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        debug.warning("error", (Object)e, (Object)this.debugInputStream.toString());
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        debug.warning("fatalError", (Object)e, (Object)this.debugInputStream.toString());
    }
}

