/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.sm.comm.ICICSActionNames;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.sm.internal.VSEConnectionBehaviour;

public class VSE61ConnectionBehaviour
extends VSEConnectionBehaviour
implements ICICSActionNames {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(VSE61ConnectionBehaviour.class);
    private static final String[] PROGRAM_UNSUPPORTED_ATTRIBUTES = new String[]{"CURRENTLOC", "FETCHCNT", "FETCHTIME", "NEWCOPYCNT", "REMOVECNT", "RPLID", "USEAGELSTAT"};
    protected static final char COMMA = ',';

    public VSE61ConnectionBehaviour() {
        this.vseUnsupportedAttributesByResource.put("PROGRAM", PROGRAM_UNSUPPORTED_ATTRIBUTES);
        this.setUpSupportedOperationsByResource();
        this.setUpSupportedDeleteResources();
    }

    protected void setUpSupportedDeleteResources() {
        this.vseSupportedDeleteResources.add("DOCTEMP");
        this.vseSupportedDeleteResources.add("TCPIPS");
        this.vseSupportedDeleteResources.add("LOCTRAN");
        this.vseSupportedDeleteResources.add("REMTRAN");
        this.vseSupportedDeleteResources.add("TRANCLAS");
        this.vseSupportedDeleteResources.add("PROGRAM");
        this.vseSupportedDeleteResources.add("LOCFILE");
        this.vseSupportedDeleteResources.add("REMFILE");
    }

    protected void setUpSupportedOperationsByResource() {
        this.vseSupportedActionsByResource.put("CICSRGN", new String[]{"DELETSHIPPED", "RESETTIME", "SECREBUILD", "SNAP", "SWITCH", "STATISTICS"});
        this.vseSupportedActionsByResource.put("TCPIPS", new String[]{"OPEN", "CLOSE", "IMMCLOSE"});
        this.vseSupportedActionsByResource.put("CONNECT", new String[]{"ACQUIRE", "RELEASE", "INSERVICE", "OUTSERVICE", "CANCEL", "FORCECANCEL", "PURGE", "FORCEPURGE"});
        this.vseSupportedActionsByResource.put("TERMNL", new String[]{"ACQUIRE", "RELEASE", "CANCEL", "INSERVICE", "OUTSERVICE", "PURGE", "FORCEPURGE"});
        String[] transactionActions = new String[]{"ENABLE", "DISABLE"};
        this.vseSupportedActionsByResource.put("LOCTRAN", transactionActions);
        this.vseSupportedActionsByResource.put("REMTRAN", transactionActions);
        this.vseSupportedActionsByResource.put("PROGRAM", new String[]{"NEWCOPY", "PHASEIN", "ENABLE", "DISABLE"});
        this.vseSupportedActionsByResource.put("TASK", new String[]{"PURGE", "FORCEPURGE"});
        String[] fileActions = new String[]{"OPEN", "CLOSE", "ENABLE", "DISABLE"};
        this.vseSupportedActionsByResource.put("LOCFILE", fileActions);
        this.vseSupportedActionsByResource.put("REMFILE", fileActions);
        this.vseSupportedActionsByResource.put("REQID", new String[]{"CANCEL"});
        String[] tdqActions = new String[]{"OPEN", "CLOSE", "ENABLE", "DISABLE"};
        this.vseSupportedActionsByResource.put("INTRATDQ", tdqActions);
        this.vseSupportedActionsByResource.put("EXTRATDQ", tdqActions);
    }

    @Override
    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        debug.enter("checkOperation", (Object)this, (Object)resourceType, (Object)context, (Object)operation);
        boolean supported = false;
        switch (operation.getOperationType()) {
            case GET: {
                supported = true;
                break;
            }
            case UPDATE: {
                supported = true;
                break;
            }
            case PERFORM: {
                supported = this.checkPerformOperation(resourceType, context, operation);
                break;
            }
            case DELETE: {
                supported = this.checkDeleteOperation(resourceType);
            }
        }
        debug.exit("checkOperation", (Object)supported);
        return supported;
    }

    @Override
    public String getActions(String resourceName, IContext context) {
        debug.enter("getActions", (Object)this);
        String actions = "read,update,perform,delete";
        debug.exit("getActions", (Object)actions);
        return actions;
    }
}

