/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.google.gson.JsonElement;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseRuntimeException;
import com.ibm.cics.sm.comm.sm.internal.graphql.ValueParser;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

class ArrayValueParser<T>
extends ValueParser<List<T>> {
    private Function<JsonElement, T> parser;

    private ArrayValueParser(Function<JsonElement, T> parser) {
        this.parser = parser;
    }

    private static <T> Function<JsonElement, Optional<T>> nullableParser(ValueParser<T> valueParser) {
        return e -> {
            try {
                return valueParser.parse((JsonElement)e);
            }
            catch (ValueParser.ValueParseException ex) {
                throw new NodeParseRuntimeException("Error parsing array member", ex);
            }
        };
    }

    public static <T> ArrayValueParser<T> nonNullValues(ValueParser<T> valueParser) {
        return new ArrayValueParser<Object>(ArrayValueParser.nullableParser(valueParser).andThen(o -> o.orElseThrow(() -> new NodeParseRuntimeException("Non null array value was null"))));
    }

    public static <T> ArrayValueParser<Optional<T>> nullableValues(ValueParser<T> valueParser) {
        return new ArrayValueParser<Optional<T>>(ArrayValueParser.nullableParser(valueParser));
    }

    @Override
    public List<T> parseValue(JsonElement je) throws ValueParser.ValueParseException {
        if (je.isJsonArray()) {
            return StreamSupport.stream(je.getAsJsonArray().spliterator(), false).map(this.parser::apply).collect(Collectors.toList());
        }
        throw new ValueParser.ValueParseException("property was not a json array");
    }
}

