/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.model.query.QueryNode;
import com.ibm.cics.sm.comm.sm.internal.graphql.DocumentAppender;
import com.ibm.cics.sm.comm.sm.internal.graphql.DocumentParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.ObjectContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.StringBuilderAppender;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class DocumentContext<NT, N extends Node<NT>> {
    private StringBuilderAppender contents = new StringBuilderAppender();
    private FragmentRegistry fragmentRegistry = new FragmentRegistry();
    private N node;

    public DocumentContext(N node) {
        this.node = node;
    }

    public DocumentParser<NT> query(String name, Consumer<? super N> query) {
        this.contents.append("query " + name);
        new ObjectContext(this.contents, this.fragmentRegistry, oc -> {
            ((Node)this.node).setObjectContext((ObjectContext)oc);
            query.accept((N)this.node);
        });
        return new DocumentParser(this.node);
    }

    public String buildDocument() {
        this.appendFragments(this.contents);
        return this.contents.toString();
    }

    private void appendFragments(DocumentAppender appender) {
        this.fragmentRegistry.fragments.forEach((id, fragment) -> this.appendFragment(appender, (String)id, (Fragment)fragment));
    }

    private <NTX, NX extends Node<NTX>> void appendFragment(DocumentAppender appender, String id, Fragment<NTX, NX> fragment) {
        appender.append("fragment " + id + " on " + fragment.node.getGraphQLTypeName());
        new ObjectContext(appender, this.fragmentRegistry, oc -> {
            fragment.node.setObjectContext((ObjectContext)oc);
            fragment.fragment.accept(fragment.node);
        });
    }

    public <NTX, Q extends QueryNode<Q>, NX extends Node<NTX>> FragmentReference<Q> registerFragment(String id, NX impl, Consumer<? super NX> fragment) {
        return this.fragmentRegistry.registerFragment(id, impl, fragment);
    }

    private static class Fragment<NTX, NX extends Node<NTX>> {
        private final Consumer<? super NX> fragment;
        private final NX node;

        public Fragment(Consumer<? super NX> fragment, NX impl) {
            this.fragment = fragment;
            this.node = impl;
        }
    }

    static class FragmentRegistry {
        private Map<String, Fragment<?, ?>> fragments = new LinkedHashMap();

        FragmentRegistry() {
        }

        public <NTX, Q extends QueryNode<Q>, NX extends Node<NTX>> FragmentReference<Q> registerFragment(String id, NX node, Consumer<? super NX> fragment) {
            if (this.fragments.containsKey(id)) {
                throw new IllegalArgumentException("A fragment with id '" + id + "' was already registered");
            }
            this.fragments.put(id, new Fragment(fragment, node));
            return new FragmentReference(id);
        }

        public <NTX, NX extends Node<NTX>> void applyFragment(String id, NX node) {
            Fragment<?, ?> fragment = this.fragments.get(id);
            if (fragment == null) {
                throw new IllegalArgumentException("Unknown fragment id: " + id);
            }
            ((Fragment)fragment).fragment.accept(node);
        }
    }
}

