/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.graphql;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArrayValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.FieldParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.LongValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseRuntimeException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.ObjectValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.StringValueParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.ValueParser;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DocumentParser<NT> {
    private final NodeParser<Optional<NT>> dataParser;
    private ObjectValueParser<GraphQLError.Location> locationParser = new ObjectValueParser<GraphQLError.Location>(new NodeParser<GraphQLError.Location>(){
        private NodeParser<Long> lineParser = NodeParser.nonNull(new FieldParser<Long>("line", new LongValueParser()));
        private NodeParser<Long> columnParser = NodeParser.nonNull(new FieldParser<Long>("column", new LongValueParser()));

        @Override
        public GraphQLError.Location parse(JsonObject o) throws NodeParseRuntimeException {
            return new GraphQLError.Location(this.lineParser.parse(o).intValue(), this.columnParser.parse(o).intValue());
        }
    });
    private ObjectValueParser<GraphQLError> errorParser = new ObjectValueParser<GraphQLError>(new NodeParser<GraphQLError>(){
        private NodeParser<String> messageParser = NodeParser.nonNull(new FieldParser<String>("message", new StringValueParser()));
        private NodeParser<Optional<List<GraphQLError.Location>>> locationsParser;
        {
            this.locationsParser = new FieldParser<List<GraphQLError.Location>>("locations", ArrayValueParser.nonNullValues(DocumentParser.this.locationParser));
        }

        @Override
        public GraphQLError parse(JsonObject o) throws NodeParseRuntimeException {
            return new GraphQLError(this.messageParser.parse(o), this.locationsParser.parse(o).orElse(Collections.emptyList()));
        }
    });
    private NodeParser<Optional<List<GraphQLError>>> errorsParser = o -> {
        if (o.has("errors")) {
            try {
                return ArrayValueParser.nonNullValues(this.errorParser).parse(o.get("errors"));
            }
            catch (ValueParser.ValueParseException e) {
                throw e.toNodeParseRuntimeException("errors");
            }
        }
        return Optional.empty();
    };

    public DocumentParser(NodeParser<NT> dataParser) {
        this.dataParser = o -> {
            if (o.has("data")) {
                try {
                    return new ObjectValueParser(dataParser).parse(o.get("data"));
                }
                catch (ValueParser.ValueParseException e) {
                    throw e.toNodeParseRuntimeException("data");
                }
            }
            return Optional.empty();
        };
    }

    public Result<NT> parse(JsonElement je) throws QueryFailureException {
        if (!je.isJsonObject()) {
            throw new QueryFailureException("root element was not an object");
        }
        JsonObject root = je.getAsJsonObject();
        return this.dataParser.parse(root).map(data -> new Result<Object>(data, this.errorsParser.parse(root).orElse(Collections.emptyList()))).orElseThrow(() -> new QueryFailureWithErrorsException((List)NodeParser.nonNull(this.errorsParser).parse(root)));
    }

    public static class GraphQLError {
        private final String message;
        private final List<Location> locations;

        public GraphQLError(String message) {
            this(message, Collections.emptyList());
        }

        public GraphQLError(String message, List<Location> locations) {
            this.message = message;
            this.locations = Collections.unmodifiableList(locations);
        }

        public String getMessage() {
            return this.message;
        }

        public List<Location> getLocations() {
            return this.locations;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.locations == null ? 0 : this.locations.hashCode());
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GraphQLError other = (GraphQLError)obj;
            if (this.locations == null ? other.locations != null : !this.locations.equals(other.locations)) {
                return false;
            }
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        public String toString() {
            return "GraphQLError [message=" + this.message + ", locations=" + this.locations + "]";
        }

        public static class Location {
            private final int line;
            private final int column;

            public Location(int line, int column) {
                this.line = line;
                this.column = column;
            }

            public int getLine() {
                return this.line;
            }

            public int getColumn() {
                return this.column;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + this.column;
                result = 31 * result + this.line;
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Location other = (Location)obj;
                if (this.column != other.column) {
                    return false;
                }
                return this.line == other.line;
            }

            public String toString() {
                return "Location [line=" + this.line + ", column=" + this.column + "]";
            }
        }
    }

    public static class QueryFailureException
    extends ConnectionException {
        public QueryFailureException(String message) {
            super(message);
        }

        public QueryFailureException(String message, Exception cause) {
            super(message, (Throwable)cause);
        }
    }

    public static class QueryFailureWithErrorsException
    extends QueryFailureException {
        private final List<GraphQLError> errors;

        public QueryFailureWithErrorsException(List<GraphQLError> errors) {
            super("Query failed with error responses");
            this.errors = errors;
        }

        public List<GraphQLError> getErrors() {
            return this.errors;
        }

        public String toString() {
            return "QueryFailureWithErrorsException [errors=" + this.errors + "]";
        }
    }

    public static class Result<T> {
        private final T result;
        private final List<GraphQLError> errors;

        public Result(T result, List<GraphQLError> errors) {
            this.result = result;
            this.errors = errors;
        }

        public T getResult() {
            return this.result;
        }

        public List<GraphQLError> getErrors() {
            return this.errors;
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }
    }
}

