/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.core.model.FEPINodeDefinitionType;
import com.ibm.cics.core.model.FEPIPoolDefinitionType;
import com.ibm.cics.core.model.FEPIPropertySetDefinitionType;
import com.ibm.cics.core.model.FEPITargetDefinitionType;
import com.ibm.cics.core.model.TableDescriptions;
import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeConstants;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSEnum;
import com.ibm.cics.model.ICICSLongAttributeHint;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IFromReferenceAttribute;
import com.ibm.cics.model.IToReferenceAttribute;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.query.CICSObjectQuery;
import com.ibm.cics.model.query.CICSObjectRecordsQuery;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseRuntimeException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.graphql.ObjectContext;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectQueryParser;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectRecordsQueryImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

class CICSObjectQueryImpl<Interface extends ICICSObject>
extends Node<CICSObjectQueryResult>
implements CICSObjectQuery<Interface> {
    private final ICICSType<Interface> type;
    private final Set<ICICSAttribute<?>> mandatoryAttributes;
    private Map<ICICSAttribute<?>, NodeParser<? extends AttributeValue<?>>> attributeValues = new LinkedHashMap();
    private Map<IToReferenceAttribute<?, ?, ?>, NodeParser<Optional<CICSObjectQueryResult>>> toReferences = new LinkedHashMap();
    private Map<IFromReferenceAttribute<?, ?, ?>, NodeParser<Optional<CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult>>> fromReferences = new LinkedHashMap();
    private List<NodeParser<Map<IToReferenceAttribute<?, ?, ?>, Optional<CICSObjectQueryResult>>>> unionReferences = new ArrayList();

    public CICSObjectQueryImpl(ICICSType<Interface> type) {
        this(type, Collections.emptyList());
    }

    CICSObjectQueryImpl(ICICSType<Interface> type, Collection<ICICSAttribute<?>> mandatoryAttributes) {
        super(CICSObjectQueryImpl.getGraphQLTypeName(type));
        this.type = type;
        this.mandatoryAttributes = new HashSet(mandatoryAttributes);
    }

    private static String getGraphQLTypeName(ICICSType<?> type) {
        return String.valueOf(type.getResourceTableName()) + "RecordType";
    }

    @Override
    public final CICSObjectQueryResult parse(JsonObject o) {
        this.type.getKeyAttributes().forEach(att -> {
            if (!this.attributeValues.containsKey(att)) {
                throw new NodeParseRuntimeException(String.valueOf(TableDescriptions.getTableDescription(this.type)) + " query was missing required key attribute " + att.getPropertyId());
            }
        });
        this.mandatoryAttributes.forEach(att -> {
            if (!this.attributeValues.containsKey(att)) {
                throw new NodeParseRuntimeException(String.valueOf(TableDescriptions.getTableDescription(this.type)) + " query was missing required mandatory attribute " + att.getPropertyId());
            }
        });
        AttributeValueMap avm = AttributeValueMap.fromList(this.attributeValues.entrySet().stream().map(e -> (AttributeValue)((NodeParser)e.getValue()).parse(o)).collect(Collectors.toList()));
        Map<IToReferenceAttribute<?, ?, ?>, CICSObjectQueryResult> toMap = CICSObjectQueryParser.parseOptionalMap(this.toReferences, o);
        this.unionReferences.stream().map(nP -> (Map)nP.parse(o)).flatMap(map -> map.entrySet().stream()).filter(entry -> ((Optional)entry.getValue()).isPresent()).forEach(entry -> {
            CICSObjectQueryResult cICSObjectQueryResult = toMap.put((IToReferenceAttribute)entry.getKey(), (CICSObjectQueryResult)((Optional)entry.getValue()).get());
        });
        return new CICSObjectQueryResult(avm, toMap, CICSObjectQueryParser.parseOptionalMap(this.fromReferences, o));
    }

    public CICSObjectQuery<Interface> fragment(FragmentReference<CICSObjectQuery<Interface>> fragment) {
        this.fragmentReference(fragment.getId());
        return this;
    }

    @Override
    public void setObjectContext(ObjectContext oc) {
        super.setObjectContext(oc);
    }

    private NodeParser<AttributeValue<Long>> longParser(ICICSAttribute<Long> attribute, String name) throws NodeParseRuntimeException {
        return this.createLongValueParser(attribute, name).andThen(o -> o.orElse(ICICSAttributeConstants.UNSPECIFIED_LONG)).andThen(v -> AttributeValue.av((ICICSAttribute)attribute, (Object)v));
    }

    private NodeParser<Optional<Long>> createLongValueParser(ICICSAttribute<Long> attribute, String name) {
        ICICSLongAttributeHint hint = (ICICSLongAttributeHint)attribute.getHint(ICICSLongAttributeHint.class);
        if (hint != null && hint.hasSpecialValues()) {
            Map<String, Long> specialValues = hint.getSpecialValuesWithoutExtraValues();
            if (specialValues.size() == 1 && specialValues.containsValue(ICICSAttributeConstants.NA_CODE)) {
                return this.createMetaValueParser(attribute, name, "na", ICICSAttributeConstants.NA_CODE);
            }
            if ((specialValues = this.filterUnspecified(specialValues)).size() == 1) {
                Map.Entry<String, Long> specialValue = specialValues.entrySet().iterator().next();
                return this.createMetaValueParser(attribute, name, specialValue.getKey(), specialValue.getValue());
            }
            if (specialValues.size() == 0) {
                return this.longField(name);
            }
            throw new RuntimeException("Schema doesn't support multiple meta-values for one attribute");
        }
        return this.longField(name);
    }

    private Map<String, Long> filterUnspecified(Map<String, Long> specialValues) {
        return specialValues.entrySet().stream().filter(e -> e.getValue() != ICICSAttributeConstants.UNSPECIFIED_LONG).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private NodeParser<Optional<Long>> createMetaValueParser(ICICSAttribute<Long> attribute, String name, String mnemonic, Long metaValue) {
        NumericBoxTypeNode numericNode = new NumericBoxTypeNode();
        mnemonic = mnemonic.toLowerCase(Locale.ROOT);
        MetaValueBoxTypeNode metaNode = new MetaValueBoxTypeNode(String.valueOf(mnemonic.substring(0, 1).toUpperCase(Locale.ROOT)) + mnemonic.substring(1) + "BoxType", mnemonic, metaValue);
        NodeParser<Optional<ObjectContext.UnionResult>> unionField = this.unionObjectField(name, Arrays.asList(new ObjectContext.NodeQueryTuple(numericNode, numericBox -> {
            NumericBoxTypeNode numericBoxTypeNode = numericBox.numericValue();
        }), new ObjectContext.NodeQueryTuple(metaNode, metaBox -> {
            MetaValueBoxTypeNode metaValueBoxTypeNode = metaBox.metaValue();
        })));
        return unionField.andThen(o -> o.map(unionResult -> unionResult.getResult(numericNode).orElseGet(() -> unionResult.getResult(metaNode).orElseThrow(() -> new NodeParseRuntimeException("Unknown union result type for numeric attribute (" + attribute.getCicsName() + ") with meta-values: " + unionResult)))));
    }

    public CICSObjectQuery<Interface> attribute(ICICSAttribute<?> attribute) {
        String name = CICSObjectQueryImpl.getAttributeFieldName(attribute);
        if (attribute == AbstractCICSDefinitionType.CSDGROUP && CICSObjectQueryImpl.isFEPI(this.type)) {
            this.attributeValues.put(attribute, jE -> AttributeValue.av((ICICSAttribute)attribute, (Object)""));
        } else if (attribute.getType() == String.class) {
            this.attributeValues.put(attribute, this.stringParser(attribute, name));
        } else if (attribute.getType() == Long.class) {
            this.attributeValues.put(attribute, this.longParser(attribute, name));
        } else if (attribute.getType() == Date.class) {
            this.attributeValues.put(attribute, this.dateParser(attribute, name));
        } else if (ICICSEnum.class.isAssignableFrom(attribute.getType())) {
            this.attributeValues.put(attribute, this.enumParser(attribute, name));
        } else {
            throw new RuntimeException("Unexpected attribute type: " + attribute);
        }
        return this;
    }

    private static <T extends ICICSDefinition> boolean isFEPI(ICICSType<?> type) {
        return type instanceof FEPITargetDefinitionType || type instanceof FEPINodeDefinitionType || type instanceof FEPIPoolDefinitionType || type instanceof FEPIPropertySetDefinitionType;
    }

    private NodeParser<AttributeValue<String>> stringParser(ICICSAttribute<String> attribute, String name) {
        return this.stringField(name).andThen(o -> o.orElse("")).andThen(v -> AttributeValue.av((ICICSAttribute)attribute, (Object)v));
    }

    private NodeParser<AttributeValue<Date>> dateParser(ICICSAttribute<Date> dateAttribute, String name) {
        return this.stringField(name).andThen(o -> o.map(s -> this.toDate(dateAttribute, (String)s)).orElse(ICICSAttributeConstants.UNSPECIFIED_DATE)).andThen(v -> AttributeValue.av((ICICSAttribute)dateAttribute, (Object)v));
    }

    private Date toDate(ICICSAttribute<Date> attribute, String stringValue) {
        try {
            return (Date)attribute.externalToInternal(stringValue);
        }
        catch (IllegalCICSAttributeException ex) {
            return (Date)attribute.getUnexpectedValue();
        }
    }

    private <T extends Enum<T>> NodeParser<AttributeValue<T>> enumParser(ICICSAttribute<T> attribute, String name) {
        return this.stringField(name).andThen(o -> o.map(stringValue -> (Enum)attribute.externalToInternal(stringValue)).orElseGet(() -> Enum.valueOf(attribute.getType(), "_UNSPECIFIED"))).andThen(v -> AttributeValue.av((ICICSAttribute)attribute, (Object)v));
    }

    public <FromInterface extends ICICSObject> CICSObjectQuery<Interface> from(IFromReferenceAttribute<Interface, FromInterface, ?> from, IToReferenceAttribute<FromInterface, Interface, ?> to, Consumer<CICSObjectRecordsQuery<FromInterface>> query) {
        this.fromReferences.put(from, this.objectField(CICSObjectQueryImpl.getFromFieldName(from), new CICSObjectRecordsQueryImpl(from.getFromType(), to.getAttributesUsedInReference()), query));
        return this;
    }

    public <ToInterface extends ICICSObject> CICSObjectQuery<Interface> to(IToReferenceAttribute<Interface, ToInterface, ?> to, Consumer<CICSObjectQuery<ToInterface>> query) {
        this.mandatoryAttributes.addAll(to.getAttributesUsedInReference());
        this.toReferences.put(to, this.objectField(CICSObjectQueryImpl.getToFieldName(to), new CICSObjectQueryImpl<Interface>(to.getToType()), query));
        return this;
    }

    public CICSObjectQuery<Interface> toUnion(String name, Consumer<CICSObjectQuery.UnionQuery<Interface>> query) {
        UnionQueryImpl union = new UnionQueryImpl(name);
        query.accept(union);
        this.unionReferences.add(union.createParser());
        return this;
    }

    private static String getAttributeNames(List<ICICSAttribute<?>> foreignKeyAttributes) {
        return foreignKeyAttributes.stream().map(IAttribute::getPropertyId).collect(Collectors.joining("_"));
    }

    static String getAttributeFieldName(ICICSAttribute<?> attribute) {
        return attribute.getPropertyId();
    }

    private static String getFromFieldName(IFromReferenceAttribute<?, ?, ?> fromAttribute) {
        return "from_" + fromAttribute.getFromType().getResourceTableName().toLowerCase(Locale.ROOT) + '_' + CICSObjectQueryImpl.getAttributeNames(fromAttribute.getAttributesUsedInReference());
    }

    private static String getToFieldName(IToReferenceAttribute<?, ?, ?> toAttribute) {
        return "to_" + CICSObjectQueryImpl.getAttributeNames(toAttribute.getAttributesUsedInReference());
    }

    static class CICSObjectQueryResult {
        final AttributeValueMap avm;
        final Map<IToReferenceAttribute<?, ?, ?>, CICSObjectQueryResult> to;
        final Map<IFromReferenceAttribute<?, ?, ?>, CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult> from;

        public CICSObjectQueryResult(AttributeValueMap avm, Map<IToReferenceAttribute<?, ?, ?>, CICSObjectQueryResult> to, Map<IFromReferenceAttribute<?, ?, ?>, CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult> from) {
            this.avm = avm;
            this.to = Collections.unmodifiableMap(to);
            this.from = Collections.unmodifiableMap(from);
        }
    }

    private static class MetaValueBoxTypeNode
    extends Node<Long> {
        private final Long metaValue;
        private final String fieldName;

        public MetaValueBoxTypeNode(String typeName, String fieldName, Long metaValue) {
            super(typeName);
            this.fieldName = fieldName;
            this.metaValue = metaValue;
        }

        @Override
        public Long parse(JsonObject o) throws NodeParseRuntimeException {
            return this.metaValue;
        }

        public MetaValueBoxTypeNode metaValue() {
            this.booleanField(this.fieldName);
            return this;
        }
    }

    private static class NumericBoxTypeNode
    extends Node<Long> {
        private NodeParser<Long> numericValue;

        public NumericBoxTypeNode() {
            super("NumericBoxType");
        }

        @Override
        public Long parse(JsonObject o) throws NodeParseRuntimeException {
            return this.numericValue.parse(o);
        }

        public NumericBoxTypeNode numericValue() {
            this.numericValue = NodeParser.nonNull(this.longField("numericValue"));
            return this;
        }
    }

    private class UnionQueryImpl
    implements CICSObjectQuery.UnionQuery<Interface> {
        private Map<IToReferenceAttribute<Interface, ? extends ICICSObject, ?>, Consumer<? extends CICSObjectQuery<? extends ICICSObject>>> unionQueries = new LinkedHashMap();
        private String name;

        public UnionQueryImpl(String name) {
            this.name = name;
        }

        public <ToInterface extends ICICSObject> CICSObjectQuery.UnionQuery<Interface> to(IToReferenceAttribute<Interface, ToInterface, ?> to, Consumer<CICSObjectQuery<ToInterface>> consumer) {
            this.unionQueries.put(to, consumer);
            return this;
        }

        private <ToInterface extends ICICSObject> CICSObjectQueryImpl<ToInterface> createNode(IToReferenceAttribute<Interface, ToInterface, ?> refAtt) {
            return new CICSObjectQueryImpl(refAtt.getToType());
        }

        public NodeParser<Map<IToReferenceAttribute<?, ?, ?>, Optional<CICSObjectQueryResult>>> createParser() {
            this.unionQueries.keySet().stream().map(IToReferenceAttribute::getAttributesUsedInReference).forEach(CICSObjectQueryImpl.this.mandatoryAttributes::addAll);
            final Map refToNode = this.unionQueries.keySet().stream().collect(Collectors.toMap(Function.identity(), this::createNode, (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new));
            List nodeQueries = refToNode.entrySet().stream().map(entry -> this.createNodeQuery((IToReferenceAttribute)entry.getKey(), (CICSObjectQueryImpl)entry.getValue())).collect(Collectors.toList());
            final NodeParser unionObjectField = CICSObjectQueryImpl.this.unionObjectField(this.name, nodeQueries);
            return new NodeParser<Map<IToReferenceAttribute<?, ?, ?>, Optional<CICSObjectQueryResult>>>(){

                @Override
                public Map<IToReferenceAttribute<?, ?, ?>, Optional<CICSObjectQueryResult>> parse(JsonObject o) {
                    Optional result = (Optional)unionObjectField.parse(o);
                    return refToNode.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> result.flatMap(r -> r.getResult((Node)entry.getValue()))));
                }
            };
        }

        private <X extends ICICSObject> ObjectContext.NodeQueryTuple<CICSObjectQueryResult, CICSObjectQueryImpl<X>> createNodeQuery(IToReferenceAttribute<?, ?, ?> att, CICSObjectQueryImpl<X> node) {
            Consumer<? extends CICSObjectQuery<? extends ICICSObject>> query = this.unionQueries.get(att);
            return new ObjectContext.NodeQueryTuple(node, query);
        }
    }
}

