/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.model.CICSObjectAggregateRecord;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeAggregation;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.query.AggregateRecordQuery;
import com.ibm.cics.model.query.CICSObjectQuery;
import com.ibm.cics.model.query.CICSObjectRecordsQuery;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseRuntimeException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.query.AggregateRecordQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectQueryImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

class CICSObjectRecordsQueryImpl<Interface extends ICICSObject>
extends Node<CICSObjectRecordsQueryResult>
implements CICSObjectRecordsQuery<Interface> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String FIELD_COUNT = "count";
    private static final String FIELD_RECORDS = "records";
    private static final String FIELD_AGGREGATE_RECORD = "aggregateRecord";
    private static final String FIELD_GROUP_BY = "groupBy";
    private NodeParser<List<CICSObjectQueryImpl.CICSObjectQueryResult>> recordsParser;
    private final ICICSType<Interface> type;
    private Collection<ICICSAttribute<?>> mandatoryAttributes;
    private NodeParser<Optional<Map<ICICSAttribute<?>, ? extends ICICSAttributeAggregation>>> aggregateRecordParser;
    private NodeParser<Optional<List<CICSObjectRecordsQueryResult>>> groupsParser;
    private NodeParser<Long> countParser;

    public CICSObjectRecordsQueryImpl(ICICSType<Interface> type) {
        this(type, Collections.emptyList());
    }

    public CICSObjectRecordsQueryImpl(ICICSType<Interface> type, Collection<ICICSAttribute<?>> mandatoryAttributes) {
        super(CICSObjectRecordsQueryImpl.getGraphQLTypeName(type));
        this.type = type;
        this.mandatoryAttributes = mandatoryAttributes;
    }

    @Override
    public CICSObjectRecordsQueryResult parse(JsonObject o) {
        if (this.aggregateRecordParser != null && this.countParser == null) {
            throw new NodeParseRuntimeException("Must specify count when requesting the aggregate record");
        }
        return new CICSObjectRecordsQueryResult(this.recordsParser == null ? null : this.recordsParser.parse(o), this.aggregateRecordParser == null ? null : this.aggregateRecordParser.parse(o).map(attributeAggregations -> {
            CICSObjectAggregateRecord aggregateRecord = new CICSObjectAggregateRecord(this.countParser.parse(o).intValue());
            attributeAggregations.forEach((iCICSAttribute, iCICSAttributeAggregation) -> aggregateRecord.addAttributeAggregation(iCICSAttribute, iCICSAttributeAggregation));
            return aggregateRecord;
        }), this.groupsParser == null ? null : this.groupsParser.parse(o));
    }

    static String getGraphQLTypeName(ICICSType<?> type) {
        return String.valueOf(type.getResourceTableName()) + "RecordsType";
    }

    public static String getGraphQLFieldName(ICICSType<?> type) {
        return type.getResourceTableName().toLowerCase(Locale.ROOT);
    }

    public CICSObjectRecordsQuery<Interface> fragment(FragmentReference<CICSObjectRecordsQuery<Interface>> fragment) {
        this.fragmentReference(fragment.getId());
        return this;
    }

    public CICSObjectRecordsQuery<Interface> count() {
        this.countParser = NodeParser.nonNull(this.longField(FIELD_COUNT));
        return this;
    }

    public CICSObjectRecordsQuery<Interface> records(Consumer<CICSObjectQuery<Interface>> query) {
        this.recordsParser = NodeParser.nonNull(this.arrayFieldNonNullValues(FIELD_RECORDS, new CICSObjectQueryImpl<Interface>(this.type, this.mandatoryAttributes), query));
        return this;
    }

    public CICSObjectRecordsQuery<Interface> aggregateRecord(Consumer<AggregateRecordQuery> consumer) {
        this.aggregateRecordParser = this.objectField(FIELD_AGGREGATE_RECORD, new AggregateRecordQueryImpl(this.type), consumer);
        return this;
    }

    public CICSObjectRecordsQuery<Interface> groupBy(ICICSAttribute<?> attribute, Consumer<CICSObjectRecordsQuery<Interface>> consumer) {
        this.groupsParser = this.arrayFieldNonNullValues(FIELD_GROUP_BY, ac -> {
            ArgumentsContext argumentsContext = ac.argString("attribute", attribute.getPropertyId());
        }, new CICSObjectRecordsQueryImpl<Interface>(this.type), consumer);
        return this;
    }

    public static class CICSObjectRecordsQueryResult {
        private final List<CICSObjectQueryImpl.CICSObjectQueryResult> records;
        private final Optional<CICSObjectAggregateRecord> aggregateRecord;
        private final Optional<List<CICSObjectRecordsQueryResult>> groups;

        CICSObjectRecordsQueryResult(List<CICSObjectQueryImpl.CICSObjectQueryResult> records, Optional<CICSObjectAggregateRecord> aggregateRecord, Optional<List<CICSObjectRecordsQueryResult>> groups) {
            this.records = records;
            this.aggregateRecord = aggregateRecord;
            this.groups = groups;
        }

        public List<CICSObjectQueryImpl.CICSObjectQueryResult> getRecords() {
            return this.records;
        }

        public Optional<CICSObjectAggregateRecord> getAggregateRecord() {
            return this.aggregateRecord;
        }

        public Optional<List<CICSObjectRecordsQueryResult>> getGroups() {
            return this.groups;
        }
    }
}

