/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.query.CICSResourcesQuery;
import com.ibm.cics.model.query.CICSplexQuery;
import com.ibm.cics.model.query.DREPQuery;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.model.query.RegionGroupQuery;
import com.ibm.cics.model.query.RegionQuery;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParseRuntimeException;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectRecordsQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CICSResourcesQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.DREPQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.RegionGroupQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.RegionQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.ResourceQueryNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;

class CICSplexQueryImpl
extends ResourceQueryNode<CICSplexQueryResult>
implements CICSplexQuery {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String REGION = "region";
    private static final String REGIONS = "regions";
    private static final String REGION_GROUP = "regionGroup";
    private static final String REGION_GROUPS = "regionGroups";
    private static final String DREP = "drep";
    private static final String NAME = "name";
    private static final String GRAPHQL_TYPE_NAME = "CICSplexType";
    private NodeParser<String> nameParser;
    private NodeParser<Optional<List<RegionQueryImpl.RegionQueryResult>>> regionsParser;
    private NodeParser<Optional<List<RegionGroupQueryImpl.RegionGroupQueryResult>>> regionGroupsParser;
    private NodeParser<Optional<RegionQueryImpl.RegionQueryResult>> regionParser;
    private NodeParser<Optional<RegionGroupQueryImpl.RegionGroupQueryResult>> regionGroupParser;
    private NodeParser<DREPQueryImpl.DREPQueryResult> drepParser;
    private NodeParser<Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult>> cicsResourcesParser;
    private DREPQueryImpl drepQueryImpl = new DREPQueryImpl();
    private RegionQueryImpl regionQueryImpl = new RegionQueryImpl();
    private RegionGroupQueryImpl regionGroupQueryImpl = new RegionGroupQueryImpl();

    public CICSplexQueryImpl() {
        super(GRAPHQL_TYPE_NAME);
    }

    public CICSplexQueryImpl name() {
        this.nameParser = NodeParser.nonNull(this.stringField(NAME));
        return this;
    }

    public CICSplexQueryImpl regions(Consumer<RegionQuery> query) {
        this.regionsParser = this.arrayFieldNonNullValues(REGIONS, this.regionQueryImpl, query);
        return this;
    }

    public CICSplexQueryImpl regionGroups(Consumer<RegionGroupQuery> query) {
        this.regionGroupsParser = this.arrayFieldNonNullValues(REGION_GROUPS, this.regionGroupQueryImpl, query);
        return this;
    }

    public CICSplexQueryImpl drep(Consumer<DREPQuery> query) {
        this.drepParser = NodeParser.nonNull(this.objectField(DREP, this.drepQueryImpl, query));
        return this;
    }

    public CICSplexQueryImpl region(String name, Consumer<RegionQuery> query) {
        this.regionParser = this.objectField(REGION, ac -> {
            ArgumentsContext argumentsContext = ac.argString(NAME, name);
        }, this.regionQueryImpl, query);
        return this;
    }

    public CICSplexQuery regionGroup(String name, Consumer<RegionGroupQuery> query) {
        this.regionGroupParser = this.objectField(REGION_GROUP, ac -> {
            ArgumentsContext argumentsContext = ac.argString(NAME, name);
        }, this.regionGroupQueryImpl, query);
        return this;
    }

    public CICSplexQuery cicsResources(Consumer<CICSResourcesQuery> query) {
        this.cicsResourcesParser = NodeParser.nonNull(this.objectField("cicsResources", new CICSResourcesQueryImpl(), query));
        return this;
    }

    public CICSplexQuery fragment(FragmentReference<CICSplexQuery> fragment) {
        this.fragmentReference(fragment.getId());
        return this;
    }

    @Override
    public CICSplexQueryResult parse(JsonObject o) {
        if (this.nameParser == null) {
            throw new NodeParseRuntimeException("CICSplex query node was missing required field 'name'");
        }
        return new CICSplexQueryResult(this.nameParser.parse(o), CICSplexQueryImpl.parseOptionalResult(this.regionParser, o), CICSplexQueryImpl.parseOptionalList(this.regionsParser, o), CICSplexQueryImpl.parseOptionalResult(this.regionGroupParser, o), CICSplexQueryImpl.parseOptionalList(this.regionGroupsParser, o), CICSplexQueryImpl.parse(this.drepParser, o), CICSplexQueryImpl.parseMap(this.cicsResourcesParser, o));
    }

    static class CICSplexQueryResult {
        final String name;
        final Optional<RegionQueryImpl.RegionQueryResult> regionResult;
        final List<RegionQueryImpl.RegionQueryResult> regionResults;
        final Optional<RegionGroupQueryImpl.RegionGroupQueryResult> regionGroupResult;
        final List<RegionGroupQueryImpl.RegionGroupQueryResult> regionGroupResults;
        final Optional<DREPQueryImpl.DREPQueryResult> drepResult;
        final Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult> cicsResources;

        public CICSplexQueryResult(String name, Optional<RegionQueryImpl.RegionQueryResult> regionResult, List<RegionQueryImpl.RegionQueryResult> regionResults, Optional<RegionGroupQueryImpl.RegionGroupQueryResult> regionGroupResult, List<RegionGroupQueryImpl.RegionGroupQueryResult> regionGroupResults, Optional<DREPQueryImpl.DREPQueryResult> drepResult, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult> cicsResources) {
            this.name = name;
            this.regionResult = regionResult;
            this.regionResults = regionResults;
            this.regionGroupResult = regionGroupResult;
            this.regionGroupResults = regionGroupResults;
            this.drepResult = drepResult;
            this.cicsResources = cicsResources;
        }
    }
}

