/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal.query;

import com.google.gson.JsonObject;
import com.ibm.cics.core.model.AbstractCICSDefinitionType;
import com.ibm.cics.core.model.AbstractCICSResourceType;
import com.ibm.cics.core.model.AbstractCICSType;
import com.ibm.cics.core.model.AbstractCPSMDefinitionType;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.query.CICSplexQuery;
import com.ibm.cics.model.query.FragmentReference;
import com.ibm.cics.model.query.Query;
import com.ibm.cics.sm.comm.sm.internal.graphql.ArgumentsContext;
import com.ibm.cics.sm.comm.sm.internal.graphql.Node;
import com.ibm.cics.sm.comm.sm.internal.graphql.NodeParser;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineBASRepository;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSDefinitionContainer;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSObjectContainer;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSRegion;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSRegionGroup;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCICSplex;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCPSM;
import com.ibm.cics.sm.comm.sm.internal.offline.OfflineCPSMDefinitionRepository;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CICSObjectRecordsQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.CICSplexQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.DREPQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.RegionGroupQueryImpl;
import com.ibm.cics.sm.comm.sm.internal.query.RegionQueryImpl;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

class QueryImpl
extends Node<OfflineCPSM>
implements Query {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2018 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String GRAPH_QL_TYPE_NAME = "QueryType";
    private static final String FIELD_CICSPLEXES = "cicsplexes";
    private static final String FIELD_CICSPLEX = "cicsplex";
    private NodeParser<Optional<CICSplexQueryImpl.CICSplexQueryResult>> cicsplexParser;
    private NodeParser<Optional<List<CICSplexQueryImpl.CICSplexQueryResult>>> cicsplexesParser;

    public QueryImpl() {
        super(GRAPH_QL_TYPE_NAME);
    }

    @Override
    public OfflineCPSM parse(JsonObject o) {
        OfflineCPSM cpsm = new OfflineCPSM();
        QueryImpl.parseOptionalResult(this.cicsplexParser, o).ifPresent(cpr -> QueryImpl.interpretCICSplexResult(cpsm, cpr));
        QueryImpl.parseOptionalList(this.cicsplexesParser, o).forEach(cpr -> QueryImpl.interpretCICSplexResult(cpsm, cpr));
        return cpsm;
    }

    public Query cicsplex(String name, Consumer<CICSplexQuery> query) {
        this.cicsplexParser = this.objectField(FIELD_CICSPLEX, ac -> {
            ArgumentsContext argumentsContext = ac.argString("name", name);
        }, new CICSplexQueryImpl(), query);
        return this;
    }

    public Query cicsplexes(Consumer<CICSplexQuery> query) {
        this.cicsplexesParser = this.arrayFieldNonNullValues(FIELD_CICSPLEXES, new CICSplexQueryImpl(), query);
        return this;
    }

    public Query fragment(FragmentReference<Query> fragment) {
        this.fragmentReference(fragment.getId());
        return this;
    }

    private static void interpretCICSplexResult(OfflineCPSM cpsm, CICSplexQueryImpl.CICSplexQueryResult result) {
        OfflineCICSplex plex = cpsm.getOrCreateOfflineCICSplex(result.name);
        result.regionResult.ifPresent(region -> QueryImpl.interpretRegionResult(plex, region));
        result.regionResults.forEach(region -> QueryImpl.interpretRegionResult(plex, region));
        result.regionGroupResult.ifPresent(regionGroup -> QueryImpl.interpretRegionGroupResult(plex, regionGroup));
        result.regionGroupResults.forEach(regionGroup -> QueryImpl.interpretRegionGroupResult(plex, regionGroup));
        result.drepResult.ifPresent(drep -> QueryImpl.interpretDREPResult(plex, drep));
        QueryImpl.interpretCICSResourceResult(plex::getOrCreateOfflineRegion, result.cicsResources);
    }

    private static void interpretDREPResult(OfflineCICSplex plex, DREPQueryImpl.DREPQueryResult result) {
        QueryImpl.createObjects(plex.getBASRepository(), result.cicsDefinitions);
        QueryImpl.createObjects(plex.getCPSMDefinitionRepository(), result.cpsmDefinitions);
    }

    private static void interpretRegionGroupResult(OfflineCICSplex plex, RegionGroupQueryImpl.RegionGroupQueryResult result) {
        OfflineCICSRegionGroup group = plex.getOrCreateOfflineRegionGroup(result.name);
        QueryImpl.interpretCICSResourceResult(group::getOrCreateOfflineRegion, result.cicsResources);
    }

    private static void interpretCICSResourceResult(Function<String, OfflineCICSRegion> containerSupplier, Map<ICICSType<? extends ICICSResource>, CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult> map) {
        map.entrySet().stream().forEach(e -> QueryImpl.createObjects(containerSupplier, (ICICSType<? extends ICICSResource>)((ICICSType)e.getKey()), (CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult)e.getValue()));
    }

    private static void createObjects(Function<String, OfflineCICSRegion> containerSupplier, ICICSType<? extends ICICSResource> type, CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult regionResults) {
        regionResults.getRecords().forEach(regionResult -> QueryImpl.createCICSResource(containerSupplier, type, regionResult));
    }

    private static <T extends ICICSResource> void createCICSResource(Function<String, OfflineCICSRegion> containerSupplier, ICICSType<T> type, CICSObjectQueryImpl.CICSObjectQueryResult result) {
        String regionName = (String)result.avm.getAttributeValue((ICICSAttribute)AbstractCICSResourceType.REGION_NAME);
        QueryImpl.createObject(containerSupplier.apply(regionName), type, result);
    }

    private static void interpretRegionResult(OfflineCICSplex plex, RegionQueryImpl.RegionQueryResult regionResult) {
        OfflineCICSRegion region = plex.getOrCreateOfflineRegion(regionResult.name);
        QueryImpl.createObjects(region, regionResult.cicsResources);
        OfflineCICSDefinitionContainer csd = region.getCSD();
        regionResult.csdResult.ifPresent(csdResult -> QueryImpl.createObjects(csd, csdResult.cicsDefinitions));
    }

    private static <Interface extends ICICSObject> void createObjects(OfflineCICSObjectContainer<Interface> container, Map<ICICSType<? extends Interface>, CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult> resultsMap) {
        resultsMap.forEach((type, results) -> QueryImpl.createObjects(container, type, results));
    }

    private static <Interface extends ICICSObject> void createObjects(OfflineCICSObjectContainer<Interface> container, ICICSType<? extends Interface> type, CICSObjectRecordsQueryImpl.CICSObjectRecordsQueryResult results) {
        results.getRecords().forEach(qr -> QueryImpl.createObject(container, type, qr));
    }

    static <Interface extends ICICSObject, T extends Interface> void createObject(OfflineCICSObjectContainer<Interface> container, ICICSType<T> type, CICSObjectQueryImpl.CICSObjectQueryResult result) {
        OfflineCICSObjectContainer<Interface> newContainer = QueryImpl.convertContainer(container, type);
        ICICSObject instance = ((AbstractCICSType)type).createBlind(newContainer, result.avm);
        container.add(type, instance);
        result.from.forEach((ref, res) -> QueryImpl.createObjects(QueryImpl.convertContainer(container, ref.getFromType()), ref.getFromType(), res));
        result.to.forEach((ref, res) -> QueryImpl.createObject(QueryImpl.convertContainer(container, ref.getToType()), ref.getToType(), res));
    }

    private static <Interface extends ICICSObject, T extends Interface> OfflineCICSObjectContainer<Interface> convertContainer(OfflineCICSObjectContainer<Interface> container, ICICSType<? extends Interface> cicsType) {
        if (container instanceof OfflineCPSMDefinitionRepository && cicsType instanceof AbstractCICSDefinitionType) {
            return (OfflineCICSObjectContainer)((OfflineCPSMDefinitionRepository)container).getDREP();
        }
        if (container instanceof OfflineCICSDefinitionContainer && cicsType instanceof AbstractCPSMDefinitionType) {
            return (OfflineCICSObjectContainer)((OfflineCICSDefinitionContainer)container).getCPSMDefinitionContainer();
        }
        if (container instanceof OfflineBASRepository && cicsType instanceof AbstractCPSMDefinitionType) {
            return (OfflineCICSObjectContainer)((OfflineBASRepository)container).getCPSMDefinitionContainer();
        }
        return container;
    }
}

