/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.core.model.TableDescriptions;
import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeHint;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public abstract class CICSObjectReference<T extends ICICSObject>
implements ICICSObjectReference<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICICSType<T> type;
    private final Map<ICICSAttribute<?>, Object> attributes = new LinkedHashMap();

    protected CICSObjectReference(ICICSType<T> type, AttributeValue<?> ... attributeValues) {
        this.type = type;
        AttributeValue<?>[] attributeValueArray = attributeValues;
        int n = attributeValues.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeValue<?> attributeValue = attributeValueArray[n2];
            this.setAttributeValue(attributeValue);
            ++n2;
        }
        if (!this.attributes.keySet().equals(type.getKeyAttributes())) {
            throw new IllegalArgumentException("AttributeValues must contain an identical set of the attributes defined to be key attributes by supplied type " + type + " containing: " + type.getKeyAttributes().toArray() + ", supplied: " + this.attributes.keySet().toArray());
        }
    }

    private <E> void setAttributeValue(AttributeValue<E> attributeValue) {
        this.setAttributeValue(attributeValue.getAttribute(), attributeValue.getValue());
    }

    public ICICSType<T> getCICSType() {
        return this.type;
    }

    public <V> void setAttributeValue(ICICSAttribute<V> attribute, V value) {
        this.attributes.put(attribute, value);
    }

    public <V> V getAttributeValue(ICICSAttribute<V> attribute) {
        return (V)this.attributes.get(attribute);
    }

    public int compareTo(ICICSObjectReference<?> other) {
        return other.getCICSType() == this.type ? this.compareAttributes(other) : this.type.compareTo((Object)other.getCICSType());
    }

    private int compareAttributes(ICICSObjectReference<?> other) {
        return this.type.getKeyAttributes().stream().map(a -> this.compareAttributeValue((ICICSAttribute)a, other)).filter(i -> i != 0).findFirst().orElse(0);
    }

    private <E> int compareAttributeValue(ICICSAttribute<E> attribute, ICICSObjectReference<?> other) {
        return attribute.getComparator().compare(this.getAttributeValue(attribute), other.getAttributeValue(attribute));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CICSObjectReference other = (CICSObjectReference)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.attributes == null) {
            if (other.attributes != null) {
                return false;
            }
        } else {
            for (ICICSAttribute<?> attribute : this.attributes.keySet()) {
                Object otherVal;
                if (!other.attributes.containsKey(attribute)) {
                    return false;
                }
                Object myVal = this.attributes.get(attribute);
                if (CICSObjectReference.attributeValuesEqual(attribute, myVal, otherVal = other.attributes.get(attribute))) continue;
                return false;
            }
        }
        return !(this.getCICSContainer() == null ? other.getCICSContainer() != null : !this.getCICSContainer().equals(other.getCICSContainer()));
    }

    public T resolve() throws CICSActionException {
        return (T)this.getCICSContainer().resolve((ICICSObjectReference)this);
    }

    public void delete() throws CICSActionException {
        ICICSObjectSet set = this.getCICSContainer().getCICSObjectSet(this.type);
        set.setFilter(this.getFilterExpression());
        set.delete();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.getCICSContainer() == null ? 0 : this.getCICSContainer().hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public String getDescription() {
        String tableDescription = TableDescriptions.getTableDescription(this.type);
        return NLS.bind((String)"{0} \"{1}\"", (Object[])new Object[]{tableDescription, this.getAttributesDescription()});
    }

    private String getAttributesDescription() {
        String attributeValue;
        String nameAttribute = this.type.getNameAttribute();
        ICICSAttribute attribute = this.type.findAttributeByCicsName(nameAttribute);
        if (attribute != null && attribute.getType() == String.class && (attributeValue = (String)this.getAttributeValue(attribute)) != null) {
            return attributeValue;
        }
        return "";
    }

    private static boolean attributeValuesEqual(ICICSAttribute<?> attribute, Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        ICICSAttributeHint hint = attribute.getValuesHint();
        if (hint.hasSpecialValues() && hint.getSpecialValues().values().contains(value1)) {
            return value2 == value1;
        }
        return value1.equals(value2);
    }

    public String toString() {
        return this.getDescription();
    }

    public <X> FilterExpression isFilter(ICICSAttribute<X> attribute) {
        return FilterExpression.is(attribute, this.getAttributeValue(attribute));
    }

    public FilterExpression getFilterExpression() {
        return this.type.getKeyAttributes().stream().filter(attribute -> this.getAttributeValue((ICICSAttribute)attribute) != attribute.getUnsupportedValue()).map(attribute -> this.isFilter((ICICSAttribute)attribute)).reduce(FilterExpression.NULL, (f1, f2) -> f1.and(f2));
    }
}

