/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CICSAttributeValueSource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICICSObject cicsObject;
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Map<ICICSAttribute<?>, Method> getMethodMap = new HashMap();

    public CICSAttributeValueSource(ICICSObject cicsObject) {
        ICICSAttribute[] attributes;
        this.cicsObject = cicsObject;
        ICICSAttribute[] iCICSAttributeArray = attributes = cicsObject.getObjectType().attributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSAttribute attribute = iCICSAttributeArray[n2];
            Method method = CICSAttributeValueSource.getGetter(cicsObject.getObjectType(), attribute);
            if (method != null && attribute.getType().isAssignableFrom(method.getReturnType())) {
                this.getMethodMap.put(attribute, method);
            }
            ++n2;
        }
    }

    public ICICSType<?> getCICSType() {
        return this.cicsObject.getObjectType();
    }

    public <T> T getAttributeValue(ICICSAttribute<T> attribute) {
        if (this.getMethodMap.containsKey(attribute)) {
            Method method = this.getMethodMap.get(attribute);
            try {
                return (T)method.invoke((Object)this.cicsObject, EMPTY_OBJECT_ARRAY);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new IllegalArgumentException("Attribute '" + attribute.getPropertyId() + "' not available on type '" + this.cicsObject.getObjectType().getResourceTableName() + "'");
    }

    private static Method getGetter(ICICSType<?> cicsType, ICICSAttribute<?> attribute) {
        Class clazz = cicsType.getInterfaceType();
        try {
            return clazz.getMethod(CICSAttributeValueSource.getMethodNameFromAttribute(attribute), EMPTY_CLASS_ARRAY);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    private static String getMethodNameFromAttribute(ICICSAttribute<?> attribute) {
        String id = attribute.getPropertyId();
        return "get" + id.substring(0, 1).toUpperCase(Locale.ENGLISH) + id.substring(1);
    }
}

