/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.CICSplexReference;
import com.ibm.cics.core.model.CICSplexType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CPSMManager;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSplex;
import com.ibm.cics.model.ICPSMManagerContainer;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public abstract class CICSplexGen
extends CPSMManager
implements ICICSplex {
    private String _plexname;
    private String _cmasname;
    private String _transitcmas;
    private ICICSplex.CMASStatusValue _status;
    private ICICSplex.AccessTypeValue _accesstype;
    private ICICSEnums.YesNoValue _mpstatus;
    private Long _transitcnt;
    private String _sysid;
    private Long _readrs;
    private Long _updaters;
    private Long _toprsupd;
    private Long _botrsupd;
    private String _rspoolid;

    public CICSplexGen(ICPSMManagerContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._plexname = (String)avm.getAttributeValue(CICSplexType.NAME);
        this._cmasname = (String)avm.getAttributeValue(CICSplexType.CMAS_NAME);
        this._transitcmas = (String)avm.getAttributeValue(CICSplexType.TRANSIT_CMAS, true);
        this._status = (ICICSplex.CMASStatusValue)avm.getAttributeValue(CICSplexType.CMAS_STATUS, true);
        this._accesstype = (ICICSplex.AccessTypeValue)avm.getAttributeValue(CICSplexType.ACCESS_TYPE, true);
        this._mpstatus = (ICICSEnums.YesNoValue)avm.getAttributeValue(CICSplexType.MP_STATUS, true);
        this._transitcnt = (Long)avm.getAttributeValue(CICSplexType.TRANSIT_CMAS_COUNT, true);
        this._sysid = (String)avm.getAttributeValue(CICSplexType.CMAS_SYSTEM_ID, true);
        this._readrs = (Long)avm.getAttributeValue(CICSplexType.READRS, true);
        this._updaters = (Long)avm.getAttributeValue(CICSplexType.UPDATERS, true);
        this._toprsupd = (Long)avm.getAttributeValue(CICSplexType.TOPRSUPD, true);
        this._botrsupd = (Long)avm.getAttributeValue(CICSplexType.BOTRSUPD, true);
        this._rspoolid = (String)avm.getAttributeValue(CICSplexType.RSPOOLID, true);
    }

    public CICSplexGen(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("PLEXNAME");
        this._plexname = (String)((CICSAttribute)CICSplexType.NAME).get(stringValue, normalizers);
        stringValue = record.get("CMASNAME");
        this._cmasname = (String)((CICSAttribute)CICSplexType.CMAS_NAME).get(stringValue, normalizers);
        stringValue = record.get("TRANSITCMAS");
        this._transitcmas = (String)((CICSAttribute)CICSplexType.TRANSIT_CMAS).get(stringValue, normalizers);
        stringValue = record.get("STATUS");
        this._status = (ICICSplex.CMASStatusValue)((CICSAttribute)CICSplexType.CMAS_STATUS).get(stringValue, normalizers);
        stringValue = record.get("ACCESSTYPE");
        this._accesstype = (ICICSplex.AccessTypeValue)((CICSAttribute)CICSplexType.ACCESS_TYPE).get(stringValue, normalizers);
        stringValue = record.get("MPSTATUS");
        this._mpstatus = (ICICSEnums.YesNoValue)((CICSAttribute)CICSplexType.MP_STATUS).get(stringValue, normalizers);
        stringValue = record.get("TRANSITCNT");
        this._transitcnt = (Long)((CICSAttribute)CICSplexType.TRANSIT_CMAS_COUNT).get(stringValue, normalizers);
        stringValue = record.get("SYSID");
        this._sysid = (String)((CICSAttribute)CICSplexType.CMAS_SYSTEM_ID).get(stringValue, normalizers);
        stringValue = record.get("READRS");
        this._readrs = (Long)((CICSAttribute)CICSplexType.READRS).get(stringValue, normalizers);
        stringValue = record.get("UPDATERS");
        this._updaters = (Long)((CICSAttribute)CICSplexType.UPDATERS).get(stringValue, normalizers);
        stringValue = record.get("TOPRSUPD");
        this._toprsupd = (Long)((CICSAttribute)CICSplexType.TOPRSUPD).get(stringValue, normalizers);
        stringValue = record.get("BOTRSUPD");
        this._botrsupd = (Long)((CICSAttribute)CICSplexType.BOTRSUPD).get(stringValue, normalizers);
        stringValue = record.get("RSPOOLID");
        this._rspoolid = (String)((CICSAttribute)CICSplexType.RSPOOLID).get(stringValue, normalizers);
    }

    public String getName() {
        return this._plexname;
    }

    public String getCMASName() {
        return this._cmasname;
    }

    public String getTransitCMAS() {
        return this._transitcmas;
    }

    public ICICSplex.CMASStatusValue getCMASStatus() {
        return this._status;
    }

    public ICICSplex.AccessTypeValue getAccessType() {
        return this._accesstype;
    }

    public ICICSEnums.YesNoValue getMPStatus() {
        return this._mpstatus;
    }

    public Long getTransitCMASCount() {
        return this._transitcnt;
    }

    public String getCMASSystemID() {
        return this._sysid;
    }

    public Long getReadrs() {
        return this._readrs;
    }

    public Long getUpdaters() {
        return this._updaters;
    }

    public Long getToprsupd() {
        return this._toprsupd;
    }

    public Long getBotrsupd() {
        return this._botrsupd;
    }

    public String getRspoolid() {
        return this._rspoolid;
    }

    public CICSplexType getObjectType() {
        return CICSplexType.getInstance();
    }

    @Override
    public CICSplexReference getCICSObjectReference() {
        return new CICSplexReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == CICSplexType.NAME) {
            return (V)this.getName();
        }
        if (attribute == CICSplexType.CMAS_NAME) {
            return (V)this.getCMASName();
        }
        if (attribute == CICSplexType.TRANSIT_CMAS) {
            return (V)this.getTransitCMAS();
        }
        if (attribute == CICSplexType.CMAS_STATUS) {
            return (V)this.getCMASStatus();
        }
        if (attribute == CICSplexType.ACCESS_TYPE) {
            return (V)this.getAccessType();
        }
        if (attribute == CICSplexType.MP_STATUS) {
            return (V)this.getMPStatus();
        }
        if (attribute == CICSplexType.TRANSIT_CMAS_COUNT) {
            return (V)this.getTransitCMASCount();
        }
        if (attribute == CICSplexType.CMAS_SYSTEM_ID) {
            return (V)this.getCMASSystemID();
        }
        if (attribute == CICSplexType.READRS) {
            return (V)this.getReadrs();
        }
        if (attribute == CICSplexType.UPDATERS) {
            return (V)this.getUpdaters();
        }
        if (attribute == CICSplexType.TOPRSUPD) {
            return (V)this.getToprsupd();
        }
        if (attribute == CICSplexType.BOTRSUPD) {
            return (V)this.getBotrsupd();
        }
        if (attribute == CICSplexType.RSPOOLID) {
            return (V)this.getRspoolid();
        }
        return super.getAttributeValue(attribute);
    }
}

