/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.DB2TransactionDefinitionReference;
import com.ibm.cics.core.model.DB2TransactionDefinitionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSDefinition;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSDefinitionContainer;
import com.ibm.cics.model.IDB2TransactionDefinition;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class DB2TransactionDefinition
extends CICSDefinition
implements IDB2TransactionDefinition {
    private String _entry;
    private String _transid;
    private String _userdata1;
    private String _userdata2;
    private String _userdata3;

    public DB2TransactionDefinition(ICICSDefinitionContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._entry = (String)avm.getAttributeValue(DB2TransactionDefinitionType.DB2_ENTRY, true);
        this._transid = (String)avm.getAttributeValue(DB2TransactionDefinitionType.TRANSACTION, true);
        this._userdata1 = (String)avm.getAttributeValue(DB2TransactionDefinitionType.USERDATA_1, true);
        this._userdata2 = (String)avm.getAttributeValue(DB2TransactionDefinitionType.USERDATA_2, true);
        this._userdata3 = (String)avm.getAttributeValue(DB2TransactionDefinitionType.USERDATA_3, true);
    }

    public DB2TransactionDefinition(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("ENTRY");
        this._entry = (String)((CICSAttribute)DB2TransactionDefinitionType.DB2_ENTRY).get(stringValue, normalizers);
        stringValue = record.get("TRANSID");
        this._transid = (String)((CICSAttribute)DB2TransactionDefinitionType.TRANSACTION).get(stringValue, normalizers);
        stringValue = record.get("USERDATA1");
        this._userdata1 = (String)((CICSAttribute)DB2TransactionDefinitionType.USERDATA_1).get(stringValue, normalizers);
        stringValue = record.get("USERDATA2");
        this._userdata2 = (String)((CICSAttribute)DB2TransactionDefinitionType.USERDATA_2).get(stringValue, normalizers);
        stringValue = record.get("USERDATA3");
        this._userdata3 = (String)((CICSAttribute)DB2TransactionDefinitionType.USERDATA_3).get(stringValue, normalizers);
    }

    public String getDB2Entry() {
        return this._entry;
    }

    public String getTransaction() {
        return this._transid;
    }

    public String getUserdata1() {
        return this._userdata1;
    }

    public String getUserdata2() {
        return this._userdata2;
    }

    public String getUserdata3() {
        return this._userdata3;
    }

    public DB2TransactionDefinitionType getObjectType() {
        return DB2TransactionDefinitionType.getInstance();
    }

    @Override
    public DB2TransactionDefinitionReference getCICSObjectReference() {
        return new DB2TransactionDefinitionReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == DB2TransactionDefinitionType.DB2_ENTRY) {
            return (V)this.getDB2Entry();
        }
        if (attribute == DB2TransactionDefinitionType.TRANSACTION) {
            return (V)this.getTransaction();
        }
        if (attribute == DB2TransactionDefinitionType.USERDATA_1) {
            return (V)this.getUserdata1();
        }
        if (attribute == DB2TransactionDefinitionType.USERDATA_2) {
            return (V)this.getUserdata2();
        }
        if (attribute == DB2TransactionDefinitionType.USERDATA_3) {
            return (V)this.getUserdata3();
        }
        return super.getAttributeValue(attribute);
    }
}

