/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.EPAdapterInSetReference;
import com.ibm.cics.core.model.EPAdapterInSetType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.CICSResource;
import com.ibm.cics.model.AttributeValueMap;
import com.ibm.cics.model.ICICSResourceContainer;
import com.ibm.cics.model.IEPAdapterInSet;
import com.ibm.cics.model.IllegalCICSAttributeException;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Map;

public class EPAdapterInSet
extends CICSResource
implements IEPAdapterInSet {
    private String _epadapter;
    private String _epadapterset;

    public EPAdapterInSet(ICICSResourceContainer container, AttributeValueMap avm) {
        super(container, avm);
        this._epadapter = (String)avm.getAttributeValue(EPAdapterInSetType.EP_ADAPTER);
        this._epadapterset = (String)avm.getAttributeValue(EPAdapterInSetType.EP_ADAPTER_SET);
    }

    public EPAdapterInSet(ICPSM cpsm, IContext context, SMConnectionRecord record) {
        super(cpsm, context, record);
        Map normalizers = record.getNormalizers();
        String stringValue = record.get("EPADAPTER");
        this._epadapter = (String)((CICSAttribute)EPAdapterInSetType.EP_ADAPTER).get(stringValue, normalizers);
        stringValue = record.get("EPADAPTERSET");
        this._epadapterset = (String)((CICSAttribute)EPAdapterInSetType.EP_ADAPTER_SET).get(stringValue, normalizers);
    }

    public final String getName() {
        try {
            return EPAdapterInSetType.EP_ADAPTER.internalToExternal((Object)this.getEpAdapter());
        }
        catch (IllegalCICSAttributeException ex) {
            return "";
        }
    }

    public String getEpAdapter() {
        return this._epadapter;
    }

    public String getEpAdapterSet() {
        return this._epadapterset;
    }

    public EPAdapterInSetType getObjectType() {
        return EPAdapterInSetType.getInstance();
    }

    @Override
    public EPAdapterInSetReference getCICSObjectReference() {
        return new EPAdapterInSetReference(this.getCICSContainer(), this);
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == EPAdapterInSetType.EP_ADAPTER) {
            return (V)this.getEpAdapter();
        }
        if (attribute == EPAdapterInSetType.EP_ADAPTER_SET) {
            return (V)this.getEpAdapterSet();
        }
        return super.getAttributeValue(attribute);
    }
}

