/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.AbstractCICSObjectContainer;
import com.ibm.cics.core.model.internal.FilterVisitor;
import com.ibm.cics.core.model.internal.ObjectGetter;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.FilterExpression;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSObjectReference;
import com.ibm.cics.model.ICICSObjectSet;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IFilterVisitor;
import com.ibm.cics.model.topology.CPSM;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.IContext;
import java.util.List;

public class GenericContainer<T extends ICICSObject>
extends AbstractCICSObjectContainer<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected final ICPSM cpsm;
    protected final IContext baseContext;

    public GenericContainer(ICPSM cpsm, IContext baseContext) {
        this.cpsm = cpsm;
        this.baseContext = baseContext;
    }

    public CPSM getCPSM() {
        return this.cpsm.getTopology();
    }

    public String getDescription() {
        String description = ContextHelper.findGroup((IContext)this.baseContext);
        if (description == null) {
            description = ContextHelper.findScope((IContext)this.baseContext);
        }
        if (description == null) {
            description = this.baseContext.getContext();
        }
        return description;
    }

    @Override
    public <X extends T> ObjectGetter<X> getGetter(ICICSType<X> type, FilterExpression filterExpression) {
        IContext context = this.getContext(filterExpression);
        return new ObjectGetter<X>(this.cpsm, type, context);
    }

    private IContext getContext(FilterExpression filterExpression) {
        IContext context = this.baseContext;
        if (filterExpression != null) {
            FilterVisitor filterVisitor = new FilterVisitor(context);
            filterExpression.accept((IFilterVisitor)filterVisitor);
            context = filterVisitor.getContext();
        }
        return context;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseContext == null ? 0 : this.baseContext.hashCode());
        result = 31 * result + (this.cpsm == null ? 0 : this.cpsm.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericContainer other = (GenericContainer)obj;
        if (this.baseContext == null ? other.baseContext != null : !this.baseContext.equals(other.baseContext)) {
            return false;
        }
        return !(this.cpsm == null ? other.cpsm != null : !this.cpsm.equals(other.cpsm));
    }

    @Override
    public <X extends T> void delete(ICICSType<X> type, FilterExpression filterExpression) throws CICSActionException {
        IContext context = this.getContext(filterExpression);
        this.cpsm.delete(type, context);
    }

    public <X extends T> X resolve(ICICSObjectReference<X> reference) throws CICSActionException {
        ICICSType type = reference.getCICSType();
        ICICSObjectSet set = this.getCICSObjectSet(type);
        set.setFilter(reference.getFilterExpression());
        List list = set.get();
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return (X)((ICICSObject)list.get(0));
        }
        throw new CICSActionException("Resolving reference [" + reference + "] returned " + list.size() + " results, where 0 or 1 are expected");
    }
}

