/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.GlobalTCPIPStatisticsReference;
import com.ibm.cics.core.model.GlobalTCPIPStatisticsType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IGlobalTCPIPStatistics;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableGlobalTCPIPStatistics;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableGlobalTCPIPStatistics
extends MutableCICSResource
implements IMutableGlobalTCPIPStatistics {
    private IGlobalTCPIPStatistics delegate;
    private MutableSMRecord record;

    public MutableGlobalTCPIPStatistics(ICPSM cpsm, IContext context, IGlobalTCPIPStatistics cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("TCPIPGBL");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public IGlobalTCPIPStatistics.StatusValue getStatus() {
        String result = this.record.get("STATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (IGlobalTCPIPStatistics.StatusValue)((CICSAttribute)GlobalTCPIPStatisticsType.STATUS).get(result, this.record.getNormalizers());
    }

    public Long getMaxNumberOfTCPIPSockets() {
        String result = this.record.get("MAXSOCKETS");
        if (result == null) {
            return this.delegate.getMaxNumberOfTCPIPSockets();
        }
        return (Long)((CICSAttribute)GlobalTCPIPStatisticsType.MAX_NUMBER_OF_TCPIP_SOCKETS).get(result, this.record.getNormalizers());
    }

    public Long getActiveSocketsCount() {
        return this.delegate.getActiveSocketsCount();
    }

    public Long getInboundSocketsCount() {
        return this.delegate.getInboundSocketsCount();
    }

    public Long getPeakInboundSockets() {
        return this.delegate.getPeakInboundSockets();
    }

    public Long getNonPersistentOutboundSockets() {
        return this.delegate.getNonPersistentOutboundSockets();
    }

    public Long getPeakNonPersistentOutboundSockets() {
        return this.delegate.getPeakNonPersistentOutboundSockets();
    }

    public Long getPersistentOutboundSocketsCount() {
        return this.delegate.getPersistentOutboundSocketsCount();
    }

    public Long getPeakPersistentOutboundSockets() {
        return this.delegate.getPeakPersistentOutboundSockets();
    }

    public Long getInboundSocketsCreatedCount() {
        return this.delegate.getInboundSocketsCreatedCount();
    }

    public Long getOutboundSocketsCreatedCount() {
        return this.delegate.getOutboundSocketsCreatedCount();
    }

    public Long getOutboundSocketsClosedCount() {
        return this.delegate.getOutboundSocketsClosedCount();
    }

    public Long getMaxSocketsReachedCount() {
        return this.delegate.getMaxSocketsReachedCount();
    }

    public Long getTotalRequestsDelayedAtMaxSockets() {
        return this.delegate.getTotalRequestsDelayedAtMaxSockets();
    }

    public Long getTotalDelayTimeAtMaxSockets() {
        return this.delegate.getTotalDelayTimeAtMaxSockets();
    }

    public Long getTimeoutsAtMaxSockets() {
        return this.delegate.getTimeoutsAtMaxSockets();
    }

    public Long getRequestsDelayedAtMaxSockets() {
        return this.delegate.getRequestsDelayedAtMaxSockets();
    }

    public Long getPeakRequestsDelayedAtMaxSockets() {
        return this.delegate.getPeakRequestsDelayedAtMaxSockets();
    }

    public Long getDelayTimeAtMaxSockets() {
        return this.delegate.getDelayTimeAtMaxSockets();
    }

    public IGlobalTCPIPStatistics.SSLCacheTypeValue getSSLCacheType() {
        return this.delegate.getSSLCacheType();
    }

    public String getCRLServerName() {
        return this.delegate.getCRLServerName();
    }

    public String getCRLProfileName() {
        return this.delegate.getCRLProfileName();
    }

    public IGlobalTCPIPStatistics.SotuningValue getSotuning() {
        return this.delegate.getSotuning();
    }

    public Long getTaskAcceptLimitCount() {
        return this.delegate.getTaskAcceptLimitCount();
    }

    public Date getLastSocketListenerPausedTime() {
        return this.delegate.getLastSocketListenerPausedTime();
    }

    public IGlobalTCPIPStatistics.RegionStoppingPersistentValue getRegionStoppingPersistent() {
        return this.delegate.getRegionStoppingPersistent();
    }

    public Long getRegionStoppedPersistenceCount() {
        return this.delegate.getRegionStoppedPersistenceCount();
    }

    public Date getLastTimeStoppedHTTPPersistence() {
        return this.delegate.getLastTimeStoppedHTTPPersistence();
    }

    public Long getPersistentMadeNonPersistentCount() {
        return this.delegate.getPersistentMadeNonPersistentCount();
    }

    public Long getDisconnectedAtMaxUsesCount() {
        return this.delegate.getDisconnectedAtMaxUsesCount();
    }

    public IGlobalTCPIPStatistics.PausingListValue getPausingList() {
        return this.delegate.getPausingList();
    }

    public Long getTotalPersistentOutboundSockets() {
        return this.delegate.getTotalPersistentOutboundSockets();
    }

    public Long getPeakOutboundSockets() {
        return this.delegate.getPeakOutboundSockets();
    }

    public Long getPeakNonPersistentInboundSockets() {
        return this.delegate.getPeakNonPersistentInboundSockets();
    }

    public Long getNonPersistentInboundSockets() {
        return this.delegate.getNonPersistentInboundSockets();
    }

    public Long getTotalNonPersistentInboundSocketsCreated() {
        return this.delegate.getTotalNonPersistentInboundSocketsCreated();
    }

    public Long getOutboundSocketsReusedCount() {
        return this.delegate.getOutboundSocketsReusedCount();
    }

    public Long getPeakPersistentInboundSockets() {
        return this.delegate.getPeakPersistentInboundSockets();
    }

    public void setStatus(IGlobalTCPIPStatistics.StatusValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("STATUS", null);
        } else {
            GlobalTCPIPStatisticsType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)GlobalTCPIPStatisticsType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("STATUS", connectionSpecificExternalValue);
        }
    }

    public void setMaxNumberOfTCPIPSockets(Long _maxNumberOfTCPIPSockets) {
        if (_maxNumberOfTCPIPSockets.equals(this.delegate.getMaxNumberOfTCPIPSockets())) {
            this.record.set("MAXSOCKETS", null);
        } else {
            GlobalTCPIPStatisticsType.MAX_NUMBER_OF_TCPIP_SOCKETS.validate((Object)_maxNumberOfTCPIPSockets);
            String connectionSpecificExternalValue = ((CICSAttribute)GlobalTCPIPStatisticsType.MAX_NUMBER_OF_TCPIP_SOCKETS).set(_maxNumberOfTCPIPSockets, this.record.getNormalizers());
            this.record.set("MAXSOCKETS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == GlobalTCPIPStatisticsType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == GlobalTCPIPStatisticsType.MAX_NUMBER_OF_TCPIP_SOCKETS) {
            return (V)this.getMaxNumberOfTCPIPSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.ACTIVE_SOCKETS_COUNT) {
            return (V)this.getActiveSocketsCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.INBOUND_SOCKETS_COUNT) {
            return (V)this.getInboundSocketsCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.PEAK_INBOUND_SOCKETS) {
            return (V)this.getPeakInboundSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.NON_PERSISTENT_OUTBOUND_SOCKETS) {
            return (V)this.getNonPersistentOutboundSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.PEAK_NON_PERSISTENT_OUTBOUND_SOCKETS) {
            return (V)this.getPeakNonPersistentOutboundSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.PERSISTENT_OUTBOUND_SOCKETS_COUNT) {
            return (V)this.getPersistentOutboundSocketsCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.PEAK_PERSISTENT_OUTBOUND_SOCKETS) {
            return (V)this.getPeakPersistentOutboundSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.INBOUND_SOCKETS_CREATED_COUNT) {
            return (V)this.getInboundSocketsCreatedCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.OUTBOUND_SOCKETS_CREATED_COUNT) {
            return (V)this.getOutboundSocketsCreatedCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.OUTBOUND_SOCKETS_CLOSED_COUNT) {
            return (V)this.getOutboundSocketsClosedCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.MAX_SOCKETS_REACHED_COUNT) {
            return (V)this.getMaxSocketsReachedCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.TOTAL_REQUESTS_DELAYED_AT_MAX_SOCKETS) {
            return (V)this.getTotalRequestsDelayedAtMaxSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.TOTAL_DELAY_TIME_AT_MAX_SOCKETS) {
            return (V)this.getTotalDelayTimeAtMaxSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.TIMEOUTS_AT_MAX_SOCKETS) {
            return (V)this.getTimeoutsAtMaxSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.REQUESTS_DELAYED_AT_MAX_SOCKETS) {
            return (V)this.getRequestsDelayedAtMaxSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.PEAK_REQUESTS_DELAYED_AT_MAX_SOCKETS) {
            return (V)this.getPeakRequestsDelayedAtMaxSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.DELAY_TIME_AT_MAX_SOCKETS) {
            return (V)this.getDelayTimeAtMaxSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.SSL_CACHE_TYPE) {
            return (V)this.getSSLCacheType();
        }
        if (attribute == GlobalTCPIPStatisticsType.CRL_SERVER_NAME) {
            return (V)this.getCRLServerName();
        }
        if (attribute == GlobalTCPIPStatisticsType.CRL_PROFILE_NAME) {
            return (V)this.getCRLProfileName();
        }
        if (attribute == GlobalTCPIPStatisticsType.SOTUNING) {
            return (V)this.getSotuning();
        }
        if (attribute == GlobalTCPIPStatisticsType.TASK_ACCEPT_LIMIT_COUNT) {
            return (V)this.getTaskAcceptLimitCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.LAST_SOCKET_LISTENER_PAUSED_TIME) {
            return (V)this.getLastSocketListenerPausedTime();
        }
        if (attribute == GlobalTCPIPStatisticsType.REGION_STOPPING_PERSISTENT) {
            return (V)this.getRegionStoppingPersistent();
        }
        if (attribute == GlobalTCPIPStatisticsType.REGION_STOPPED_PERSISTENCE_COUNT) {
            return (V)this.getRegionStoppedPersistenceCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.LAST_TIME_STOPPED_HTTP_PERSISTENCE) {
            return (V)this.getLastTimeStoppedHTTPPersistence();
        }
        if (attribute == GlobalTCPIPStatisticsType.PERSISTENT_MADE_NON_PERSISTENT_COUNT) {
            return (V)this.getPersistentMadeNonPersistentCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.DISCONNECTED_AT_MAX_USES_COUNT) {
            return (V)this.getDisconnectedAtMaxUsesCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.PAUSING_LIST) {
            return (V)this.getPausingList();
        }
        if (attribute == GlobalTCPIPStatisticsType.TOTAL_PERSISTENT_OUTBOUND_SOCKETS) {
            return (V)this.getTotalPersistentOutboundSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.PEAK_OUTBOUND_SOCKETS) {
            return (V)this.getPeakOutboundSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.PEAK_NON_PERSISTENT_INBOUND_SOCKETS) {
            return (V)this.getPeakNonPersistentInboundSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.NON_PERSISTENT_INBOUND_SOCKETS) {
            return (V)this.getNonPersistentInboundSockets();
        }
        if (attribute == GlobalTCPIPStatisticsType.TOTAL_NON_PERSISTENT_INBOUND_SOCKETS_CREATED) {
            return (V)this.getTotalNonPersistentInboundSocketsCreated();
        }
        if (attribute == GlobalTCPIPStatisticsType.OUTBOUND_SOCKETS_REUSED_COUNT) {
            return (V)this.getOutboundSocketsReusedCount();
        }
        if (attribute == GlobalTCPIPStatisticsType.PEAK_PERSISTENT_INBOUND_SOCKETS) {
            return (V)this.getPeakPersistentInboundSockets();
        }
        return super.getAttributeValue(attribute);
    }

    public GlobalTCPIPStatisticsType getObjectType() {
        return GlobalTCPIPStatisticsType.getInstance();
    }

    @Override
    public GlobalTCPIPStatisticsReference getCICSObjectReference() {
        return new GlobalTCPIPStatisticsReference(this.getCICSContainer());
    }
}

