/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.RegionReference;
import com.ibm.cics.core.model.RegionType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IRegion;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableRegion;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableRegion
extends MutableCICSResource
implements IMutableRegion {
    private IRegion delegate;
    private MutableSMRecord record;

    public MutableRegion(ICPSM cpsm, IContext context, IRegion cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("CICSRGN");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getJobName() {
        return this.delegate.getJobName();
    }

    public String getApplID() {
        return this.delegate.getApplID();
    }

    public String getMVSSystemID() {
        return this.delegate.getMVSSystemID();
    }

    public Long getAkp() {
        String result = this.record.get("AKP");
        if (result == null) {
            return this.delegate.getAkp();
        }
        return (Long)((CICSAttribute)RegionType.AKP).get(result, this.record.getNormalizers());
    }

    public Long getMaximumTasks() {
        String result = this.record.get("MAXTASKS");
        if (result == null) {
            return this.delegate.getMaximumTasks();
        }
        return (Long)((CICSAttribute)RegionType.MAXIMUM_TASKS).get(result, this.record.getNormalizers());
    }

    public IRegion.CICSStatusValue getCICSStatus() {
        return this.delegate.getCICSStatus();
    }

    public IRegion.SystemDumpStatusValue getSystemDumpStatus() {
        String result = this.record.get("SYSDUMP");
        if (result == null) {
            return this.delegate.getSystemDumpStatus();
        }
        return (IRegion.SystemDumpStatusValue)((CICSAttribute)RegionType.SYSTEM_DUMP_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.ExternalSecurityValue getExternalSecurity() {
        return this.delegate.getExternalSecurity();
    }

    public IRegion.StartupTypeValue getStartupType() {
        return this.delegate.getStartupType();
    }

    public IRegion.StorageProtectionValue getStorageProtection() {
        return this.delegate.getStorageProtection();
    }

    public String getDynamicRoutingProgram() {
        String result = this.record.get("DTRPROGRAM");
        if (result == null) {
            return this.delegate.getDynamicRoutingProgram();
        }
        return (String)((CICSAttribute)RegionType.DYNAMIC_ROUTING_PROGRAM).get(result, this.record.getNormalizers());
    }

    public String getGMMTransaction() {
        return this.delegate.getGMMTransaction();
    }

    public Long getMROBatchRequests() {
        String result = this.record.get("MROBATCH");
        if (result == null) {
            return this.delegate.getMROBatchRequests();
        }
        return (Long)((CICSAttribute)RegionType.MRO_BATCH_REQUESTS).get(result, this.record.getNormalizers());
    }

    public Long getOSRelease() {
        return this.delegate.getOSRelease();
    }

    public String getOS() {
        return this.delegate.getOS();
    }

    public String getOSCode() {
        return this.delegate.getOSCode();
    }

    public Long getPriorityAging() {
        String result = this.record.get("PRTYAGING");
        if (result == null) {
            return this.delegate.getPriorityAging();
        }
        return (Long)((CICSAttribute)RegionType.PRIORITY_AGING).get(result, this.record.getNormalizers());
    }

    public String getRelease() {
        return this.delegate.getRelease();
    }

    public Long getRunaway() {
        String result = this.record.get("RUNAWAY");
        if (result == null) {
            return this.delegate.getRunaway();
        }
        return (Long)((CICSAttribute)RegionType.RUNAWAY).get(result, this.record.getNormalizers());
    }

    public Long getScanDelay() {
        String result = this.record.get("SCANDELAY");
        if (result == null) {
            return this.delegate.getScanDelay();
        }
        return (Long)((CICSAttribute)RegionType.SCAN_DELAY).get(result, this.record.getNormalizers());
    }

    public Long getExitWaitTime() {
        String result = this.record.get("EXITTIME");
        if (result == null) {
            return this.delegate.getExitWaitTime();
        }
        return (Long)((CICSAttribute)RegionType.EXIT_WAIT_TIME).get(result, this.record.getNormalizers());
    }

    public IRegion.XRFStatusValue getXRFStatus() {
        return this.delegate.getXRFStatus();
    }

    public String getAutoinstallProgram() {
        String result = this.record.get("AINSPROG");
        if (result == null) {
            return this.delegate.getAutoinstallProgram();
        }
        return (String)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM).get(result, this.record.getNormalizers());
    }

    public Long getAutoinstallRequestCount() {
        return this.delegate.getAutoinstallRequestCount();
    }

    public Long getMaximumAutoinstallRequestCount() {
        String result = this.record.get("AINSMREQ");
        if (result == null) {
            return this.delegate.getMaximumAutoinstallRequestCount();
        }
        return (Long)((CICSAttribute)RegionType.MAXIMUM_AUTOINSTALL_REQUEST_COUNT).get(result, this.record.getNormalizers());
    }

    public IRegion.AutoinstallStatusValue getAutoinstallStatus() {
        return this.delegate.getAutoinstallStatus();
    }

    public IRegion.DumpDSSwitchTypeValue getDumpDSSwitchType() {
        String result = this.record.get("DDSOSTAT");
        if (result == null) {
            return this.delegate.getDumpDSSwitchType();
        }
        return (IRegion.DumpDSSwitchTypeValue)((CICSAttribute)RegionType.DUMP_DS_SWITCH_TYPE).get(result, this.record.getNormalizers());
    }

    public IRegion.DumpDSSwitchStatusValue getDumpDSSwitchStatus() {
        String result = this.record.get("DDSSSTAT");
        if (result == null) {
            return this.delegate.getDumpDSSwitchStatus();
        }
        return (IRegion.DumpDSSwitchStatusValue)((CICSAttribute)RegionType.DUMP_DS_SWITCH_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.IRCStatusValue getIRCStatus() {
        String result = this.record.get("IRCSTAT");
        if (result == null) {
            return this.delegate.getIRCStatus();
        }
        return (IRegion.IRCStatusValue)((CICSAttribute)RegionType.IRC_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.ExceptionMonitoringStatusValue getExceptionMonitoringStatus() {
        String result = this.record.get("EXCEPTCLASS");
        if (result == null) {
            return this.delegate.getExceptionMonitoringStatus();
        }
        return (IRegion.ExceptionMonitoringStatusValue)((CICSAttribute)RegionType.EXCEPTION_MONITORING_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.PerformanceMonitoringStatusValue getPerformanceMonitoringStatus() {
        String result = this.record.get("PERFCLASS");
        if (result == null) {
            return this.delegate.getPerformanceMonitoringStatus();
        }
        return (IRegion.PerformanceMonitoringStatusValue)((CICSAttribute)RegionType.PERFORMANCE_MONITORING_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.MonitoringStatusValue getMonitoringStatus() {
        String result = this.record.get("MONSTAT");
        if (result == null) {
            return this.delegate.getMonitoringStatus();
        }
        return (IRegion.MonitoringStatusValue)((CICSAttribute)RegionType.MONITORING_STATUS).get(result, this.record.getNormalizers());
    }

    public String getEODStatisticsTime() {
        String result = this.record.get("ENDOFDAY");
        if (result == null) {
            return this.delegate.getEODStatisticsTime();
        }
        return (String)((CICSAttribute)RegionType.EOD_STATISTICS_TIME).get(result, this.record.getNormalizers());
    }

    public String getStatisticsInterval() {
        String result = this.record.get("INTERVAL");
        if (result == null) {
            return this.delegate.getStatisticsInterval();
        }
        return (String)((CICSAttribute)RegionType.STATISTICS_INTERVAL).get(result, this.record.getNormalizers());
    }

    public String getNextStatisticsTime() {
        return this.delegate.getNextStatisticsTime();
    }

    public IRegion.StatisticsStatusValue getStatisticsStatus() {
        String result = this.record.get("RECORDING");
        if (result == null) {
            return this.delegate.getStatisticsStatus();
        }
        return (IRegion.StatisticsStatusValue)((CICSAttribute)RegionType.STATISTICS_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.AuxiliaryTraceStatusValue getAuxiliaryTraceStatus() {
        String result = this.record.get("AUXSTATUS");
        if (result == null) {
            return this.delegate.getAuxiliaryTraceStatus();
        }
        return (IRegion.AuxiliaryTraceStatusValue)((CICSAttribute)RegionType.AUXILIARY_TRACE_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.GTFTraceStatusValue getGTFTraceStatus() {
        String result = this.record.get("GTFSTATUS");
        if (result == null) {
            return this.delegate.getGTFTraceStatus();
        }
        return (IRegion.GTFTraceStatusValue)((CICSAttribute)RegionType.GTF_TRACE_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.InternalTraceStatusValue getInternalTraceStatus() {
        String result = this.record.get("INTSTATUS");
        if (result == null) {
            return this.delegate.getInternalTraceStatus();
        }
        return (IRegion.InternalTraceStatusValue)((CICSAttribute)RegionType.INTERNAL_TRACE_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.AuxiliaryTraceSwitchTypeValue getAuxiliaryTraceSwitchType() {
        String result = this.record.get("SWITCHSTATUS");
        if (result == null) {
            return this.delegate.getAuxiliaryTraceSwitchType();
        }
        return (IRegion.AuxiliaryTraceSwitchTypeValue)((CICSAttribute)RegionType.AUXILIARY_TRACE_SWITCH_TYPE).get(result, this.record.getNormalizers());
    }

    public Long getInternalTraceTableSize() {
        String result = this.record.get("TABLESIZE");
        if (result == null) {
            return this.delegate.getInternalTraceTableSize();
        }
        return (Long)((CICSAttribute)RegionType.INTERNAL_TRACE_TABLE_SIZE).get(result, this.record.getNormalizers());
    }

    public IRegion.SingleTraceStatusValue getSingleTraceStatus() {
        String result = this.record.get("SINGLESTATUS");
        if (result == null) {
            return this.delegate.getSingleTraceStatus();
        }
        return (IRegion.SingleTraceStatusValue)((CICSAttribute)RegionType.SINGLE_TRACE_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.SystemTraceStatusValue getSystemTraceStatus() {
        String result = this.record.get("SYSTEMSTATUS");
        if (result == null) {
            return this.delegate.getSystemTraceStatus();
        }
        return (IRegion.SystemTraceStatusValue)((CICSAttribute)RegionType.SYSTEM_TRACE_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.ExitTraceStatusValue getExitTraceStatus() {
        String result = this.record.get("TCEXITSTATUS");
        if (result == null) {
            return this.delegate.getExitTraceStatus();
        }
        return (IRegion.ExitTraceStatusValue)((CICSAttribute)RegionType.EXIT_TRACE_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.UserTraceStatusValue getUserTraceStatus() {
        String result = this.record.get("USERSTATUS");
        if (result == null) {
            return this.delegate.getUserTraceStatus();
        }
        return (IRegion.UserTraceStatusValue)((CICSAttribute)RegionType.USER_TRACE_STATUS).get(result, this.record.getNormalizers());
    }

    public String getLastResetTime() {
        return this.delegate.getLastResetTime();
    }

    public Long getPeakTaskCount() {
        return this.delegate.getPeakTaskCount();
    }

    public Long getLoaderRequestCount() {
        return this.delegate.getLoaderRequestCount();
    }

    public String getTotalLoadingTime() {
        return this.delegate.getTotalLoadingTime();
    }

    public Long getProgramRemoveCount() {
        return this.delegate.getProgramRemoveCount();
    }

    public Long getPrgmwait() {
        return this.delegate.getPrgmwait();
    }

    public Long getLoaderWaitCount() {
        return this.delegate.getLoaderWaitCount();
    }

    public Long getPeakLoaderWaitCount() {
        return this.delegate.getPeakLoaderWaitCount();
    }

    public Long getLoadhwmc() {
        return this.delegate.getLoadhwmc();
    }

    public String getTotalLoaderWaitTime() {
        return this.delegate.getTotalLoaderWaitTime();
    }

    public Long getRdebrbld() {
        return this.delegate.getRdebrbld();
    }

    public Long getPrgmrcmp() {
        return this.delegate.getPrgmrcmp();
    }

    public String getLoadtniu() {
        return this.delegate.getLoadtniu();
    }

    public Long getLoadpniu() {
        return this.delegate.getLoadpniu();
    }

    public Long getLoadrniu() {
        return this.delegate.getLoadrniu();
    }

    public Long getSysdumpsTakenCount() {
        return this.delegate.getSysdumpsTakenCount();
    }

    public Long getSysdumpsSuppressedCount() {
        return this.delegate.getSysdumpsSuppressedCount();
    }

    public Long getTrandumpsTakenCount() {
        return this.delegate.getTrandumpsTakenCount();
    }

    public Long getTrandumpsSuppressedCount() {
        return this.delegate.getTrandumpsSuppressedCount();
    }

    public Date getCICSStartTime() {
        return this.delegate.getCICSStartTime();
    }

    public String getCICSSystemID() {
        return this.delegate.getCICSSystemID();
    }

    public String getTotalCPU() {
        return this.delegate.getTotalCPU();
    }

    public Long getPageInCount() {
        return this.delegate.getPageInCount();
    }

    public Long getPageOutCount() {
        return this.delegate.getPageOutCount();
    }

    public Long getRealStorage() {
        return this.delegate.getRealStorage();
    }

    public Long getIOCount() {
        return this.delegate.getIOCount();
    }

    public IRegion.VTAMStatusValue getVTAMStatus() {
        String result = this.record.get("VTMSTATUS");
        if (result == null) {
            return this.delegate.getVTAMStatus();
        }
        return (IRegion.VTAMStatusValue)((CICSAttribute)RegionType.VTAM_STATUS).get(result, this.record.getNormalizers());
    }

    public String getVtmrplmax() {
        return this.delegate.getVtmrplmax();
    }

    public String getVtmrplpost() {
        return this.delegate.getVtmrplpost();
    }

    public Long getVtmsoscnt() {
        return this.delegate.getVtmsoscnt();
    }

    public Long getVtmacbdope() {
        return this.delegate.getVtmacbdope();
    }

    public String getCurrentDumpDS() {
        return this.delegate.getCurrentDumpDS();
    }

    public String getInitialDumpDS() {
        String result = this.record.get("INITIALDDS");
        if (result == null) {
            return this.delegate.getInitialDumpDS();
        }
        return (String)((CICSAttribute)RegionType.INITIAL_DUMP_DS).get(result, this.record.getNormalizers());
    }

    public String getCurrentAuxiliaryTraceDS() {
        return this.delegate.getCurrentAuxiliaryTraceDS();
    }

    public Long getLucurr() {
        return this.delegate.getLucurr();
    }

    public Long getLuhwm() {
        return this.delegate.getLuhwm();
    }

    public Long getPrssinqcnt() {
        return this.delegate.getPrssinqcnt();
    }

    public Long getPrssnibcnt() {
        return this.delegate.getPrssnibcnt();
    }

    public Long getPrssopncnt() {
        return this.delegate.getPrssopncnt();
    }

    public Long getPrssunbndcnt() {
        return this.delegate.getPrssunbndcnt();
    }

    public Long getPrsserrorcnt() {
        return this.delegate.getPrsserrorcnt();
    }

    public IRegion.ConversestValue getConversest() {
        String result = this.record.get("CONVERSEST");
        if (result == null) {
            return this.delegate.getConversest();
        }
        return (IRegion.ConversestValue)((CICSAttribute)RegionType.CONVERSEST).get(result, this.record.getNormalizers());
    }

    public String getFrequency() {
        String result = this.record.get("FREQUENCY");
        if (result == null) {
            return this.delegate.getFrequency();
        }
        return (String)((CICSAttribute)RegionType.FREQUENCY).get(result, this.record.getNormalizers());
    }

    public String getSubsystemid() {
        return this.delegate.getSubsystemid();
    }

    public IRegion.SyncpointstValue getSyncpointst() {
        String result = this.record.get("SYNCPOINTST");
        if (result == null) {
            return this.delegate.getSyncpointst();
        }
        return (IRegion.SyncpointstValue)((CICSAttribute)RegionType.SYNCPOINTST).get(result, this.record.getNormalizers());
    }

    public IRegion.MonrpttimeValue getMonrpttime() {
        return this.delegate.getMonrpttime();
    }

    public String getDefaultUserID() {
        return this.delegate.getDefaultUserID();
    }

    public String getAutoinstallProgramExit() {
        String result = this.record.get("PROGAUTOEXIT");
        if (result == null) {
            return this.delegate.getAutoinstallProgramExit();
        }
        return (String)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_EXIT).get(result, this.record.getNormalizers());
    }

    public IRegion.AutoinstallProgramCatalogTypeValue getAutoinstallProgramCatalogType() {
        String result = this.record.get("PROGAUTOCTLG");
        if (result == null) {
            return this.delegate.getAutoinstallProgramCatalogType();
        }
        return (IRegion.AutoinstallProgramCatalogTypeValue)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_CATALOG_TYPE).get(result, this.record.getNormalizers());
    }

    public IRegion.AutoinstallProgramStatusValue getAutoinstallProgramStatus() {
        String result = this.record.get("PROGAUTOINST");
        if (result == null) {
            return this.delegate.getAutoinstallProgramStatus();
        }
        return (IRegion.AutoinstallProgramStatusValue)((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.TransactionIsolationValue getTransactionIsolation() {
        return this.delegate.getTransactionIsolation();
    }

    public String getStartupDate() {
        return this.delegate.getStartupDate();
    }

    public String getPsdinterval() {
        String result = this.record.get("PSDINTERVAL");
        if (result == null) {
            return this.delegate.getPsdinterval();
        }
        return (String)((CICSAttribute)RegionType.PSDINTERVAL).get(result, this.record.getNormalizers());
    }

    public Long getTaskCount() {
        return this.delegate.getTaskCount();
    }

    public Long getMaximumTasksCount() {
        return this.delegate.getMaximumTasksCount();
    }

    public Long getUserTransactionCount() {
        return this.delegate.getUserTransactionCount();
    }

    public Long getQueuedTaskCount() {
        return this.delegate.getQueuedTaskCount();
    }

    public Long getPeakUserTransactionCount() {
        return this.delegate.getPeakUserTransactionCount();
    }

    public Long getPeakQueuedTaskCount() {
        return this.delegate.getPeakQueuedTaskCount();
    }

    public Long getTotactvusrtr() {
        return this.delegate.getTotactvusrtr();
    }

    public Long getTotdelyusrtr() {
        return this.delegate.getTotdelyusrtr();
    }

    public String getTotquetime() {
        return this.delegate.getTotquetime();
    }

    public String getCurquetime() {
        return this.delegate.getCurquetime();
    }

    public Long getAutoinstallProgramAttemptsCount() {
        return this.delegate.getAutoinstallProgramAttemptsCount();
    }

    public Long getAutoinstallProgramRejectsCount() {
        return this.delegate.getAutoinstallProgramRejectsCount();
    }

    public Long getAutoinstallProgramFailedAttemptsCount() {
        return this.delegate.getAutoinstallProgramFailedAttemptsCount();
    }

    public IRegion.InitializationStatusValue getInitializationStatus() {
        return this.delegate.getInitializationStatus();
    }

    public IRegion.ShutdownStatusValue getShutdownStatus() {
        return this.delegate.getShutdownStatus();
    }

    public Long getIntvtrans() {
        return this.delegate.getIntvtrans();
    }

    public String getGMMText() {
        String result = this.record.get("GMMTEXT");
        if (result == null) {
            return this.delegate.getGMMText();
        }
        return (String)((CICSAttribute)RegionType.GMM_TEXT).get(result, this.record.getNormalizers());
    }

    public Long getGMMLength() {
        return this.delegate.getGMMLength();
    }

    public String getGrname() {
        return this.delegate.getGrname();
    }

    public IRegion.GrstatusValue getGrstatus() {
        String result = this.record.get("GRSTATUS");
        if (result == null) {
            return this.delegate.getGrstatus();
        }
        return (IRegion.GrstatusValue)((CICSAttribute)RegionType.GRSTATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.ReentrantProgramProtectionStatusValue getReentrantProgramProtectionStatus() {
        return this.delegate.getReentrantProgramProtectionStatus();
    }

    public IRegion.CommandProtectionStatusValue getCommandProtectionStatus() {
        return this.delegate.getCommandProtectionStatus();
    }

    public IRegion.SOSBelowBarValue getSOSBelowBar() {
        return this.delegate.getSOSBelowBar();
    }

    public Long getTotalTaskCount() {
        return this.delegate.getTotalTaskCount();
    }

    public IRegion.RLSStatusValue getRLSStatus() {
        return this.delegate.getRLSStatus();
    }

    public String getShutdownTransaction() {
        return this.delegate.getShutdownTransaction();
    }

    public String getDsidle() {
        String result = this.record.get("DSIDLE");
        if (result == null) {
            return this.delegate.getDsidle();
        }
        return (String)((CICSAttribute)RegionType.DSIDLE).get(result, this.record.getNormalizers());
    }

    public String getDsinterval() {
        String result = this.record.get("DSINTERVAL");
        if (result == null) {
            return this.delegate.getDsinterval();
        }
        return (String)((CICSAttribute)RegionType.DSINTERVAL).get(result, this.record.getNormalizers());
    }

    public String getCICSTSLevel() {
        return this.delegate.getCICSTSLevel();
    }

    public String getOSLevel() {
        return this.delegate.getOSLevel();
    }

    public IRegion.RrmsstatValue getRrmsstat() {
        return this.delegate.getRrmsstat();
    }

    public String getMvssysname() {
        return this.delegate.getMvssysname();
    }

    public IRegion.ForceqrValue getForceqr() {
        String result = this.record.get("FORCEQR");
        if (result == null) {
            return this.delegate.getForceqr();
        }
        return (IRegion.ForceqrValue)((CICSAttribute)RegionType.FORCEQR).get(result, this.record.getNormalizers());
    }

    public Long getMaximumOpenTCBCount() {
        String result = this.record.get("MAXOPENTCBS");
        if (result == null) {
            return this.delegate.getMaximumOpenTCBCount();
        }
        return (Long)((CICSAttribute)RegionType.MAXIMUM_OPEN_TCB_COUNT).get(result, this.record.getNormalizers());
    }

    public Long getCurrentOpenPoolTCBCount() {
        return this.delegate.getCurrentOpenPoolTCBCount();
    }

    public String getDistributedRoutingProgram() {
        String result = this.record.get("DSRTPROGRAM");
        if (result == null) {
            return this.delegate.getDistributedRoutingProgram();
        }
        return (String)((CICSAttribute)RegionType.DISTRIBUTED_ROUTING_PROGRAM).get(result, this.record.getNormalizers());
    }

    public IRegion.AutoinstallConsoleStatusValue getAutoinstallConsoleStatus() {
        String result = this.record.get("CONSOLES");
        if (result == null) {
            return this.delegate.getAutoinstallConsoleStatus();
        }
        return (IRegion.AutoinstallConsoleStatusValue)((CICSAttribute)RegionType.AUTOINSTALL_CONSOLE_STATUS).get(result, this.record.getNormalizers());
    }

    public IRegion.TCPIPStatusValue getTCPIPStatus() {
        String result = this.record.get("TCPIP");
        if (result == null) {
            return this.delegate.getTCPIPStatus();
        }
        return (IRegion.TCPIPStatusValue)((CICSAttribute)RegionType.TCPIP_STATUS).get(result, this.record.getNormalizers());
    }

    public Long getGarbageint() {
        String result = this.record.get("GARBAGEINT");
        if (result == null) {
            return this.delegate.getGarbageint();
        }
        return (Long)((CICSAttribute)RegionType.GARBAGEINT).get(result, this.record.getNormalizers());
    }

    public Long getTimeoutint() {
        String result = this.record.get("TIMEOUTINT");
        if (result == null) {
            return this.delegate.getTimeoutint();
        }
        return (Long)((CICSAttribute)RegionType.TIMEOUTINT).get(result, this.record.getNormalizers());
    }

    public IRegion.ColdstatusValue getColdstatus() {
        return this.delegate.getColdstatus();
    }

    public Long getMaximumHPPoolTCBCount() {
        String result = this.record.get("MAXHPTCBS");
        if (result == null) {
            return this.delegate.getMaximumHPPoolTCBCount();
        }
        return (Long)((CICSAttribute)RegionType.MAXIMUM_HP_POOL_TCB_COUNT).get(result, this.record.getNormalizers());
    }

    public Long getCurrentHPPoolTCBCount() {
        return this.delegate.getCurrentHPPoolTCBCount();
    }

    public Long getMaximumJVMPoolTCBCount() {
        String result = this.record.get("MAXJVMTCBS");
        if (result == null) {
            return this.delegate.getMaximumJVMPoolTCBCount();
        }
        return (Long)((CICSAttribute)RegionType.MAXIMUM_JVM_POOL_TCB_COUNT).get(result, this.record.getNormalizers());
    }

    public Long getCurrentJVMPoolTCBCount() {
        return this.delegate.getCurrentJVMPoolTCBCount();
    }

    public Long getSubtasks() {
        return this.delegate.getSubtasks();
    }

    public IRegion.DebugToolValue getDebugTool() {
        String result = this.record.get("DEBUGTOOL");
        if (result == null) {
            return this.delegate.getDebugTool();
        }
        return (IRegion.DebugToolValue)((CICSAttribute)RegionType.DEBUG_TOOL).get(result, this.record.getNormalizers());
    }

    public Long getMaximumXPLinkPoolTCBCount() {
        String result = this.record.get("MAXXPTCBS");
        if (result == null) {
            return this.delegate.getMaximumXPLinkPoolTCBCount();
        }
        return (Long)((CICSAttribute)RegionType.MAXIMUM_XP_LINK_POOL_TCB_COUNT).get(result, this.record.getNormalizers());
    }

    public Long getCurrentXPLinkPoolTCBCount() {
        return this.delegate.getCurrentXPLinkPoolTCBCount();
    }

    public Long getMaximumSSLPoolTCBCount() {
        String result = this.record.get("MAXSSLTCBS");
        if (result == null) {
            return this.delegate.getMaximumSSLPoolTCBCount();
        }
        return (Long)((CICSAttribute)RegionType.MAXIMUM_SSL_POOL_TCB_COUNT).get(result, this.record.getNormalizers());
    }

    public Long getCurrentSSLPoolTCBCount() {
        return this.delegate.getCurrentSSLPoolTCBCount();
    }

    public String getXcfgroup() {
        return this.delegate.getXcfgroup();
    }

    public Long getStorageLimit() {
        return this.delegate.getStorageLimit();
    }

    public IRegion.SOSAboveBarValue getSOSAboveBar() {
        return this.delegate.getSOSAboveBar();
    }

    public IRegion.SOSAboveLineValue getSOSAboveLine() {
        return this.delegate.getSOSAboveLine();
    }

    public IRegion.SOSBelowLineValue getSOSBelowLine() {
        return this.delegate.getSOSBelowLine();
    }

    public Long getLdglbsou() {
        return this.delegate.getLdglbsou();
    }

    public Long getLdglwsou() {
        return this.delegate.getLdglwsou();
    }

    public Long getLdglsort() {
        return this.delegate.getLdglsort();
    }

    public IRegion.PstypeValue getPstype() {
        return this.delegate.getPstype();
    }

    public IRegion.IdntyclassValue getIdntyclass() {
        String result = this.record.get("IDNTYCLASS");
        if (result == null) {
            return this.delegate.getIdntyclass();
        }
        return (IRegion.IdntyclassValue)((CICSAttribute)RegionType.IDNTYCLASS).get(result, this.record.getNormalizers());
    }

    public Long getCurrentJVMServerThreadTCBCount() {
        return this.delegate.getCurrentJVMServerThreadTCBCount();
    }

    public Long getMaximumJVMServerThreadCount() {
        return this.delegate.getMaximumJVMServerThreadCount();
    }

    public String getJobid() {
        return this.delegate.getJobid();
    }

    public Date getMAXTASKSLastChangedTime() {
        return this.delegate.getMAXTASKSLastChangedTime();
    }

    public Date getLastTransactionAttachedTime() {
        return this.delegate.getLastTransactionAttachedTime();
    }

    public Date getMAXTASKSLimitLastReachedTime() {
        return this.delegate.getMAXTASKSLimitLastReachedTime();
    }

    public IRegion.CurrentlyAtMXTValue getCurrentlyAtMXT() {
        return this.delegate.getCurrentlyAtMXT();
    }

    public String getRegionUserID() {
        return this.delegate.getRegionUserID();
    }

    public String getBmsvalidate() {
        return this.delegate.getBmsvalidate();
    }

    public Long getBmsvaligcnt() {
        return this.delegate.getBmsvaligcnt();
    }

    public Long getBmsvallgcnt() {
        return this.delegate.getBmsvallgcnt();
    }

    public Long getBmsvalabcnt() {
        return this.delegate.getBmsvalabcnt();
    }

    public String getPLTPIUser() {
        return this.delegate.getPLTPIUser();
    }

    public Long getAIDCount() {
        return this.delegate.getAIDCount();
    }

    public Date getLastColdStart() {
        return this.delegate.getLastColdStart();
    }

    public Date getLastEmergencyStart() {
        return this.delegate.getLastEmergencyStart();
    }

    public Date getLastInitialStart() {
        return this.delegate.getLastInitialStart();
    }

    public Date getLastWarmStart() {
        return this.delegate.getLastWarmStart();
    }

    public void setAkp(Long _akp) {
        if (_akp.equals(this.delegate.getAkp())) {
            this.record.set("AKP", null);
        } else {
            RegionType.AKP.validate((Object)_akp);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.AKP).set(_akp, this.record.getNormalizers());
            this.record.set("AKP", connectionSpecificExternalValue);
        }
    }

    public void setMaximumTasks(Long _maximumTasks) {
        if (_maximumTasks.equals(this.delegate.getMaximumTasks())) {
            this.record.set("MAXTASKS", null);
        } else {
            RegionType.MAXIMUM_TASKS.validate((Object)_maximumTasks);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.MAXIMUM_TASKS).set(_maximumTasks, this.record.getNormalizers());
            this.record.set("MAXTASKS", connectionSpecificExternalValue);
        }
    }

    public void setSystemDumpStatus(IRegion.SystemDumpStatusValue _systemDumpStatus) {
        if (_systemDumpStatus.equals((Object)this.delegate.getSystemDumpStatus())) {
            this.record.set("SYSDUMP", null);
        } else {
            RegionType.SYSTEM_DUMP_STATUS.validate((Object)_systemDumpStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.SYSTEM_DUMP_STATUS).set(_systemDumpStatus, this.record.getNormalizers());
            this.record.set("SYSDUMP", connectionSpecificExternalValue);
        }
    }

    public void setDynamicRoutingProgram(String _dynamicRoutingProgram) {
        if (_dynamicRoutingProgram.equals(this.delegate.getDynamicRoutingProgram())) {
            this.record.set("DTRPROGRAM", null);
        } else {
            RegionType.DYNAMIC_ROUTING_PROGRAM.validate((Object)_dynamicRoutingProgram);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.DYNAMIC_ROUTING_PROGRAM).set(_dynamicRoutingProgram, this.record.getNormalizers());
            this.record.set("DTRPROGRAM", connectionSpecificExternalValue);
        }
    }

    public void setMROBatchRequests(Long _MROBatchRequests) {
        if (_MROBatchRequests.equals(this.delegate.getMROBatchRequests())) {
            this.record.set("MROBATCH", null);
        } else {
            RegionType.MRO_BATCH_REQUESTS.validate((Object)_MROBatchRequests);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.MRO_BATCH_REQUESTS).set(_MROBatchRequests, this.record.getNormalizers());
            this.record.set("MROBATCH", connectionSpecificExternalValue);
        }
    }

    public void setPriorityAging(Long _priorityAging) {
        if (_priorityAging.equals(this.delegate.getPriorityAging())) {
            this.record.set("PRTYAGING", null);
        } else {
            RegionType.PRIORITY_AGING.validate((Object)_priorityAging);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.PRIORITY_AGING).set(_priorityAging, this.record.getNormalizers());
            this.record.set("PRTYAGING", connectionSpecificExternalValue);
        }
    }

    public void setRunaway(Long _runaway) {
        if (_runaway.equals(this.delegate.getRunaway())) {
            this.record.set("RUNAWAY", null);
        } else {
            RegionType.RUNAWAY.validate((Object)_runaway);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.RUNAWAY).set(_runaway, this.record.getNormalizers());
            this.record.set("RUNAWAY", connectionSpecificExternalValue);
        }
    }

    public void setScanDelay(Long _scanDelay) {
        if (_scanDelay.equals(this.delegate.getScanDelay())) {
            this.record.set("SCANDELAY", null);
        } else {
            RegionType.SCAN_DELAY.validate((Object)_scanDelay);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.SCAN_DELAY).set(_scanDelay, this.record.getNormalizers());
            this.record.set("SCANDELAY", connectionSpecificExternalValue);
        }
    }

    public void setExitWaitTime(Long _exitWaitTime) {
        if (_exitWaitTime.equals(this.delegate.getExitWaitTime())) {
            this.record.set("EXITTIME", null);
        } else {
            RegionType.EXIT_WAIT_TIME.validate((Object)_exitWaitTime);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.EXIT_WAIT_TIME).set(_exitWaitTime, this.record.getNormalizers());
            this.record.set("EXITTIME", connectionSpecificExternalValue);
        }
    }

    public void setAutoinstallProgram(String _autoinstallProgram) {
        if (_autoinstallProgram.equals(this.delegate.getAutoinstallProgram())) {
            this.record.set("AINSPROG", null);
        } else {
            RegionType.AUTOINSTALL_PROGRAM.validate((Object)_autoinstallProgram);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM).set(_autoinstallProgram, this.record.getNormalizers());
            this.record.set("AINSPROG", connectionSpecificExternalValue);
        }
    }

    public void setMaximumAutoinstallRequestCount(Long _maximumAutoinstallRequestCount) {
        if (_maximumAutoinstallRequestCount.equals(this.delegate.getMaximumAutoinstallRequestCount())) {
            this.record.set("AINSMREQ", null);
        } else {
            RegionType.MAXIMUM_AUTOINSTALL_REQUEST_COUNT.validate((Object)_maximumAutoinstallRequestCount);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.MAXIMUM_AUTOINSTALL_REQUEST_COUNT).set(_maximumAutoinstallRequestCount, this.record.getNormalizers());
            this.record.set("AINSMREQ", connectionSpecificExternalValue);
        }
    }

    public void setDumpDSSwitchType(IRegion.DumpDSSwitchTypeValue _dumpDSSwitchType) {
        if (_dumpDSSwitchType.equals((Object)this.delegate.getDumpDSSwitchType())) {
            this.record.set("DDSOSTAT", null);
        } else {
            RegionType.DUMP_DS_SWITCH_TYPE.validate((Object)_dumpDSSwitchType);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.DUMP_DS_SWITCH_TYPE).set(_dumpDSSwitchType, this.record.getNormalizers());
            this.record.set("DDSOSTAT", connectionSpecificExternalValue);
        }
    }

    public void setDumpDSSwitchStatus(IRegion.DumpDSSwitchStatusValue _dumpDSSwitchStatus) {
        if (_dumpDSSwitchStatus.equals((Object)this.delegate.getDumpDSSwitchStatus())) {
            this.record.set("DDSSSTAT", null);
        } else {
            RegionType.DUMP_DS_SWITCH_STATUS.validate((Object)_dumpDSSwitchStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.DUMP_DS_SWITCH_STATUS).set(_dumpDSSwitchStatus, this.record.getNormalizers());
            this.record.set("DDSSSTAT", connectionSpecificExternalValue);
        }
    }

    public void setIRCStatus(IRegion.IRCStatusValue _IRCStatus) {
        if (_IRCStatus.equals((Object)this.delegate.getIRCStatus())) {
            this.record.set("IRCSTAT", null);
        } else {
            RegionType.IRC_STATUS.validate((Object)_IRCStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.IRC_STATUS).set(_IRCStatus, this.record.getNormalizers());
            this.record.set("IRCSTAT", connectionSpecificExternalValue);
        }
    }

    public void setExceptionMonitoringStatus(IRegion.ExceptionMonitoringStatusValue _exceptionMonitoringStatus) {
        if (_exceptionMonitoringStatus.equals((Object)this.delegate.getExceptionMonitoringStatus())) {
            this.record.set("EXCEPTCLASS", null);
        } else {
            RegionType.EXCEPTION_MONITORING_STATUS.validate((Object)_exceptionMonitoringStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.EXCEPTION_MONITORING_STATUS).set(_exceptionMonitoringStatus, this.record.getNormalizers());
            this.record.set("EXCEPTCLASS", connectionSpecificExternalValue);
        }
    }

    public void setPerformanceMonitoringStatus(IRegion.PerformanceMonitoringStatusValue _performanceMonitoringStatus) {
        if (_performanceMonitoringStatus.equals((Object)this.delegate.getPerformanceMonitoringStatus())) {
            this.record.set("PERFCLASS", null);
        } else {
            RegionType.PERFORMANCE_MONITORING_STATUS.validate((Object)_performanceMonitoringStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.PERFORMANCE_MONITORING_STATUS).set(_performanceMonitoringStatus, this.record.getNormalizers());
            this.record.set("PERFCLASS", connectionSpecificExternalValue);
        }
    }

    public void setMonitoringStatus(IRegion.MonitoringStatusValue _monitoringStatus) {
        if (_monitoringStatus.equals((Object)this.delegate.getMonitoringStatus())) {
            this.record.set("MONSTAT", null);
        } else {
            RegionType.MONITORING_STATUS.validate((Object)_monitoringStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.MONITORING_STATUS).set(_monitoringStatus, this.record.getNormalizers());
            this.record.set("MONSTAT", connectionSpecificExternalValue);
        }
    }

    public void setEODStatisticsTime(String _EODStatisticsTime) {
        if (_EODStatisticsTime.equals(this.delegate.getEODStatisticsTime())) {
            this.record.set("ENDOFDAY", null);
        } else {
            RegionType.EOD_STATISTICS_TIME.validate((Object)_EODStatisticsTime);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.EOD_STATISTICS_TIME).set(_EODStatisticsTime, this.record.getNormalizers());
            this.record.set("ENDOFDAY", connectionSpecificExternalValue);
        }
    }

    public void setStatisticsInterval(String _statisticsInterval) {
        if (_statisticsInterval.equals(this.delegate.getStatisticsInterval())) {
            this.record.set("INTERVAL", null);
        } else {
            RegionType.STATISTICS_INTERVAL.validate((Object)_statisticsInterval);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.STATISTICS_INTERVAL).set(_statisticsInterval, this.record.getNormalizers());
            this.record.set("INTERVAL", connectionSpecificExternalValue);
        }
    }

    public void setStatisticsStatus(IRegion.StatisticsStatusValue _statisticsStatus) {
        if (_statisticsStatus.equals((Object)this.delegate.getStatisticsStatus())) {
            this.record.set("RECORDING", null);
        } else {
            RegionType.STATISTICS_STATUS.validate((Object)_statisticsStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.STATISTICS_STATUS).set(_statisticsStatus, this.record.getNormalizers());
            this.record.set("RECORDING", connectionSpecificExternalValue);
        }
    }

    public void setAuxiliaryTraceStatus(IRegion.AuxiliaryTraceStatusValue _auxiliaryTraceStatus) {
        if (_auxiliaryTraceStatus.equals((Object)this.delegate.getAuxiliaryTraceStatus())) {
            this.record.set("AUXSTATUS", null);
        } else {
            RegionType.AUXILIARY_TRACE_STATUS.validate((Object)_auxiliaryTraceStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.AUXILIARY_TRACE_STATUS).set(_auxiliaryTraceStatus, this.record.getNormalizers());
            this.record.set("AUXSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setGTFTraceStatus(IRegion.GTFTraceStatusValue _GTFTraceStatus) {
        if (_GTFTraceStatus.equals((Object)this.delegate.getGTFTraceStatus())) {
            this.record.set("GTFSTATUS", null);
        } else {
            RegionType.GTF_TRACE_STATUS.validate((Object)_GTFTraceStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.GTF_TRACE_STATUS).set(_GTFTraceStatus, this.record.getNormalizers());
            this.record.set("GTFSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setInternalTraceStatus(IRegion.InternalTraceStatusValue _internalTraceStatus) {
        if (_internalTraceStatus.equals((Object)this.delegate.getInternalTraceStatus())) {
            this.record.set("INTSTATUS", null);
        } else {
            RegionType.INTERNAL_TRACE_STATUS.validate((Object)_internalTraceStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.INTERNAL_TRACE_STATUS).set(_internalTraceStatus, this.record.getNormalizers());
            this.record.set("INTSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setAuxiliaryTraceSwitchType(IRegion.AuxiliaryTraceSwitchTypeValue _auxiliaryTraceSwitchType) {
        if (_auxiliaryTraceSwitchType.equals((Object)this.delegate.getAuxiliaryTraceSwitchType())) {
            this.record.set("SWITCHSTATUS", null);
        } else {
            RegionType.AUXILIARY_TRACE_SWITCH_TYPE.validate((Object)_auxiliaryTraceSwitchType);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.AUXILIARY_TRACE_SWITCH_TYPE).set(_auxiliaryTraceSwitchType, this.record.getNormalizers());
            this.record.set("SWITCHSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setInternalTraceTableSize(Long _internalTraceTableSize) {
        if (_internalTraceTableSize.equals(this.delegate.getInternalTraceTableSize())) {
            this.record.set("TABLESIZE", null);
        } else {
            RegionType.INTERNAL_TRACE_TABLE_SIZE.validate((Object)_internalTraceTableSize);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.INTERNAL_TRACE_TABLE_SIZE).set(_internalTraceTableSize, this.record.getNormalizers());
            this.record.set("TABLESIZE", connectionSpecificExternalValue);
        }
    }

    public void setSingleTraceStatus(IRegion.SingleTraceStatusValue _singleTraceStatus) {
        if (_singleTraceStatus.equals((Object)this.delegate.getSingleTraceStatus())) {
            this.record.set("SINGLESTATUS", null);
        } else {
            RegionType.SINGLE_TRACE_STATUS.validate((Object)_singleTraceStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.SINGLE_TRACE_STATUS).set(_singleTraceStatus, this.record.getNormalizers());
            this.record.set("SINGLESTATUS", connectionSpecificExternalValue);
        }
    }

    public void setSystemTraceStatus(IRegion.SystemTraceStatusValue _systemTraceStatus) {
        if (_systemTraceStatus.equals((Object)this.delegate.getSystemTraceStatus())) {
            this.record.set("SYSTEMSTATUS", null);
        } else {
            RegionType.SYSTEM_TRACE_STATUS.validate((Object)_systemTraceStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.SYSTEM_TRACE_STATUS).set(_systemTraceStatus, this.record.getNormalizers());
            this.record.set("SYSTEMSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setExitTraceStatus(IRegion.ExitTraceStatusValue _exitTraceStatus) {
        if (_exitTraceStatus.equals((Object)this.delegate.getExitTraceStatus())) {
            this.record.set("TCEXITSTATUS", null);
        } else {
            RegionType.EXIT_TRACE_STATUS.validate((Object)_exitTraceStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.EXIT_TRACE_STATUS).set(_exitTraceStatus, this.record.getNormalizers());
            this.record.set("TCEXITSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setUserTraceStatus(IRegion.UserTraceStatusValue _userTraceStatus) {
        if (_userTraceStatus.equals((Object)this.delegate.getUserTraceStatus())) {
            this.record.set("USERSTATUS", null);
        } else {
            RegionType.USER_TRACE_STATUS.validate((Object)_userTraceStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.USER_TRACE_STATUS).set(_userTraceStatus, this.record.getNormalizers());
            this.record.set("USERSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setVTAMStatus(IRegion.VTAMStatusValue _VTAMStatus) {
        if (_VTAMStatus.equals((Object)this.delegate.getVTAMStatus())) {
            this.record.set("VTMSTATUS", null);
        } else {
            RegionType.VTAM_STATUS.validate((Object)_VTAMStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.VTAM_STATUS).set(_VTAMStatus, this.record.getNormalizers());
            this.record.set("VTMSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setInitialDumpDS(String _initialDumpDS) {
        if (_initialDumpDS.equals(this.delegate.getInitialDumpDS())) {
            this.record.set("INITIALDDS", null);
        } else {
            RegionType.INITIAL_DUMP_DS.validate((Object)_initialDumpDS);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.INITIAL_DUMP_DS).set(_initialDumpDS, this.record.getNormalizers());
            this.record.set("INITIALDDS", connectionSpecificExternalValue);
        }
    }

    public void setConversest(IRegion.ConversestValue _conversest) {
        if (_conversest.equals((Object)this.delegate.getConversest())) {
            this.record.set("CONVERSEST", null);
        } else {
            RegionType.CONVERSEST.validate((Object)_conversest);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.CONVERSEST).set(_conversest, this.record.getNormalizers());
            this.record.set("CONVERSEST", connectionSpecificExternalValue);
        }
    }

    public void setFrequency(String _frequency) {
        if (_frequency.equals(this.delegate.getFrequency())) {
            this.record.set("FREQUENCY", null);
        } else {
            RegionType.FREQUENCY.validate((Object)_frequency);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.FREQUENCY).set(_frequency, this.record.getNormalizers());
            this.record.set("FREQUENCY", connectionSpecificExternalValue);
        }
    }

    public void setSyncpointst(IRegion.SyncpointstValue _syncpointst) {
        if (_syncpointst.equals((Object)this.delegate.getSyncpointst())) {
            this.record.set("SYNCPOINTST", null);
        } else {
            RegionType.SYNCPOINTST.validate((Object)_syncpointst);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.SYNCPOINTST).set(_syncpointst, this.record.getNormalizers());
            this.record.set("SYNCPOINTST", connectionSpecificExternalValue);
        }
    }

    public void setAutoinstallProgramExit(String _autoinstallProgramExit) {
        if (_autoinstallProgramExit.equals(this.delegate.getAutoinstallProgramExit())) {
            this.record.set("PROGAUTOEXIT", null);
        } else {
            RegionType.AUTOINSTALL_PROGRAM_EXIT.validate((Object)_autoinstallProgramExit);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_EXIT).set(_autoinstallProgramExit, this.record.getNormalizers());
            this.record.set("PROGAUTOEXIT", connectionSpecificExternalValue);
        }
    }

    public void setAutoinstallProgramCatalogType(IRegion.AutoinstallProgramCatalogTypeValue _autoinstallProgramCatalogType) {
        if (_autoinstallProgramCatalogType.equals((Object)this.delegate.getAutoinstallProgramCatalogType())) {
            this.record.set("PROGAUTOCTLG", null);
        } else {
            RegionType.AUTOINSTALL_PROGRAM_CATALOG_TYPE.validate((Object)_autoinstallProgramCatalogType);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_CATALOG_TYPE).set(_autoinstallProgramCatalogType, this.record.getNormalizers());
            this.record.set("PROGAUTOCTLG", connectionSpecificExternalValue);
        }
    }

    public void setAutoinstallProgramStatus(IRegion.AutoinstallProgramStatusValue _autoinstallProgramStatus) {
        if (_autoinstallProgramStatus.equals((Object)this.delegate.getAutoinstallProgramStatus())) {
            this.record.set("PROGAUTOINST", null);
        } else {
            RegionType.AUTOINSTALL_PROGRAM_STATUS.validate((Object)_autoinstallProgramStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.AUTOINSTALL_PROGRAM_STATUS).set(_autoinstallProgramStatus, this.record.getNormalizers());
            this.record.set("PROGAUTOINST", connectionSpecificExternalValue);
        }
    }

    public void setPsdinterval(String _psdinterval) {
        if (_psdinterval.equals(this.delegate.getPsdinterval())) {
            this.record.set("PSDINTERVAL", null);
        } else {
            RegionType.PSDINTERVAL.validate((Object)_psdinterval);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.PSDINTERVAL).set(_psdinterval, this.record.getNormalizers());
            this.record.set("PSDINTERVAL", connectionSpecificExternalValue);
        }
    }

    public void setGMMText(String _GMMText) {
        if (_GMMText.equals(this.delegate.getGMMText())) {
            this.record.set("GMMTEXT", null);
        } else {
            RegionType.GMM_TEXT.validate((Object)_GMMText);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.GMM_TEXT).set(_GMMText, this.record.getNormalizers());
            this.record.set("GMMTEXT", connectionSpecificExternalValue);
        }
    }

    public void setGrstatus(IRegion.GrstatusValue _grstatus) {
        if (_grstatus.equals((Object)this.delegate.getGrstatus())) {
            this.record.set("GRSTATUS", null);
        } else {
            RegionType.GRSTATUS.validate((Object)_grstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.GRSTATUS).set(_grstatus, this.record.getNormalizers());
            this.record.set("GRSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setDsidle(String _dsidle) {
        if (_dsidle.equals(this.delegate.getDsidle())) {
            this.record.set("DSIDLE", null);
        } else {
            RegionType.DSIDLE.validate((Object)_dsidle);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.DSIDLE).set(_dsidle, this.record.getNormalizers());
            this.record.set("DSIDLE", connectionSpecificExternalValue);
        }
    }

    public void setDsinterval(String _dsinterval) {
        if (_dsinterval.equals(this.delegate.getDsinterval())) {
            this.record.set("DSINTERVAL", null);
        } else {
            RegionType.DSINTERVAL.validate((Object)_dsinterval);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.DSINTERVAL).set(_dsinterval, this.record.getNormalizers());
            this.record.set("DSINTERVAL", connectionSpecificExternalValue);
        }
    }

    public void setForceqr(IRegion.ForceqrValue _forceqr) {
        if (_forceqr.equals((Object)this.delegate.getForceqr())) {
            this.record.set("FORCEQR", null);
        } else {
            RegionType.FORCEQR.validate((Object)_forceqr);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.FORCEQR).set(_forceqr, this.record.getNormalizers());
            this.record.set("FORCEQR", connectionSpecificExternalValue);
        }
    }

    public void setMaximumOpenTCBCount(Long _maximumOpenTCBCount) {
        if (_maximumOpenTCBCount.equals(this.delegate.getMaximumOpenTCBCount())) {
            this.record.set("MAXOPENTCBS", null);
        } else {
            RegionType.MAXIMUM_OPEN_TCB_COUNT.validate((Object)_maximumOpenTCBCount);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.MAXIMUM_OPEN_TCB_COUNT).set(_maximumOpenTCBCount, this.record.getNormalizers());
            this.record.set("MAXOPENTCBS", connectionSpecificExternalValue);
        }
    }

    public void setDistributedRoutingProgram(String _distributedRoutingProgram) {
        if (_distributedRoutingProgram.equals(this.delegate.getDistributedRoutingProgram())) {
            this.record.set("DSRTPROGRAM", null);
        } else {
            RegionType.DISTRIBUTED_ROUTING_PROGRAM.validate((Object)_distributedRoutingProgram);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.DISTRIBUTED_ROUTING_PROGRAM).set(_distributedRoutingProgram, this.record.getNormalizers());
            this.record.set("DSRTPROGRAM", connectionSpecificExternalValue);
        }
    }

    public void setAutoinstallConsoleStatus(IRegion.AutoinstallConsoleStatusValue _autoinstallConsoleStatus) {
        if (_autoinstallConsoleStatus.equals((Object)this.delegate.getAutoinstallConsoleStatus())) {
            this.record.set("CONSOLES", null);
        } else {
            RegionType.AUTOINSTALL_CONSOLE_STATUS.validate((Object)_autoinstallConsoleStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.AUTOINSTALL_CONSOLE_STATUS).set(_autoinstallConsoleStatus, this.record.getNormalizers());
            this.record.set("CONSOLES", connectionSpecificExternalValue);
        }
    }

    public void setTCPIPStatus(IRegion.TCPIPStatusValue _TCPIPStatus) {
        if (_TCPIPStatus.equals((Object)this.delegate.getTCPIPStatus())) {
            this.record.set("TCPIP", null);
        } else {
            RegionType.TCPIP_STATUS.validate((Object)_TCPIPStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.TCPIP_STATUS).set(_TCPIPStatus, this.record.getNormalizers());
            this.record.set("TCPIP", connectionSpecificExternalValue);
        }
    }

    public void setGarbageint(Long _garbageint) {
        if (_garbageint.equals(this.delegate.getGarbageint())) {
            this.record.set("GARBAGEINT", null);
        } else {
            RegionType.GARBAGEINT.validate((Object)_garbageint);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.GARBAGEINT).set(_garbageint, this.record.getNormalizers());
            this.record.set("GARBAGEINT", connectionSpecificExternalValue);
        }
    }

    public void setTimeoutint(Long _timeoutint) {
        if (_timeoutint.equals(this.delegate.getTimeoutint())) {
            this.record.set("TIMEOUTINT", null);
        } else {
            RegionType.TIMEOUTINT.validate((Object)_timeoutint);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.TIMEOUTINT).set(_timeoutint, this.record.getNormalizers());
            this.record.set("TIMEOUTINT", connectionSpecificExternalValue);
        }
    }

    public void setMaximumHPPoolTCBCount(Long _maximumHPPoolTCBCount) {
        if (_maximumHPPoolTCBCount.equals(this.delegate.getMaximumHPPoolTCBCount())) {
            this.record.set("MAXHPTCBS", null);
        } else {
            RegionType.MAXIMUM_HP_POOL_TCB_COUNT.validate((Object)_maximumHPPoolTCBCount);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.MAXIMUM_HP_POOL_TCB_COUNT).set(_maximumHPPoolTCBCount, this.record.getNormalizers());
            this.record.set("MAXHPTCBS", connectionSpecificExternalValue);
        }
    }

    public void setMaximumJVMPoolTCBCount(Long _maximumJVMPoolTCBCount) {
        if (_maximumJVMPoolTCBCount.equals(this.delegate.getMaximumJVMPoolTCBCount())) {
            this.record.set("MAXJVMTCBS", null);
        } else {
            RegionType.MAXIMUM_JVM_POOL_TCB_COUNT.validate((Object)_maximumJVMPoolTCBCount);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.MAXIMUM_JVM_POOL_TCB_COUNT).set(_maximumJVMPoolTCBCount, this.record.getNormalizers());
            this.record.set("MAXJVMTCBS", connectionSpecificExternalValue);
        }
    }

    public void setDebugTool(IRegion.DebugToolValue _debugTool) {
        if (_debugTool.equals((Object)this.delegate.getDebugTool())) {
            this.record.set("DEBUGTOOL", null);
        } else {
            RegionType.DEBUG_TOOL.validate((Object)_debugTool);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.DEBUG_TOOL).set(_debugTool, this.record.getNormalizers());
            this.record.set("DEBUGTOOL", connectionSpecificExternalValue);
        }
    }

    public void setMaximumXPLinkPoolTCBCount(Long _maximumXPLinkPoolTCBCount) {
        if (_maximumXPLinkPoolTCBCount.equals(this.delegate.getMaximumXPLinkPoolTCBCount())) {
            this.record.set("MAXXPTCBS", null);
        } else {
            RegionType.MAXIMUM_XP_LINK_POOL_TCB_COUNT.validate((Object)_maximumXPLinkPoolTCBCount);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.MAXIMUM_XP_LINK_POOL_TCB_COUNT).set(_maximumXPLinkPoolTCBCount, this.record.getNormalizers());
            this.record.set("MAXXPTCBS", connectionSpecificExternalValue);
        }
    }

    public void setMaximumSSLPoolTCBCount(Long _maximumSSLPoolTCBCount) {
        if (_maximumSSLPoolTCBCount.equals(this.delegate.getMaximumSSLPoolTCBCount())) {
            this.record.set("MAXSSLTCBS", null);
        } else {
            RegionType.MAXIMUM_SSL_POOL_TCB_COUNT.validate((Object)_maximumSSLPoolTCBCount);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.MAXIMUM_SSL_POOL_TCB_COUNT).set(_maximumSSLPoolTCBCount, this.record.getNormalizers());
            this.record.set("MAXSSLTCBS", connectionSpecificExternalValue);
        }
    }

    public void setIdntyclass(IRegion.IdntyclassValue _idntyclass) {
        if (_idntyclass.equals((Object)this.delegate.getIdntyclass())) {
            this.record.set("IDNTYCLASS", null);
        } else {
            RegionType.IDNTYCLASS.validate((Object)_idntyclass);
            String connectionSpecificExternalValue = ((CICSAttribute)RegionType.IDNTYCLASS).set(_idntyclass, this.record.getNormalizers());
            this.record.set("IDNTYCLASS", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == RegionType.JOB_NAME) {
            return (V)this.getJobName();
        }
        if (attribute == RegionType.APPL_ID) {
            return (V)this.getApplID();
        }
        if (attribute == RegionType.MVS_SYSTEM_ID) {
            return (V)this.getMVSSystemID();
        }
        if (attribute == RegionType.AKP) {
            return (V)this.getAkp();
        }
        if (attribute == RegionType.MAXIMUM_TASKS) {
            return (V)this.getMaximumTasks();
        }
        if (attribute == RegionType.CICS_STATUS) {
            return (V)this.getCICSStatus();
        }
        if (attribute == RegionType.SYSTEM_DUMP_STATUS) {
            return (V)this.getSystemDumpStatus();
        }
        if (attribute == RegionType.EXTERNAL_SECURITY) {
            return (V)this.getExternalSecurity();
        }
        if (attribute == RegionType.STARTUP_TYPE) {
            return (V)this.getStartupType();
        }
        if (attribute == RegionType.STORAGE_PROTECTION) {
            return (V)this.getStorageProtection();
        }
        if (attribute == RegionType.DYNAMIC_ROUTING_PROGRAM) {
            return (V)this.getDynamicRoutingProgram();
        }
        if (attribute == RegionType.GMM_TRANSACTION) {
            return (V)this.getGMMTransaction();
        }
        if (attribute == RegionType.MRO_BATCH_REQUESTS) {
            return (V)this.getMROBatchRequests();
        }
        if (attribute == RegionType.OS_RELEASE) {
            return (V)this.getOSRelease();
        }
        if (attribute == RegionType.OS) {
            return (V)this.getOS();
        }
        if (attribute == RegionType.OS_CODE) {
            return (V)this.getOSCode();
        }
        if (attribute == RegionType.PRIORITY_AGING) {
            return (V)this.getPriorityAging();
        }
        if (attribute == RegionType.RELEASE) {
            return (V)this.getRelease();
        }
        if (attribute == RegionType.RUNAWAY) {
            return (V)this.getRunaway();
        }
        if (attribute == RegionType.SCAN_DELAY) {
            return (V)this.getScanDelay();
        }
        if (attribute == RegionType.EXIT_WAIT_TIME) {
            return (V)this.getExitWaitTime();
        }
        if (attribute == RegionType.XRF_STATUS) {
            return (V)this.getXRFStatus();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM) {
            return (V)this.getAutoinstallProgram();
        }
        if (attribute == RegionType.AUTOINSTALL_REQUEST_COUNT) {
            return (V)this.getAutoinstallRequestCount();
        }
        if (attribute == RegionType.MAXIMUM_AUTOINSTALL_REQUEST_COUNT) {
            return (V)this.getMaximumAutoinstallRequestCount();
        }
        if (attribute == RegionType.AUTOINSTALL_STATUS) {
            return (V)this.getAutoinstallStatus();
        }
        if (attribute == RegionType.DUMP_DS_SWITCH_TYPE) {
            return (V)this.getDumpDSSwitchType();
        }
        if (attribute == RegionType.DUMP_DS_SWITCH_STATUS) {
            return (V)this.getDumpDSSwitchStatus();
        }
        if (attribute == RegionType.IRC_STATUS) {
            return (V)this.getIRCStatus();
        }
        if (attribute == RegionType.EXCEPTION_MONITORING_STATUS) {
            return (V)this.getExceptionMonitoringStatus();
        }
        if (attribute == RegionType.PERFORMANCE_MONITORING_STATUS) {
            return (V)this.getPerformanceMonitoringStatus();
        }
        if (attribute == RegionType.MONITORING_STATUS) {
            return (V)this.getMonitoringStatus();
        }
        if (attribute == RegionType.EOD_STATISTICS_TIME) {
            return (V)this.getEODStatisticsTime();
        }
        if (attribute == RegionType.STATISTICS_INTERVAL) {
            return (V)this.getStatisticsInterval();
        }
        if (attribute == RegionType.NEXT_STATISTICS_TIME) {
            return (V)this.getNextStatisticsTime();
        }
        if (attribute == RegionType.STATISTICS_STATUS) {
            return (V)this.getStatisticsStatus();
        }
        if (attribute == RegionType.AUXILIARY_TRACE_STATUS) {
            return (V)this.getAuxiliaryTraceStatus();
        }
        if (attribute == RegionType.GTF_TRACE_STATUS) {
            return (V)this.getGTFTraceStatus();
        }
        if (attribute == RegionType.INTERNAL_TRACE_STATUS) {
            return (V)this.getInternalTraceStatus();
        }
        if (attribute == RegionType.AUXILIARY_TRACE_SWITCH_TYPE) {
            return (V)this.getAuxiliaryTraceSwitchType();
        }
        if (attribute == RegionType.INTERNAL_TRACE_TABLE_SIZE) {
            return (V)this.getInternalTraceTableSize();
        }
        if (attribute == RegionType.SINGLE_TRACE_STATUS) {
            return (V)this.getSingleTraceStatus();
        }
        if (attribute == RegionType.SYSTEM_TRACE_STATUS) {
            return (V)this.getSystemTraceStatus();
        }
        if (attribute == RegionType.EXIT_TRACE_STATUS) {
            return (V)this.getExitTraceStatus();
        }
        if (attribute == RegionType.USER_TRACE_STATUS) {
            return (V)this.getUserTraceStatus();
        }
        if (attribute == RegionType.LAST_RESET_TIME) {
            return (V)this.getLastResetTime();
        }
        if (attribute == RegionType.PEAK_TASK_COUNT) {
            return (V)this.getPeakTaskCount();
        }
        if (attribute == RegionType.LOADER_REQUEST_COUNT) {
            return (V)this.getLoaderRequestCount();
        }
        if (attribute == RegionType.TOTAL_LOADING_TIME) {
            return (V)this.getTotalLoadingTime();
        }
        if (attribute == RegionType.PROGRAM_REMOVE_COUNT) {
            return (V)this.getProgramRemoveCount();
        }
        if (attribute == RegionType.PRGMWAIT) {
            return (V)this.getPrgmwait();
        }
        if (attribute == RegionType.LOADER_WAIT_COUNT) {
            return (V)this.getLoaderWaitCount();
        }
        if (attribute == RegionType.PEAK_LOADER_WAIT_COUNT) {
            return (V)this.getPeakLoaderWaitCount();
        }
        if (attribute == RegionType.LOADHWMC) {
            return (V)this.getLoadhwmc();
        }
        if (attribute == RegionType.TOTAL_LOADER_WAIT_TIME) {
            return (V)this.getTotalLoaderWaitTime();
        }
        if (attribute == RegionType.RDEBRBLD) {
            return (V)this.getRdebrbld();
        }
        if (attribute == RegionType.PRGMRCMP) {
            return (V)this.getPrgmrcmp();
        }
        if (attribute == RegionType.LOADTNIU) {
            return (V)this.getLoadtniu();
        }
        if (attribute == RegionType.LOADPNIU) {
            return (V)this.getLoadpniu();
        }
        if (attribute == RegionType.LOADRNIU) {
            return (V)this.getLoadrniu();
        }
        if (attribute == RegionType.SYSDUMPS_TAKEN_COUNT) {
            return (V)this.getSysdumpsTakenCount();
        }
        if (attribute == RegionType.SYSDUMPS_SUPPRESSED_COUNT) {
            return (V)this.getSysdumpsSuppressedCount();
        }
        if (attribute == RegionType.TRANDUMPS_TAKEN_COUNT) {
            return (V)this.getTrandumpsTakenCount();
        }
        if (attribute == RegionType.TRANDUMPS_SUPPRESSED_COUNT) {
            return (V)this.getTrandumpsSuppressedCount();
        }
        if (attribute == RegionType.CICS_START_TIME) {
            return (V)this.getCICSStartTime();
        }
        if (attribute == RegionType.CICS_SYSTEM_ID) {
            return (V)this.getCICSSystemID();
        }
        if (attribute == RegionType.TOTAL_CPU) {
            return (V)this.getTotalCPU();
        }
        if (attribute == RegionType.PAGE_IN_COUNT) {
            return (V)this.getPageInCount();
        }
        if (attribute == RegionType.PAGE_OUT_COUNT) {
            return (V)this.getPageOutCount();
        }
        if (attribute == RegionType.REAL_STORAGE) {
            return (V)this.getRealStorage();
        }
        if (attribute == RegionType.IO_COUNT) {
            return (V)this.getIOCount();
        }
        if (attribute == RegionType.VTAM_STATUS) {
            return (V)this.getVTAMStatus();
        }
        if (attribute == RegionType.VTMRPLMAX) {
            return (V)this.getVtmrplmax();
        }
        if (attribute == RegionType.VTMRPLPOST) {
            return (V)this.getVtmrplpost();
        }
        if (attribute == RegionType.VTMSOSCNT) {
            return (V)this.getVtmsoscnt();
        }
        if (attribute == RegionType.VTMACBDOPE) {
            return (V)this.getVtmacbdope();
        }
        if (attribute == RegionType.CURRENT_DUMP_DS) {
            return (V)this.getCurrentDumpDS();
        }
        if (attribute == RegionType.INITIAL_DUMP_DS) {
            return (V)this.getInitialDumpDS();
        }
        if (attribute == RegionType.CURRENT_AUXILIARY_TRACE_DS) {
            return (V)this.getCurrentAuxiliaryTraceDS();
        }
        if (attribute == RegionType.LUCURR) {
            return (V)this.getLucurr();
        }
        if (attribute == RegionType.LUHWM) {
            return (V)this.getLuhwm();
        }
        if (attribute == RegionType.PRSSINQCNT) {
            return (V)this.getPrssinqcnt();
        }
        if (attribute == RegionType.PRSSNIBCNT) {
            return (V)this.getPrssnibcnt();
        }
        if (attribute == RegionType.PRSSOPNCNT) {
            return (V)this.getPrssopncnt();
        }
        if (attribute == RegionType.PRSSUNBNDCNT) {
            return (V)this.getPrssunbndcnt();
        }
        if (attribute == RegionType.PRSSERRORCNT) {
            return (V)this.getPrsserrorcnt();
        }
        if (attribute == RegionType.CONVERSEST) {
            return (V)this.getConversest();
        }
        if (attribute == RegionType.FREQUENCY) {
            return (V)this.getFrequency();
        }
        if (attribute == RegionType.SUBSYSTEMID) {
            return (V)this.getSubsystemid();
        }
        if (attribute == RegionType.SYNCPOINTST) {
            return (V)this.getSyncpointst();
        }
        if (attribute == RegionType.MONRPTTIME) {
            return (V)this.getMonrpttime();
        }
        if (attribute == RegionType.DEFAULT_USER_ID) {
            return (V)this.getDefaultUserID();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_EXIT) {
            return (V)this.getAutoinstallProgramExit();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_CATALOG_TYPE) {
            return (V)this.getAutoinstallProgramCatalogType();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_STATUS) {
            return (V)this.getAutoinstallProgramStatus();
        }
        if (attribute == RegionType.TRANSACTION_ISOLATION) {
            return (V)this.getTransactionIsolation();
        }
        if (attribute == RegionType.STARTUP_DATE) {
            return (V)this.getStartupDate();
        }
        if (attribute == RegionType.PSDINTERVAL) {
            return (V)this.getPsdinterval();
        }
        if (attribute == RegionType.TASK_COUNT) {
            return (V)this.getTaskCount();
        }
        if (attribute == RegionType.MAXIMUM_TASKS_COUNT) {
            return (V)this.getMaximumTasksCount();
        }
        if (attribute == RegionType.USER_TRANSACTION_COUNT) {
            return (V)this.getUserTransactionCount();
        }
        if (attribute == RegionType.QUEUED_TASK_COUNT) {
            return (V)this.getQueuedTaskCount();
        }
        if (attribute == RegionType.PEAK_USER_TRANSACTION_COUNT) {
            return (V)this.getPeakUserTransactionCount();
        }
        if (attribute == RegionType.PEAK_QUEUED_TASK_COUNT) {
            return (V)this.getPeakQueuedTaskCount();
        }
        if (attribute == RegionType.TOTACTVUSRTR) {
            return (V)this.getTotactvusrtr();
        }
        if (attribute == RegionType.TOTDELYUSRTR) {
            return (V)this.getTotdelyusrtr();
        }
        if (attribute == RegionType.TOTQUETIME) {
            return (V)this.getTotquetime();
        }
        if (attribute == RegionType.CURQUETIME) {
            return (V)this.getCurquetime();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_ATTEMPTS_COUNT) {
            return (V)this.getAutoinstallProgramAttemptsCount();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_REJECTS_COUNT) {
            return (V)this.getAutoinstallProgramRejectsCount();
        }
        if (attribute == RegionType.AUTOINSTALL_PROGRAM_FAILED_ATTEMPTS_COUNT) {
            return (V)this.getAutoinstallProgramFailedAttemptsCount();
        }
        if (attribute == RegionType.INITIALIZATION_STATUS) {
            return (V)this.getInitializationStatus();
        }
        if (attribute == RegionType.SHUTDOWN_STATUS) {
            return (V)this.getShutdownStatus();
        }
        if (attribute == RegionType.INTVTRANS) {
            return (V)this.getIntvtrans();
        }
        if (attribute == RegionType.GMM_TEXT) {
            return (V)this.getGMMText();
        }
        if (attribute == RegionType.GMM_LENGTH) {
            return (V)this.getGMMLength();
        }
        if (attribute == RegionType.GRNAME) {
            return (V)this.getGrname();
        }
        if (attribute == RegionType.GRSTATUS) {
            return (V)this.getGrstatus();
        }
        if (attribute == RegionType.REENTRANT_PROGRAM_PROTECTION_STATUS) {
            return (V)this.getReentrantProgramProtectionStatus();
        }
        if (attribute == RegionType.COMMAND_PROTECTION_STATUS) {
            return (V)this.getCommandProtectionStatus();
        }
        if (attribute == RegionType.SOS_BELOW_BAR) {
            return (V)this.getSOSBelowBar();
        }
        if (attribute == RegionType.TOTAL_TASK_COUNT) {
            return (V)this.getTotalTaskCount();
        }
        if (attribute == RegionType.RLS_STATUS) {
            return (V)this.getRLSStatus();
        }
        if (attribute == RegionType.SHUTDOWN_TRANSACTION) {
            return (V)this.getShutdownTransaction();
        }
        if (attribute == RegionType.DSIDLE) {
            return (V)this.getDsidle();
        }
        if (attribute == RegionType.DSINTERVAL) {
            return (V)this.getDsinterval();
        }
        if (attribute == RegionType.CICSTS_LEVEL) {
            return (V)this.getCICSTSLevel();
        }
        if (attribute == RegionType.OS_LEVEL) {
            return (V)this.getOSLevel();
        }
        if (attribute == RegionType.RRMSSTAT) {
            return (V)this.getRrmsstat();
        }
        if (attribute == RegionType.MVSSYSNAME) {
            return (V)this.getMvssysname();
        }
        if (attribute == RegionType.FORCEQR) {
            return (V)this.getForceqr();
        }
        if (attribute == RegionType.MAXIMUM_OPEN_TCB_COUNT) {
            return (V)this.getMaximumOpenTCBCount();
        }
        if (attribute == RegionType.CURRENT_OPEN_POOL_TCB_COUNT) {
            return (V)this.getCurrentOpenPoolTCBCount();
        }
        if (attribute == RegionType.DISTRIBUTED_ROUTING_PROGRAM) {
            return (V)this.getDistributedRoutingProgram();
        }
        if (attribute == RegionType.AUTOINSTALL_CONSOLE_STATUS) {
            return (V)this.getAutoinstallConsoleStatus();
        }
        if (attribute == RegionType.TCPIP_STATUS) {
            return (V)this.getTCPIPStatus();
        }
        if (attribute == RegionType.GARBAGEINT) {
            return (V)this.getGarbageint();
        }
        if (attribute == RegionType.TIMEOUTINT) {
            return (V)this.getTimeoutint();
        }
        if (attribute == RegionType.COLDSTATUS) {
            return (V)this.getColdstatus();
        }
        if (attribute == RegionType.MAXIMUM_HP_POOL_TCB_COUNT) {
            return (V)this.getMaximumHPPoolTCBCount();
        }
        if (attribute == RegionType.CURRENT_HP_POOL_TCB_COUNT) {
            return (V)this.getCurrentHPPoolTCBCount();
        }
        if (attribute == RegionType.MAXIMUM_JVM_POOL_TCB_COUNT) {
            return (V)this.getMaximumJVMPoolTCBCount();
        }
        if (attribute == RegionType.CURRENT_JVM_POOL_TCB_COUNT) {
            return (V)this.getCurrentJVMPoolTCBCount();
        }
        if (attribute == RegionType.SUBTASKS) {
            return (V)this.getSubtasks();
        }
        if (attribute == RegionType.DEBUG_TOOL) {
            return (V)this.getDebugTool();
        }
        if (attribute == RegionType.MAXIMUM_XP_LINK_POOL_TCB_COUNT) {
            return (V)this.getMaximumXPLinkPoolTCBCount();
        }
        if (attribute == RegionType.CURRENT_XP_LINK_POOL_TCB_COUNT) {
            return (V)this.getCurrentXPLinkPoolTCBCount();
        }
        if (attribute == RegionType.MAXIMUM_SSL_POOL_TCB_COUNT) {
            return (V)this.getMaximumSSLPoolTCBCount();
        }
        if (attribute == RegionType.CURRENT_SSL_POOL_TCB_COUNT) {
            return (V)this.getCurrentSSLPoolTCBCount();
        }
        if (attribute == RegionType.XCFGROUP) {
            return (V)this.getXcfgroup();
        }
        if (attribute == RegionType.STORAGE_LIMIT) {
            return (V)this.getStorageLimit();
        }
        if (attribute == RegionType.SOS_ABOVE_BAR) {
            return (V)this.getSOSAboveBar();
        }
        if (attribute == RegionType.SOS_ABOVE_LINE) {
            return (V)this.getSOSAboveLine();
        }
        if (attribute == RegionType.SOS_BELOW_LINE) {
            return (V)this.getSOSBelowLine();
        }
        if (attribute == RegionType.LDGLBSOU) {
            return (V)this.getLdglbsou();
        }
        if (attribute == RegionType.LDGLWSOU) {
            return (V)this.getLdglwsou();
        }
        if (attribute == RegionType.LDGLSORT) {
            return (V)this.getLdglsort();
        }
        if (attribute == RegionType.PSTYPE) {
            return (V)this.getPstype();
        }
        if (attribute == RegionType.IDNTYCLASS) {
            return (V)this.getIdntyclass();
        }
        if (attribute == RegionType.CURRENT_JVM_SERVER_THREAD_TCB_COUNT) {
            return (V)this.getCurrentJVMServerThreadTCBCount();
        }
        if (attribute == RegionType.MAXIMUM_JVM_SERVER_THREAD_COUNT) {
            return (V)this.getMaximumJVMServerThreadCount();
        }
        if (attribute == RegionType.JOBID) {
            return (V)this.getJobid();
        }
        if (attribute == RegionType.MAXTASKS_LAST_CHANGED_TIME) {
            return (V)this.getMAXTASKSLastChangedTime();
        }
        if (attribute == RegionType.LAST_TRANSACTION_ATTACHED_TIME) {
            return (V)this.getLastTransactionAttachedTime();
        }
        if (attribute == RegionType.MAXTASKS_LIMIT_LAST_REACHED_TIME) {
            return (V)this.getMAXTASKSLimitLastReachedTime();
        }
        if (attribute == RegionType.CURRENTLY_AT_MXT) {
            return (V)this.getCurrentlyAtMXT();
        }
        if (attribute == RegionType.REGION_USER_ID) {
            return (V)this.getRegionUserID();
        }
        if (attribute == RegionType.BMSVALIDATE) {
            return (V)this.getBmsvalidate();
        }
        if (attribute == RegionType.BMSVALIGCNT) {
            return (V)this.getBmsvaligcnt();
        }
        if (attribute == RegionType.BMSVALLGCNT) {
            return (V)this.getBmsvallgcnt();
        }
        if (attribute == RegionType.BMSVALABCNT) {
            return (V)this.getBmsvalabcnt();
        }
        if (attribute == RegionType.PLTPI_USER) {
            return (V)this.getPLTPIUser();
        }
        if (attribute == RegionType.AID_COUNT) {
            return (V)this.getAIDCount();
        }
        if (attribute == RegionType.LAST_COLD_START) {
            return (V)this.getLastColdStart();
        }
        if (attribute == RegionType.LAST_EMERGENCY_START) {
            return (V)this.getLastEmergencyStart();
        }
        if (attribute == RegionType.LAST_INITIAL_START) {
            return (V)this.getLastInitialStart();
        }
        if (attribute == RegionType.LAST_WARM_START) {
            return (V)this.getLastWarmStart();
        }
        return super.getAttributeValue(attribute);
    }

    public RegionType getObjectType() {
        return RegionType.getInstance();
    }

    @Override
    public RegionReference getCICSObjectReference() {
        return new RegionReference(this.getCICSContainer());
    }
}

