/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ResourceAssignmentInResourceDescriptionReference;
import com.ibm.cics.core.model.ResourceAssignmentInResourceDescriptionType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionDefinitionReference;
import com.ibm.cics.model.ICICSRegionGroupDefinitionReference;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.IResourceAssignmentDefinitionReference;
import com.ibm.cics.model.IResourceAssignmentInResourceDescription;
import com.ibm.cics.model.IResourceDescriptionDefinitionReference;
import com.ibm.cics.model.IResourceGroupDefinitionReference;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableResourceAssignmentInResourceDescription;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableResourceAssignmentInResourceDescription
extends MutableCPSMDefinition
implements IMutableResourceAssignmentInResourceDescription {
    private IResourceAssignmentInResourceDescription delegate;
    private MutableSMRecord record;

    public MutableResourceAssignmentInResourceDescription(ICPSM cpsm, IContext context, IResourceAssignmentInResourceDescription cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("RASINDSC");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getResourceDescription() {
        return this.delegate.getResourceDescription();
    }

    public String getResourceAssignment() {
        return this.delegate.getResourceAssignment();
    }

    public String getTargetScope() {
        String result = this.record.get("TSCOPE");
        if (result == null) {
            return this.delegate.getTargetScope();
        }
        return (String)((CICSAttribute)ResourceAssignmentInResourceDescriptionType.TARGET_SCOPE).get(result, this.record.getNormalizers());
    }

    public String getRelatedScope() {
        String result = this.record.get("RSCOPE");
        if (result == null) {
            return this.delegate.getRelatedScope();
        }
        return (String)((CICSAttribute)ResourceAssignmentInResourceDescriptionType.RELATED_SCOPE).get(result, this.record.getNormalizers());
    }

    public String getResourceGroup() {
        String result = this.record.get("RESGROUP");
        if (result == null) {
            return this.delegate.getResourceGroup();
        }
        return (String)((CICSAttribute)ResourceAssignmentInResourceDescriptionType.RESOURCE_GROUP).get(result, this.record.getNormalizers());
    }

    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)ResourceAssignmentInResourceDescriptionType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public void setTargetScope(String _targetScope) {
        if (_targetScope.equals(this.delegate.getTargetScope())) {
            this.record.set("TSCOPE", null);
        } else {
            ResourceAssignmentInResourceDescriptionType.TARGET_SCOPE.validate((Object)_targetScope);
            String connectionSpecificExternalValue = ((CICSAttribute)ResourceAssignmentInResourceDescriptionType.TARGET_SCOPE).set(_targetScope, this.record.getNormalizers());
            this.record.set("TSCOPE", connectionSpecificExternalValue);
        }
    }

    public void setRelatedScope(String _relatedScope) {
        if (_relatedScope.equals(this.delegate.getRelatedScope())) {
            this.record.set("RSCOPE", null);
        } else {
            ResourceAssignmentInResourceDescriptionType.RELATED_SCOPE.validate((Object)_relatedScope);
            String connectionSpecificExternalValue = ((CICSAttribute)ResourceAssignmentInResourceDescriptionType.RELATED_SCOPE).set(_relatedScope, this.record.getNormalizers());
            this.record.set("RSCOPE", connectionSpecificExternalValue);
        }
    }

    public void setResourceGroup(String _resourceGroup) {
        if (_resourceGroup.equals(this.delegate.getResourceGroup())) {
            this.record.set("RESGROUP", null);
        } else {
            ResourceAssignmentInResourceDescriptionType.RESOURCE_GROUP.validate((Object)_resourceGroup);
            String connectionSpecificExternalValue = ((CICSAttribute)ResourceAssignmentInResourceDescriptionType.RESOURCE_GROUP).set(_resourceGroup, this.record.getNormalizers());
            this.record.set("RESGROUP", connectionSpecificExternalValue);
        }
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESCRIPTION", null);
        } else {
            ResourceAssignmentInResourceDescriptionType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)ResourceAssignmentInResourceDescriptionType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESCRIPTION", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ResourceAssignmentInResourceDescriptionType.RESOURCE_DESCRIPTION) {
            return (V)this.getResourceDescription();
        }
        if (attribute == ResourceAssignmentInResourceDescriptionType.RESOURCE_ASSIGNMENT) {
            return (V)this.getResourceAssignment();
        }
        if (attribute == ResourceAssignmentInResourceDescriptionType.TARGET_SCOPE) {
            return (V)this.getTargetScope();
        }
        if (attribute == ResourceAssignmentInResourceDescriptionType.RELATED_SCOPE) {
            return (V)this.getRelatedScope();
        }
        if (attribute == ResourceAssignmentInResourceDescriptionType.RESOURCE_GROUP) {
            return (V)this.getResourceGroup();
        }
        if (attribute == ResourceAssignmentInResourceDescriptionType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        return super.getAttributeValue(attribute);
    }

    public ResourceAssignmentInResourceDescriptionType getObjectType() {
        return ResourceAssignmentInResourceDescriptionType.getInstance();
    }

    @Override
    public ResourceAssignmentInResourceDescriptionReference getCICSObjectReference() {
        return new ResourceAssignmentInResourceDescriptionReference(this.getCICSContainer(), this.getResourceDescription(), this.getResourceAssignment());
    }

    public IResourceDescriptionDefinitionReference getContainingDescriptions() {
        return (IResourceDescriptionDefinitionReference)ResourceAssignmentInResourceDescriptionType.CONTAINING_DESCRIPTIONS.getTo((ICICSObject)this);
    }

    public IResourceAssignmentDefinitionReference getContainingAssignments() {
        return (IResourceAssignmentDefinitionReference)ResourceAssignmentInResourceDescriptionType.CONTAINING_ASSIGNMENTS.getTo((ICICSObject)this);
    }

    public IResourceGroupDefinitionReference getContainingGroup() {
        return (IResourceGroupDefinitionReference)ResourceAssignmentInResourceDescriptionType.CONTAINING_GROUP.getTo((ICICSObject)this);
    }

    public ICICSRegionGroupDefinitionReference getRegionGroupDefinitionReferenceRelatedScope() {
        return (ICICSRegionGroupDefinitionReference)ResourceAssignmentInResourceDescriptionType.REGION_GROUP_DEFINITION_REFERENCE_RELATED_SCOPE.getTo((ICICSObject)this);
    }

    public ICICSRegionDefinitionReference getRegionDefinitionReferenceRelatedScope() {
        return (ICICSRegionDefinitionReference)ResourceAssignmentInResourceDescriptionType.REGION_DEFINITION_REFERENCE_RELATED_SCOPE.getTo((ICICSObject)this);
    }

    public ICICSRegionGroupDefinitionReference getRegionGroupDefinitionReferenceTargetScope() {
        return (ICICSRegionGroupDefinitionReference)ResourceAssignmentInResourceDescriptionType.REGION_GROUP_DEFINITION_REFERENCE_TARGET_SCOPE.getTo((ICICSObject)this);
    }

    public ICICSRegionDefinitionReference getRegionDefinitionReferenceTargetScope() {
        return (ICICSRegionDefinitionReference)ResourceAssignmentInResourceDescriptionType.REGION_DEFINITION_REFERENCE_TARGET_SCOPE.getTo((ICICSObject)this);
    }
}

