/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ResourceInDescriptionEntryReference;
import com.ibm.cics.core.model.ResourceInDescriptionEntryType;
import com.ibm.cics.core.model.internal.MutableCPSMDefinition;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICPSMDefinition;
import com.ibm.cics.model.IResourceDescriptionDefinitionReference;
import com.ibm.cics.model.IResourceGroupDefinitionReference;
import com.ibm.cics.model.IResourceInDescriptionEntry;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableResourceInDescriptionEntry;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableResourceInDescriptionEntry
extends MutableCPSMDefinition
implements IMutableResourceInDescriptionEntry {
    private IResourceInDescriptionEntry delegate;
    private MutableSMRecord record;

    public MutableResourceInDescriptionEntry(ICPSM cpsm, IContext context, IResourceInDescriptionEntry cicsObject) {
        super(cpsm, context, (ICPSMDefinition)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("RESINDSC");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getResourceDescription() {
        return this.delegate.getResourceDescription();
    }

    public String getResourceGroup() {
        return this.delegate.getResourceGroup();
    }

    public String getDescription() {
        String result = this.record.get("DESCRIPTION");
        if (result == null) {
            return this.delegate.getDescription();
        }
        return (String)((CICSAttribute)ResourceInDescriptionEntryType.DESCRIPTION).get(result, this.record.getNormalizers());
    }

    public void setDescription(String _description) {
        if (_description.equals(this.delegate.getDescription())) {
            this.record.set("DESCRIPTION", null);
        } else {
            ResourceInDescriptionEntryType.DESCRIPTION.validate((Object)_description);
            String connectionSpecificExternalValue = ((CICSAttribute)ResourceInDescriptionEntryType.DESCRIPTION).set(_description, this.record.getNormalizers());
            this.record.set("DESCRIPTION", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ResourceInDescriptionEntryType.RESOURCE_DESCRIPTION) {
            return (V)this.getResourceDescription();
        }
        if (attribute == ResourceInDescriptionEntryType.RESOURCE_GROUP) {
            return (V)this.getResourceGroup();
        }
        if (attribute == ResourceInDescriptionEntryType.DESCRIPTION) {
            return (V)this.getDescription();
        }
        return super.getAttributeValue(attribute);
    }

    public ResourceInDescriptionEntryType getObjectType() {
        return ResourceInDescriptionEntryType.getInstance();
    }

    @Override
    public ResourceInDescriptionEntryReference getCICSObjectReference() {
        return new ResourceInDescriptionEntryReference(this.getCICSContainer(), this.getResourceDescription(), this.getResourceGroup());
    }

    public IResourceGroupDefinitionReference getToResourceGroup() {
        return (IResourceGroupDefinitionReference)ResourceInDescriptionEntryType.TO_RESOURCE_GROUP.getTo((ICICSObject)this);
    }

    public IResourceDescriptionDefinitionReference getToResourceDescription() {
        return (IResourceDescriptionDefinitionReference)ResourceInDescriptionEntryType.TO_RESOURCE_DESCRIPTION.getTo((ICICSObject)this);
    }
}

